/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.mleap.classification;

import org.apache.spark.ml.classification.ProbabilisticClassifier;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.mleap.classification.SVMBase;
import org.apache.spark.ml.mleap.classification.SVMBase$class;
import org.apache.spark.ml.mleap.classification.SVMModel;
import org.apache.spark.ml.mleap.classification.SVMWithSGD;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.functions$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001u4A!\u0001\u0002\u0001\u001f\t\u00191KV'\u000b\u0005\r!\u0011AD2mCN\u001c\u0018NZ5dCRLwN\u001c\u0006\u0003\u000b\u0019\tQ!\u001c7fCBT!a\u0002\u0005\u0002\u00055d'BA\u0005\u000b\u0003\u0015\u0019\b/\u0019:l\u0015\tYA\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001b\u0005\u0019qN]4\u0004\u0001M\u0019\u0001\u0001\u0005\u0011\u0011\u000bE\u0019RcG\u000f\u000e\u0003IQ!a\u0001\u0004\n\u0005Q\u0011\"a\u0006)s_\n\f'-\u001b7jgRL7m\u00117bgNLg-[3s!\t1\u0012$D\u0001\u0018\u0015\tAb!\u0001\u0004mS:\fGnZ\u0005\u00035]\u0011aAV3di>\u0014\bC\u0001\u000f\u0001\u001b\u0005\u0011\u0001C\u0001\u000f\u001f\u0013\ty\"A\u0001\u0005T-6ku\u000eZ3m!\ta\u0012%\u0003\u0002#\u0005\t91KV'CCN,\u0007\u0002\u0003\u0013\u0001\u0005\u000b\u0007I\u0011I\u0013\u0002\u0007ULG-F\u0001'!\t9SF\u0004\u0002)W5\t\u0011FC\u0001+\u0003\u0015\u00198-\u00197b\u0013\ta\u0013&\u0001\u0004Qe\u0016$WMZ\u0005\u0003]=\u0012aa\u0015;sS:<'B\u0001\u0017*\u0011!\t\u0004A!A!\u0002\u00131\u0013\u0001B;jI\u0002BQa\r\u0001\u0005\u0002Q\na\u0001P5oSRtDCA\u000e6\u0011\u0015!#\u00071\u0001'\u0011\u0015\u0019\u0004\u0001\"\u00018)\u0005Y\u0002\"B\u001d\u0001\t\u0003Q\u0014\u0001E:fi:+X.\u0013;fe\u0006$\u0018n\u001c8t)\tYD(D\u0001\u0001\u0011\u0015i\u0004\b1\u0001?\u0003\u00151\u0018\r\\;f!\tAs(\u0003\u0002AS\t\u0019\u0011J\u001c;\t\u000b\t\u0003A\u0011A\"\u0002\u0017M,Go\u0015;faNK'0\u001a\u000b\u0003w\u0011CQ!P!A\u0002\u0015\u0003\"\u0001\u000b$\n\u0005\u001dK#A\u0002#pk\ndW\rC\u0003J\u0001\u0011\u0005!*A\u0006tKR\u0014Vm\u001a)be\u0006lGCA\u001eL\u0011\u0015i\u0004\n1\u0001F\u0011\u0015i\u0005\u0001\"\u0001O\u0003Q\u0019X\r^'j]&\u0014\u0015\r^2i\rJ\f7\r^5p]R\u00111h\u0014\u0005\u0006{1\u0003\r!\u0012\u0005\u0006#\u0002!\tAU\u0001\u0010g\u0016$h)\u001b;J]R,'oY3qiR\u00111h\u0015\u0005\u0006{A\u0003\r\u0001\u0016\t\u0003QUK!AV\u0015\u0003\u000f\t{w\u000e\\3b]\")\u0001\f\u0001C\u00013\u0006a1/\u001a;UQJ,7\u000f[8mIR\u00111H\u0017\u0005\u0006{]\u0003\r!\u0012\u0005\u00069\u0002!\t%X\u0001\u0005G>\u0004\u0018\u0010\u0006\u0002\u001c=\")ql\u0017a\u0001A\u0006)Q\r\u001f;sCB\u0011\u0011\rZ\u0007\u0002E*\u00111MB\u0001\u0006a\u0006\u0014\u0018-\\\u0005\u0003K\n\u0014\u0001\u0002U1sC6l\u0015\r\u001d\u0005\u0006O\u0002!\t\u0006[\u0001\u0006iJ\f\u0017N\u001c\u000b\u0003;%DQA\u001b4A\u0002-\fq\u0001Z1uCN,G\u000f\r\u0002miB\u0019Q\u000e\u001d:\u000e\u00039T!a\u001c\u0005\u0002\u0007M\fH.\u0003\u0002r]\n9A)\u0019;bg\u0016$\bCA:u\u0019\u0001!\u0011\"^5\u0002\u0002\u0003\u0005)\u0011\u0001<\u0003\u0007}#\u0013'\u0005\u0002xuB\u0011\u0001\u0006_\u0005\u0003s&\u0012qAT8uQ&tw\r\u0005\u0002)w&\u0011A0\u000b\u0002\u0004\u0003:L\b")
public class SVM
extends ProbabilisticClassifier<Vector, SVM, SVMModel>
implements SVMBase {
    private final String uid;
    private final DoubleParam stepSize;
    private final IntParam numIterations;
    private final DoubleParam regParam;
    private final DoubleParam miniBatchFraction;
    private final BooleanParam fitIntercept;
    private final DoubleParam threshold;

    @Override
    public final DoubleParam stepSize() {
        return this.stepSize;
    }

    @Override
    public final IntParam numIterations() {
        return this.numIterations;
    }

    @Override
    public final DoubleParam regParam() {
        return this.regParam;
    }

    @Override
    public final DoubleParam miniBatchFraction() {
        return this.miniBatchFraction;
    }

    @Override
    public final BooleanParam fitIntercept() {
        return this.fitIntercept;
    }

    @Override
    public final DoubleParam threshold() {
        return this.threshold;
    }

    @Override
    public final void org$apache$spark$ml$mleap$classification$SVMBase$_setter_$stepSize_$eq(DoubleParam x$1) {
        this.stepSize = x$1;
    }

    @Override
    public final void org$apache$spark$ml$mleap$classification$SVMBase$_setter_$numIterations_$eq(IntParam x$1) {
        this.numIterations = x$1;
    }

    @Override
    public final void org$apache$spark$ml$mleap$classification$SVMBase$_setter_$regParam_$eq(DoubleParam x$1) {
        this.regParam = x$1;
    }

    @Override
    public final void org$apache$spark$ml$mleap$classification$SVMBase$_setter_$miniBatchFraction_$eq(DoubleParam x$1) {
        this.miniBatchFraction = x$1;
    }

    @Override
    public final void org$apache$spark$ml$mleap$classification$SVMBase$_setter_$fitIntercept_$eq(BooleanParam x$1) {
        this.fitIntercept = x$1;
    }

    @Override
    public final void org$apache$spark$ml$mleap$classification$SVMBase$_setter_$threshold_$eq(DoubleParam x$1) {
        this.threshold = x$1;
    }

    @Override
    public final double getStepSize() {
        return SVMBase$class.getStepSize(this);
    }

    @Override
    public final int getNumIterations() {
        return SVMBase$class.getNumIterations(this);
    }

    @Override
    public final double getRegParam() {
        return SVMBase$class.getRegParam(this);
    }

    @Override
    public final double getMiniBatchFraction() {
        return SVMBase$class.getMiniBatchFraction(this);
    }

    @Override
    public final boolean getFitIntercept() {
        return SVMBase$class.getFitIntercept(this);
    }

    @Override
    public final double getThreshold() {
        return SVMBase$class.getThreshold(this);
    }

    public String uid() {
        return this.uid;
    }

    public SVM setNumIterations(int value) {
        return (SVM)this.set((Param)this.numIterations(), BoxesRunTime.boxToInteger((int)value));
    }

    public SVM setStepSize(double value) {
        return (SVM)this.set((Param)this.stepSize(), BoxesRunTime.boxToDouble((double)value));
    }

    public SVM setRegParam(double value) {
        return (SVM)this.set((Param)this.regParam(), BoxesRunTime.boxToDouble((double)value));
    }

    public SVM setMiniBatchFraction(double value) {
        return (SVM)this.set((Param)this.miniBatchFraction(), BoxesRunTime.boxToDouble((double)value));
    }

    public SVM setFitIntercept(boolean value) {
        return (SVM)this.set((Param)this.fitIntercept(), BoxesRunTime.boxToBoolean((boolean)value));
    }

    public SVM setThreshold(double value) {
        return (SVM)this.set((Param)this.threshold(), BoxesRunTime.boxToDouble((double)value));
    }

    public SVM copy(ParamMap extra) {
        return (SVM)this.defaultCopy(extra);
    }

    public SVMModel train(Dataset<?> dataset) {
        RDD labeledPoints = dataset.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col((String)this.$(this.featuresCol())), functions$.MODULE$.col((String)this.$(this.labelCol()))})).rdd().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final LabeledPoint apply(Row x0$1) {
                Row row = x0$1;
                Some some = Row$.MODULE$.unapplySeq(row);
                if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0) {
                    Object label = ((SeqLike)some.get()).apply(0);
                    Object features = ((SeqLike)some.get()).apply(1);
                    if (label instanceof Double) {
                        double d = BoxesRunTime.unboxToDouble((Object)label);
                        if (features instanceof Vector) {
                            Vector vector = (Vector)features;
                            LabeledPoint labeledPoint = new LabeledPoint(d, Vectors$.MODULE$.dense(vector.toArray()));
                            return labeledPoint;
                        }
                    }
                }
                throw new MatchError((Object)row);
            }
        }, ClassTag$.MODULE$.apply(LabeledPoint.class));
        org.apache.spark.mllib.classification.SVMModel mllibModel = ((org.apache.spark.mllib.classification.SVMModel)new SVMWithSGD(this.getStepSize(), this.getNumIterations(), this.getRegParam(), this.getMiniBatchFraction()).setIntercept(this.getFitIntercept()).run(labeledPoints)).setThreshold(this.getThreshold());
        return new SVMModel(mllibModel);
    }

    public SVM(String uid) {
        this.uid = uid;
        SVMBase$class.$init$(this);
        this.setDefault((Param)this.stepSize(), BoxesRunTime.boxToDouble((double)1.0));
        this.setDefault((Param)this.regParam(), BoxesRunTime.boxToDouble((double)0.01));
        this.setDefault((Param)this.miniBatchFraction(), BoxesRunTime.boxToDouble((double)1.0));
        this.setDefault((Param)this.fitIntercept(), BoxesRunTime.boxToBoolean((boolean)true));
        this.setDefault((Param)this.threshold(), BoxesRunTime.boxToDouble((double)0.5));
    }

    public SVM() {
        this(Identifiable$.MODULE$.randomUID("svm"));
    }
}

