/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.mleap.classification;

import org.apache.spark.ml.classification.ProbabilisticClassificationModel;
import org.apache.spark.ml.linalg.DenseVector;
import org.apache.spark.ml.linalg.SparseVector;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.mleap.classification.SVMBase;
import org.apache.spark.ml.mleap.classification.SVMBase$class;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.mllib.linalg.BLAS$;
import scala.MatchError;
import scala.Predef$;
import scala.collection.Seq;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u000194A!\u0001\u0002\u0001\u001f\tA1KV'N_\u0012,GN\u0003\u0002\u0004\t\u0005q1\r\\1tg&4\u0017nY1uS>t'BA\u0003\u0007\u0003\u0015iG.Z1q\u0015\t9\u0001\"\u0001\u0002nY*\u0011\u0011BC\u0001\u0006gB\f'o\u001b\u0006\u0003\u00171\ta!\u00199bG\",'\"A\u0007\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001\u0001R\u0004\u0005\u0003\u0012'UYR\"\u0001\n\u000b\u0005\r1\u0011B\u0001\u000b\u0013\u0005\u0001\u0002&o\u001c2bE&d\u0017n\u001d;jG\u000ec\u0017m]:jM&\u001c\u0017\r^5p]6{G-\u001a7\u0011\u0005YIR\"A\f\u000b\u0005a1\u0011A\u00027j]\u0006dw-\u0003\u0002\u001b/\t1a+Z2u_J\u0004\"\u0001\b\u0001\u000e\u0003\t\u0001\"\u0001\b\u0010\n\u0005}\u0011!aB*W\u001b\n\u000b7/\u001a\u0005\tC\u0001\u0011)\u0019!C!E\u0005\u0019Q/\u001b3\u0016\u0003\r\u0002\"\u0001\n\u0016\u000f\u0005\u0015BS\"\u0001\u0014\u000b\u0003\u001d\nQa]2bY\u0006L!!\u000b\u0014\u0002\rA\u0013X\rZ3g\u0013\tYCF\u0001\u0004TiJLgn\u001a\u0006\u0003S\u0019B\u0001B\f\u0001\u0003\u0002\u0003\u0006IaI\u0001\u0005k&$\u0007\u0005\u0003\u00051\u0001\t\u0015\r\u0011\"\u00012\u0003\u0015iw\u000eZ3m+\u0005\u0011\u0004CA\u001a8\u001b\u0005!$BA\u00026\u0015\t1\u0004\"A\u0003nY2L'-\u0003\u0002\u0002i!A\u0011\b\u0001B\u0001B\u0003%!'\u0001\u0004n_\u0012,G\u000e\t\u0005\u0006w\u0001!\t\u0001P\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007mid\bC\u0003\"u\u0001\u00071\u0005C\u00031u\u0001\u0007!\u0007C\u0003<\u0001\u0011\u0005\u0001\t\u0006\u0002\u001c\u0003\")\u0001g\u0010a\u0001e!)1\t\u0001C\u0001\t\u0006a1/\u001a;UQJ,7\u000f[8mIR\u0011QIR\u0007\u0002\u0001!)qI\u0011a\u0001\u0011\u0006)a/\u00197vKB\u0011Q%S\u0005\u0003\u0015\u001a\u0012a\u0001R8vE2,\u0007\"\u0002'\u0001\t\u0003i\u0015AB7be\u001eLg\u000e\u0006\u0002I\u001d\")qj\u0013a\u0001+\u0005Aa-Z1ukJ,7\u000fC\u0003R\u0001\u0011E#+A\u0004qe\u0016$\u0017n\u0019;\u0015\u0005!\u001b\u0006\"B(Q\u0001\u0004)\u0002\"B+\u0001\t#2\u0016A\u00039sK\u0012L7\r\u001e*boR\u0011Qc\u0016\u0005\u0006\u001fR\u0003\r!\u0006\u0005\u00063\u0002!\tEW\u0001\u000b]Vl7\t\\1tg\u0016\u001cX#A.\u0011\u0005\u0015b\u0016BA/'\u0005\rIe\u000e\u001e\u0005\u0006?\u0002!\t\u0005Y\u0001\u0005G>\u0004\u0018\u0010\u0006\u0002\u001cC\")!M\u0018a\u0001G\u0006)Q\r\u001f;sCB\u0011AmZ\u0007\u0002K*\u0011aMB\u0001\u0006a\u0006\u0014\u0018-\\\u0005\u0003Q\u0016\u0014\u0001\u0002U1sC6l\u0015\r\u001d\u0005\u0006U\u0002!\tf[\u0001\u0017e\u0006<(\u0007\u001d:pE\u0006\u0014\u0017\u000e\\5us&s\u0007\u000b\\1dKR\u0011Q\u0003\u001c\u0005\u0006[&\u0004\r!F\u0001\u000ee\u0006<\bK]3eS\u000e$\u0018n\u001c8")
public class SVMModel
extends ProbabilisticClassificationModel<Vector, SVMModel>
implements SVMBase {
    private final String uid;
    private final org.apache.spark.mllib.classification.SVMModel model;
    private final DoubleParam stepSize;
    private final IntParam numIterations;
    private final DoubleParam regParam;
    private final DoubleParam miniBatchFraction;
    private final BooleanParam fitIntercept;
    private final DoubleParam threshold;

    @Override
    public final DoubleParam stepSize() {
        return this.stepSize;
    }

    @Override
    public final IntParam numIterations() {
        return this.numIterations;
    }

    @Override
    public final DoubleParam regParam() {
        return this.regParam;
    }

    @Override
    public final DoubleParam miniBatchFraction() {
        return this.miniBatchFraction;
    }

    @Override
    public final BooleanParam fitIntercept() {
        return this.fitIntercept;
    }

    @Override
    public final DoubleParam threshold() {
        return this.threshold;
    }

    @Override
    public final void org$apache$spark$ml$mleap$classification$SVMBase$_setter_$stepSize_$eq(DoubleParam x$1) {
        this.stepSize = x$1;
    }

    @Override
    public final void org$apache$spark$ml$mleap$classification$SVMBase$_setter_$numIterations_$eq(IntParam x$1) {
        this.numIterations = x$1;
    }

    @Override
    public final void org$apache$spark$ml$mleap$classification$SVMBase$_setter_$regParam_$eq(DoubleParam x$1) {
        this.regParam = x$1;
    }

    @Override
    public final void org$apache$spark$ml$mleap$classification$SVMBase$_setter_$miniBatchFraction_$eq(DoubleParam x$1) {
        this.miniBatchFraction = x$1;
    }

    @Override
    public final void org$apache$spark$ml$mleap$classification$SVMBase$_setter_$fitIntercept_$eq(BooleanParam x$1) {
        this.fitIntercept = x$1;
    }

    @Override
    public final void org$apache$spark$ml$mleap$classification$SVMBase$_setter_$threshold_$eq(DoubleParam x$1) {
        this.threshold = x$1;
    }

    @Override
    public final double getStepSize() {
        return SVMBase$class.getStepSize(this);
    }

    @Override
    public final int getNumIterations() {
        return SVMBase$class.getNumIterations(this);
    }

    @Override
    public final double getRegParam() {
        return SVMBase$class.getRegParam(this);
    }

    @Override
    public final double getMiniBatchFraction() {
        return SVMBase$class.getMiniBatchFraction(this);
    }

    @Override
    public final boolean getFitIntercept() {
        return SVMBase$class.getFitIntercept(this);
    }

    @Override
    public final double getThreshold() {
        return SVMBase$class.getThreshold(this);
    }

    public String uid() {
        return this.uid;
    }

    public org.apache.spark.mllib.classification.SVMModel model() {
        return this.model;
    }

    public SVMModel setThreshold(double value) {
        this.model().setThreshold(value);
        return (SVMModel)this.set((Param)this.threshold(), BoxesRunTime.boxToDouble((double)value));
    }

    public double margin(Vector features) {
        return BLAS$.MODULE$.dot(this.model().weights(), org.apache.spark.mllib.linalg.Vectors$.MODULE$.dense(features.toArray())) + this.model().intercept();
    }

    public double predict(Vector features) {
        return this.margin(features) > this.getThreshold() ? 1.0 : 0.0;
    }

    public Vector predictRaw(Vector features) {
        double m = this.margin(features);
        return Vectors$.MODULE$.dense(-m, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{m}));
    }

    public int numClasses() {
        return 2;
    }

    public SVMModel copy(ParamMap extra) {
        return (SVMModel)this.defaultCopy(extra);
    }

    public Vector raw2probabilityInPlace(Vector rawPrediction) {
        Vector vector = rawPrediction;
        if (vector instanceof DenseVector) {
            DenseVector denseVector = (DenseVector)vector;
            int size = denseVector.size();
            for (int i = 0; i < size; ++i) {
                denseVector.values()[i] = 1.0 / (1.0 + package$.MODULE$.exp(-denseVector.values()[i]));
            }
            DenseVector denseVector2 = denseVector;
            return denseVector2;
        }
        if (vector instanceof SparseVector) {
            throw new RuntimeException("Unexpected error in LogisticRegressionModel: raw2probabilitiesInPlace encountered SparseVector");
        }
        throw new MatchError((Object)vector);
    }

    public SVMModel(String uid, org.apache.spark.mllib.classification.SVMModel model) {
        this.uid = uid;
        this.model = model;
        SVMBase$class.$init$(this);
        this.setDefault((Param)this.threshold(), BoxesRunTime.boxToDouble((double)0.5));
    }

    public SVMModel(org.apache.spark.mllib.classification.SVMModel model) {
        this(Identifiable$.MODULE$.randomUID("svmModel"), model);
    }
}

