/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.mleap.feature;

import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.ml.Estimator;
import org.apache.spark.ml.attribute.Attribute;
import org.apache.spark.ml.attribute.Attribute$;
import org.apache.spark.ml.attribute.AttributeGroup;
import org.apache.spark.ml.attribute.AttributeGroup$;
import org.apache.spark.ml.attribute.BinaryAttribute;
import org.apache.spark.ml.attribute.BinaryAttribute$;
import org.apache.spark.ml.attribute.NominalAttribute;
import org.apache.spark.ml.attribute.NumericAttribute;
import org.apache.spark.ml.mleap.feature.OneHotEncoder$;
import org.apache.spark.ml.mleap.feature.OneHotEncoderBase;
import org.apache.spark.ml.mleap.feature.OneHotEncoderModel;
import org.apache.spark.ml.mleap.param.HasDropLast$class;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.ParamPair;
import org.apache.spark.ml.param.Params;
import org.apache.spark.ml.param.shared.HasInputCol;
import org.apache.spark.ml.param.shared.HasOutputCol;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.NumericType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001Q4A!\u0001\u0002\u0001\u001f\tiqJ\\3I_R,enY8eKJT!a\u0001\u0003\u0002\u000f\u0019,\u0017\r^;sK*\u0011QAB\u0001\u0006[2,\u0017\r\u001d\u0006\u0003\u000f!\t!!\u001c7\u000b\u0005%Q\u0011!B:qCJ\\'BA\u0006\r\u0003\u0019\t\u0007/Y2iK*\tQ\"A\u0002pe\u001e\u001c\u0001aE\u0002\u0001!a\u00012!\u0005\n\u0015\u001b\u00051\u0011BA\n\u0007\u0005%)5\u000f^5nCR|'\u000f\u0005\u0002\u0016-5\t!!\u0003\u0002\u0018\u0005\t\u0011rJ\\3I_R,enY8eKJlu\u000eZ3m!\t)\u0012$\u0003\u0002\u001b\u0005\t\trJ\\3I_R,enY8eKJ\u0014\u0015m]3\t\u0011q\u0001!Q1A\u0005Bu\t1!^5e+\u0005q\u0002CA\u0010&\u001d\t\u00013%D\u0001\"\u0015\u0005\u0011\u0013!B:dC2\f\u0017B\u0001\u0013\"\u0003\u0019\u0001&/\u001a3fM&\u0011ae\n\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u0011\n\u0003\u0002C\u0015\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0010\u0002\tULG\r\t\u0005\u0006W\u0001!\t\u0001L\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00055r\u0003CA\u000b\u0001\u0011\u0015a\"\u00061\u0001\u001f\u0011\u0015\u0001\u0004\u0001\"\u00012\u0003-\u0019X\r\u001e#s_Bd\u0015m\u001d;\u0015\u0005I\u001aT\"\u0001\u0001\t\u000bQz\u0003\u0019A\u001b\u0002\u000bY\fG.^3\u0011\u0005\u00012\u0014BA\u001c\"\u0005\u001d\u0011un\u001c7fC:DQ!\u000f\u0001\u0005\u0002i\n1b]3u\u0013:\u0004X\u000f^\"pYR\u0011!g\u000f\u0005\u0006ia\u0002\rA\b\u0005\u0006{\u0001!\tAP\u0001\rg\u0016$x*\u001e;qkR\u001cu\u000e\u001c\u000b\u0003e}BQ\u0001\u000e\u001fA\u0002yAQ!\u0011\u0001\u0005B\t\u000b1AZ5u)\t!2\tC\u0003E\u0001\u0002\u0007Q)A\u0004eCR\f7/\u001a;1\u0005\u0019s\u0005cA$K\u00196\t\u0001J\u0003\u0002J\u0011\u0005\u00191/\u001d7\n\u0005-C%a\u0002#bi\u0006\u001cX\r\u001e\t\u0003\u001b:c\u0001\u0001B\u0005P\u0007\u0006\u0005\t\u0011!B\u0001!\n\u0019q\f\n\u001a\u0012\u0005E#\u0006C\u0001\u0011S\u0013\t\u0019\u0016EA\u0004O_RD\u0017N\\4\u0011\u0005\u0001*\u0016B\u0001,\"\u0005\r\te.\u001f\u0005\u00061\u0002!\t%W\u0001\u0005G>\u0004\u0018\u0010\u0006\u0002\u00115\")1l\u0016a\u00019\u0006)Q\r\u001f;sCB\u0011Q\fY\u0007\u0002=*\u0011qLB\u0001\u0006a\u0006\u0014\u0018-\\\u0005\u0003Cz\u0013\u0001\u0002U1sC6l\u0015\r\u001d\u0005\u0006G\u0002!\t\u0005Z\u0001\u0010iJ\fgn\u001d4pe6\u001c6\r[3nCR\u0011Qm\u001b\t\u0003M&l\u0011a\u001a\u0006\u0003Q\"\u000bQ\u0001^=qKNL!A[4\u0003\u0015M#(/^2u)f\u0004X\rC\u0003mE\u0002\u0007Q-\u0001\u0004tG\",W.\u0019\u0015\u0003E:\u0004\"a\u001c:\u000e\u0003AT!!\u001d\u0005\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002ta\naA)\u001a<fY>\u0004XM]!qS\u0002")
public class OneHotEncoder
extends Estimator<OneHotEncoderModel>
implements OneHotEncoderBase {
    private final String uid;
    private final BooleanParam dropLast;
    private final Param<String> outputCol;
    private final Param<String> inputCol;

    @Override
    public final BooleanParam dropLast() {
        return this.dropLast;
    }

    @Override
    public final void org$apache$spark$ml$mleap$param$HasDropLast$_setter_$dropLast_$eq(BooleanParam x$1) {
        this.dropLast = x$1;
    }

    @Override
    public final boolean getDropLast() {
        return HasDropLast$class.getDropLast(this);
    }

    public final Param<String> outputCol() {
        return this.outputCol;
    }

    public final void org$apache$spark$ml$param$shared$HasOutputCol$_setter_$outputCol_$eq(Param x$1) {
        this.outputCol = x$1;
    }

    public final String getOutputCol() {
        return HasOutputCol.class.getOutputCol((HasOutputCol)this);
    }

    public final Param<String> inputCol() {
        return this.inputCol;
    }

    public final void org$apache$spark$ml$param$shared$HasInputCol$_setter_$inputCol_$eq(Param x$1) {
        this.inputCol = x$1;
    }

    public final String getInputCol() {
        return HasInputCol.class.getInputCol((HasInputCol)this);
    }

    public String uid() {
        return this.uid;
    }

    public OneHotEncoder setDropLast(boolean value) {
        return (OneHotEncoder)this.set((Param)this.dropLast(), BoxesRunTime.boxToBoolean((boolean)value));
    }

    public OneHotEncoder setInputCol(String value) {
        return (OneHotEncoder)this.set(this.inputCol(), value);
    }

    public OneHotEncoder setOutputCol(String value) {
        return (OneHotEncoder)this.set(this.outputCol(), value);
    }

    public OneHotEncoderModel fit(Dataset<?> dataset) {
        String inputColName = (String)this.$(this.inputCol());
        String outputColName = (String)this.$(this.outputCol());
        boolean shouldDropLast = BoxesRunTime.unboxToBoolean((Object)this.$((Param)this.dropLast()));
        AttributeGroup outputAttrGroup = AttributeGroup$.MODULE$.fromStructField(this.transformSchema(dataset.schema()).apply(outputColName));
        if (outputAttrGroup.size() < 0) {
            int numAttrs = (int)BoxesRunTime.unboxToDouble((Object)dataset.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{dataset.col(inputColName).cast((DataType)DoubleType$.MODULE$)})).rdd().map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final double apply(Row x$5) {
                    return x$5.getDouble(0);
                }
            }, ClassTag$.MODULE$.Double()).aggregate((Object)BoxesRunTime.boxToDouble((double)0.0), (Function2)new Serializable(this, inputColName){
                public static final long serialVersionUID = 0L;
                public final String inputColName$2;

                public final double apply(double m, double x) {
                    return this.apply$mcDDD$sp(m, x);
                }

                public double apply$mcDDD$sp(double m, double x) {
                    Predef$.MODULE$.assert(x <= (double)Integer.MAX_VALUE, (Function0)new Serializable(this, x){
                        public static final long serialVersionUID = 0L;
                        private final double x$10;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"OneHotEncoder only supports up to ", " indices, but got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)Integer.MAX_VALUE), BoxesRunTime.boxToDouble((double)this.x$10)}));
                        }
                        {
                            this.x$10 = x$10;
                        }
                    });
                    Predef$.MODULE$.assert(x >= 0.0 && x == (double)((int)x), (Function0)new Serializable(this, x){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$1 $outer;
                        private final double x$10;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Values from column ", " must be indices, but got ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.inputColName$2, BoxesRunTime.boxToDouble((double)this.x$10)}));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.x$10 = x$10;
                        }
                    });
                    return package$.MODULE$.max(m, x);
                }
                {
                    this.inputColName$2 = inputColName$2;
                }
            }, (Function2)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final double apply(double m0, double m1) {
                    return this.apply$mcDDD$sp(m0, m1);
                }

                public double apply$mcDDD$sp(double m0, double m1) {
                    return package$.MODULE$.max(m0, m1);
                }
            }, ClassTag$.MODULE$.Double())) + 1;
            String[] outputAttrNames = (String[])Array$.MODULE$.tabulate(numAttrs, (Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(int x$6) {
                    return ((Object)BoxesRunTime.boxToInteger((int)x$6)).toString();
                }
            }, ClassTag$.MODULE$.apply(String.class));
            String[] filtered = shouldDropLast ? (String[])Predef$.MODULE$.refArrayOps((Object[])outputAttrNames).dropRight(1) : outputAttrNames;
            Attribute[] outputAttrs = (Attribute[])Predef$.MODULE$.refArrayOps((Object[])filtered).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final BinaryAttribute apply(String name) {
                    return BinaryAttribute$.MODULE$.defaultAttr().withName(name);
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Attribute.class)));
            outputAttrGroup = new AttributeGroup(outputColName, outputAttrs);
        }
        int size = outputAttrGroup.size();
        return (OneHotEncoderModel)this.copyValues((Params)new OneHotEncoderModel(this.uid(), size).setParent(this), this.copyValues$default$2());
    }

    public Estimator<OneHotEncoderModel> copy(ParamMap extra) {
        return (Estimator)this.defaultCopy(extra);
    }

    @DeveloperApi
    public StructType transformSchema(StructType schema) {
        AttributeGroup attributeGroup;
        None$ none$;
        Attribute inputAttr;
        String inputColName = (String)this.$(this.inputCol());
        String outputColName = (String)this.$(this.outputCol());
        Predef$.MODULE$.require(schema.apply(inputColName).dataType() instanceof NumericType, (Function0)new Serializable(this, schema, inputColName){
            public static final long serialVersionUID = 0L;
            private final StructType schema$2;
            private final String inputColName$3;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Input column must be of type NumericType but got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.schema$2.apply(this.inputColName$3).dataType()}));
            }
            {
                this.schema$2 = schema$2;
                this.inputColName$3 = inputColName$3;
            }
        });
        StructField[] inputFields = schema.fields();
        Predef$.MODULE$.require(!Predef$.MODULE$.refArrayOps((Object[])inputFields).exists((Function1)new Serializable(this, outputColName){
            public static final long serialVersionUID = 0L;
            private final String outputColName$2;

            public final boolean apply(StructField x$7) {
                String string = x$7.name();
                String string2 = this.outputColName$2;
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
            {
                this.outputColName$2 = outputColName$2;
            }
        }), (Function0)new Serializable(this, outputColName){
            public static final long serialVersionUID = 0L;
            private final String outputColName$2;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Output column ", " already exists."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.outputColName$2}));
            }
            {
                this.outputColName$2 = outputColName$2;
            }
        });
        Attribute attribute = inputAttr = Attribute$.MODULE$.fromStructField(schema.apply(inputColName));
        if (attribute instanceof NominalAttribute) {
            NominalAttribute nominalAttribute = (NominalAttribute)attribute;
            none$ = nominalAttribute.values().isDefined() ? nominalAttribute.values() : (nominalAttribute.numValues().isDefined() ? nominalAttribute.numValues().map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String[] apply(int n) {
                    return (String[])Array$.MODULE$.tabulate(n, (Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply(int x$8) {
                            return ((Object)BoxesRunTime.boxToInteger((int)x$8)).toString();
                        }
                    }, ClassTag$.MODULE$.apply(String.class));
                }
            }) : None$.MODULE$);
        } else if (attribute instanceof BinaryAttribute) {
            BinaryAttribute binaryAttribute = (BinaryAttribute)attribute;
            none$ = binaryAttribute.values().isDefined() ? binaryAttribute.values() : new Some(Array$.MODULE$.tabulate(2, (Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(int x$9) {
                    return ((Object)BoxesRunTime.boxToInteger((int)x$9)).toString();
                }
            }, ClassTag$.MODULE$.apply(String.class)));
        } else {
            if (attribute instanceof NumericAttribute) {
                throw new RuntimeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The input column ", " cannot be numeric."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{inputColName})));
            }
            none$ = None$.MODULE$;
        }
        None$ outputAttrNames = none$;
        Option filteredOutputAttrNames = outputAttrNames.map((Function1)new Serializable(this, inputColName){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OneHotEncoder $outer;
            public final String inputColName$3;

            public final String[] apply(String[] names) {
                String[] stringArray;
                if (BoxesRunTime.unboxToBoolean((Object)this.$outer.$((Param)this.$outer.dropLast()))) {
                    Predef$.MODULE$.require(names.length > 1, (Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$15 $outer;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The input column ", " should have at least two distinct values."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.inputColName$3}));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                    stringArray = (String[])Predef$.MODULE$.refArrayOps((Object[])names).dropRight(1);
                } else {
                    stringArray = names;
                }
                return stringArray;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.inputColName$3 = inputColName$3;
            }
        });
        if (filteredOutputAttrNames.isDefined()) {
            Attribute[] attrs = (Attribute[])Predef$.MODULE$.refArrayOps((Object[])filteredOutputAttrNames.get()).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final BinaryAttribute apply(String name) {
                    return BinaryAttribute$.MODULE$.defaultAttr().withName(name);
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Attribute.class)));
            attributeGroup = new AttributeGroup((String)this.$(this.outputCol()), attrs);
        } else {
            attributeGroup = new AttributeGroup((String)this.$(this.outputCol()));
        }
        AttributeGroup outputAttrGroup = attributeGroup;
        StructField[] outputFields = (StructField[])Predef$.MODULE$.refArrayOps((Object[])inputFields).$colon$plus((Object)outputAttrGroup.toStructField(), ClassTag$.MODULE$.apply(StructField.class));
        return new StructType(outputFields);
    }

    public OneHotEncoder(String uid) {
        this.uid = uid;
        HasInputCol.class.$init$((HasInputCol)this);
        HasOutputCol.class.$init$((HasOutputCol)this);
        HasDropLast$class.$init$(this);
        this.setDefault((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.dropLast().$minus$greater((Object)BoxesRunTime.boxToBoolean((boolean)true))}));
    }
}

