/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.mleap.feature;

import ml.combust.mleap.core.annotation.SparkCode;
import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.ml.Estimator;
import org.apache.spark.ml.attribute.Attribute;
import org.apache.spark.ml.attribute.Attribute$;
import org.apache.spark.ml.attribute.AttributeGroup;
import org.apache.spark.ml.attribute.AttributeGroup$;
import org.apache.spark.ml.attribute.BinaryAttribute;
import org.apache.spark.ml.attribute.BinaryAttribute$;
import org.apache.spark.ml.attribute.NominalAttribute;
import org.apache.spark.ml.attribute.NumericAttribute;
import org.apache.spark.ml.mleap.feature.OneHotEncoder$;
import org.apache.spark.ml.mleap.feature.OneHotEncoderBase;
import org.apache.spark.ml.mleap.feature.OneHotEncoderModel;
import org.apache.spark.ml.mleap.param.HasDropLast$class;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.ParamPair;
import org.apache.spark.ml.param.Params;
import org.apache.spark.ml.param.shared.HasInputCol;
import org.apache.spark.ml.param.shared.HasOutputCol;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.NumericType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@SparkCode(uri="https://github.com/apache/spark/blob/v2.0.0/mllib/src/main/scala/org/apache/spark/ml/feature/OneHotEncoder.scala")
@ScalaSignature(bytes="\u0006\u0001\u0005-a\u0001B\u0001\u0003\u0001=\u0011Qb\u00148f\u0011>$XI\\2pI\u0016\u0014(BA\u0002\u0005\u0003\u001d1W-\u0019;ve\u0016T!!\u0002\u0004\u0002\u000b5dW-\u00199\u000b\u0005\u001dA\u0011AA7m\u0015\tI!\"A\u0003ta\u0006\u00148N\u0003\u0002\f\u0019\u00051\u0011\r]1dQ\u0016T\u0011!D\u0001\u0004_J<7\u0001A\n\u0004\u0001AA\u0002cA\t\u0013)5\ta!\u0003\u0002\u0014\r\tIQi\u001d;j[\u0006$xN\u001d\t\u0003+Yi\u0011AA\u0005\u0003/\t\u0011!c\u00148f\u0011>$XI\\2pI\u0016\u0014Xj\u001c3fYB\u0011Q#G\u0005\u00035\t\u0011\u0011c\u00148f\u0011>$XI\\2pI\u0016\u0014()Y:f\u0011!a\u0002A!b\u0001\n\u0003j\u0012aA;jIV\ta\u0004\u0005\u0002 K9\u0011\u0001eI\u0007\u0002C)\t!%A\u0003tG\u0006d\u0017-\u0003\u0002%C\u00051\u0001K]3eK\u001aL!AJ\u0014\u0003\rM#(/\u001b8h\u0015\t!\u0013\u0005\u0003\u0005*\u0001\t\u0005\t\u0015!\u0003\u001f\u0003\u0011)\u0018\u000e\u001a\u0011\t\u000b-\u0002A\u0011\u0001\u0017\u0002\rqJg.\u001b;?)\tic\u0006\u0005\u0002\u0016\u0001!)AD\u000ba\u0001=!)1\u0006\u0001C\u0001aQ\tQ\u0006C\u00033\u0001\u0011\u00051'A\u0006tKR$%o\u001c9MCN$HC\u0001\u001b6\u001b\u0005\u0001\u0001\"\u0002\u001c2\u0001\u00049\u0014!\u0002<bYV,\u0007C\u0001\u00119\u0013\tI\u0014EA\u0004C_>dW-\u00198\t\u000bm\u0002A\u0011\u0001\u001f\u0002\u0017M,G/\u00138qkR\u001cu\u000e\u001c\u000b\u0003iuBQA\u000e\u001eA\u0002yAQa\u0010\u0001\u0005\u0002\u0001\u000bAb]3u\u001fV$\b/\u001e;D_2$\"\u0001N!\t\u000bYr\u0004\u0019\u0001\u0010\t\u000b\r\u0003A\u0011\t#\u0002\u0007\u0019LG\u000f\u0006\u0002\u0015\u000b\")aI\u0011a\u0001\u000f\u00069A-\u0019;bg\u0016$\bG\u0001%Q!\rIEJT\u0007\u0002\u0015*\u00111\nC\u0001\u0004gFd\u0017BA'K\u0005\u001d!\u0015\r^1tKR\u0004\"a\u0014)\r\u0001\u0011I\u0011+RA\u0001\u0002\u0003\u0015\tA\u0015\u0002\u0004?\u0012\u0012\u0014CA*W!\t\u0001C+\u0003\u0002VC\t9aj\u001c;iS:<\u0007C\u0001\u0011X\u0013\tA\u0016EA\u0002B]fDQA\u0017\u0001\u0005Bm\u000bAaY8qsR\u0011\u0001\u0003\u0018\u0005\u0006;f\u0003\rAX\u0001\u0006Kb$(/\u0019\t\u0003?\nl\u0011\u0001\u0019\u0006\u0003C\u001a\tQ\u0001]1sC6L!a\u00191\u0003\u0011A\u000b'/Y7NCBDQ!\u001a\u0001\u0005B\u0019\fq\u0002\u001e:b]N4wN]7TG\",W.\u0019\u000b\u0003O6\u0004\"\u0001[6\u000e\u0003%T!A\u001b&\u0002\u000bQL\b/Z:\n\u00051L'AC*ueV\u001cG\u000fV=qK\")a\u000e\u001aa\u0001O\u000611o\u00195f[\u0006D#\u0001\u001a9\u0011\u0005E$X\"\u0001:\u000b\u0005MD\u0011AC1o]>$\u0018\r^5p]&\u0011QO\u001d\u0002\r\t\u00164X\r\\8qKJ\f\u0005/\u001b\u0015\u0007\u0001]\f)!a\u0002\u0011\u0007a\f\t!D\u0001z\u0015\t\u0019(P\u0003\u0002|y\u0006!1m\u001c:f\u0015\t)QP\u0003\u0002\u007f\u007f\u000691m\\7ckN$(\"A\u0004\n\u0007\u0005\r\u0011PA\u0005Ta\u0006\u00148nQ8eK\u0006\u0019QO]5\"\u0005\u0005%\u0011\u0001\u001d5uiB\u001c(hL\u0018hSRDWO\u0019\u0018d_6|\u0013\r]1dQ\u0016|3\u000f]1sW>\u0012Gn\u001c20mJr\u0003G\f\u00190[2d\u0017NY\u0018te\u000e|S.Y5o_M\u001c\u0017\r\\10_J<w&\u00199bG\",wf\u001d9be.|S\u000e\\\u0018gK\u0006$XO]30\u001f:,\u0007j\u001c;F]\u000e|G-\u001a:/g\u000e\fG.\u0019")
public class OneHotEncoder
extends Estimator<OneHotEncoderModel>
implements OneHotEncoderBase {
    private final String uid;
    private final BooleanParam dropLast;
    private final Param<String> outputCol;
    private final Param<String> inputCol;

    @Override
    public final BooleanParam dropLast() {
        return this.dropLast;
    }

    @Override
    public final void org$apache$spark$ml$mleap$param$HasDropLast$_setter_$dropLast_$eq(BooleanParam x$1) {
        this.dropLast = x$1;
    }

    @Override
    public final boolean getDropLast() {
        return HasDropLast$class.getDropLast(this);
    }

    public final Param<String> outputCol() {
        return this.outputCol;
    }

    public final void org$apache$spark$ml$param$shared$HasOutputCol$_setter_$outputCol_$eq(Param x$1) {
        this.outputCol = x$1;
    }

    public final String getOutputCol() {
        return HasOutputCol.class.getOutputCol((HasOutputCol)this);
    }

    public final Param<String> inputCol() {
        return this.inputCol;
    }

    public final void org$apache$spark$ml$param$shared$HasInputCol$_setter_$inputCol_$eq(Param x$1) {
        this.inputCol = x$1;
    }

    public final String getInputCol() {
        return HasInputCol.class.getInputCol((HasInputCol)this);
    }

    public String uid() {
        return this.uid;
    }

    public OneHotEncoder setDropLast(boolean value) {
        return (OneHotEncoder)this.set((Param)this.dropLast(), BoxesRunTime.boxToBoolean((boolean)value));
    }

    public OneHotEncoder setInputCol(String value) {
        return (OneHotEncoder)this.set(this.inputCol(), value);
    }

    public OneHotEncoder setOutputCol(String value) {
        return (OneHotEncoder)this.set(this.outputCol(), value);
    }

    public OneHotEncoderModel fit(Dataset<?> dataset) {
        String inputColName = (String)this.$(this.inputCol());
        String outputColName = (String)this.$(this.outputCol());
        boolean shouldDropLast = BoxesRunTime.unboxToBoolean((Object)this.$((Param)this.dropLast()));
        AttributeGroup outputAttrGroup = AttributeGroup$.MODULE$.fromStructField(this.transformSchema(dataset.schema()).apply(outputColName));
        if (outputAttrGroup.size() < 0) {
            int numAttrs = (int)BoxesRunTime.unboxToDouble((Object)dataset.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{dataset.col(inputColName).cast((DataType)DoubleType$.MODULE$)})).rdd().map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final double apply(Row x$5) {
                    return x$5.getDouble(0);
                }
            }, ClassTag$.MODULE$.Double()).aggregate((Object)BoxesRunTime.boxToDouble((double)0.0), (Function2)new Serializable(this, inputColName){
                public static final long serialVersionUID = 0L;
                public final String inputColName$2;

                public final double apply(double m, double x) {
                    return this.apply$mcDDD$sp(m, x);
                }

                public double apply$mcDDD$sp(double m, double x) {
                    Predef$.MODULE$.assert(x <= (double)Integer.MAX_VALUE, (Function0)new Serializable(this, x){
                        public static final long serialVersionUID = 0L;
                        private final double x$10;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"OneHotEncoder only supports up to ", " indices, but got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)Integer.MAX_VALUE), BoxesRunTime.boxToDouble((double)this.x$10)}));
                        }
                        {
                            this.x$10 = x$10;
                        }
                    });
                    Predef$.MODULE$.assert(x >= 0.0 && x == (double)((int)x), (Function0)new Serializable(this, x){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$1 $outer;
                        private final double x$10;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Values from column ", " must be indices, but got ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.inputColName$2, BoxesRunTime.boxToDouble((double)this.x$10)}));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.x$10 = x$10;
                        }
                    });
                    return package$.MODULE$.max(m, x);
                }
                {
                    this.inputColName$2 = inputColName$2;
                }
            }, (Function2)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final double apply(double m0, double m1) {
                    return this.apply$mcDDD$sp(m0, m1);
                }

                public double apply$mcDDD$sp(double m0, double m1) {
                    return package$.MODULE$.max(m0, m1);
                }
            }, ClassTag$.MODULE$.Double())) + 1;
            String[] outputAttrNames = (String[])Array$.MODULE$.tabulate(numAttrs, (Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(int x$6) {
                    return ((Object)BoxesRunTime.boxToInteger((int)x$6)).toString();
                }
            }, ClassTag$.MODULE$.apply(String.class));
            String[] filtered = shouldDropLast ? (String[])Predef$.MODULE$.refArrayOps((Object[])outputAttrNames).dropRight(1) : outputAttrNames;
            Attribute[] outputAttrs = (Attribute[])Predef$.MODULE$.refArrayOps((Object[])filtered).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final BinaryAttribute apply(String name) {
                    return BinaryAttribute$.MODULE$.defaultAttr().withName(name);
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Attribute.class)));
            outputAttrGroup = new AttributeGroup(outputColName, outputAttrs);
        }
        int size = outputAttrGroup.size();
        return (OneHotEncoderModel)this.copyValues((Params)new OneHotEncoderModel(this.uid(), size).setParent(this), this.copyValues$default$2());
    }

    public Estimator<OneHotEncoderModel> copy(ParamMap extra) {
        return (Estimator)this.defaultCopy(extra);
    }

    @DeveloperApi
    public StructType transformSchema(StructType schema) {
        AttributeGroup attributeGroup;
        None$ none$;
        Attribute inputAttr;
        String inputColName = (String)this.$(this.inputCol());
        String outputColName = (String)this.$(this.outputCol());
        Predef$.MODULE$.require(schema.apply(inputColName).dataType() instanceof NumericType, (Function0)new Serializable(this, schema, inputColName){
            public static final long serialVersionUID = 0L;
            private final StructType schema$2;
            private final String inputColName$3;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Input column must be of type NumericType but got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.schema$2.apply(this.inputColName$3).dataType()}));
            }
            {
                this.schema$2 = schema$2;
                this.inputColName$3 = inputColName$3;
            }
        });
        StructField[] inputFields = schema.fields();
        Predef$.MODULE$.require(!Predef$.MODULE$.refArrayOps((Object[])inputFields).exists((Function1)new Serializable(this, outputColName){
            public static final long serialVersionUID = 0L;
            private final String outputColName$2;

            public final boolean apply(StructField x$7) {
                String string = x$7.name();
                String string2 = this.outputColName$2;
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
            {
                this.outputColName$2 = outputColName$2;
            }
        }), (Function0)new Serializable(this, outputColName){
            public static final long serialVersionUID = 0L;
            private final String outputColName$2;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Output column ", " already exists."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.outputColName$2}));
            }
            {
                this.outputColName$2 = outputColName$2;
            }
        });
        Attribute attribute = inputAttr = Attribute$.MODULE$.fromStructField(schema.apply(inputColName));
        if (attribute instanceof NominalAttribute) {
            NominalAttribute nominalAttribute = (NominalAttribute)attribute;
            none$ = nominalAttribute.values().isDefined() ? nominalAttribute.values() : (nominalAttribute.numValues().isDefined() ? nominalAttribute.numValues().map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String[] apply(int n) {
                    return (String[])Array$.MODULE$.tabulate(n, (Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply(int x$8) {
                            return ((Object)BoxesRunTime.boxToInteger((int)x$8)).toString();
                        }
                    }, ClassTag$.MODULE$.apply(String.class));
                }
            }) : None$.MODULE$);
        } else if (attribute instanceof BinaryAttribute) {
            BinaryAttribute binaryAttribute = (BinaryAttribute)attribute;
            none$ = binaryAttribute.values().isDefined() ? binaryAttribute.values() : new Some(Array$.MODULE$.tabulate(2, (Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(int x$9) {
                    return ((Object)BoxesRunTime.boxToInteger((int)x$9)).toString();
                }
            }, ClassTag$.MODULE$.apply(String.class)));
        } else {
            if (attribute instanceof NumericAttribute) {
                throw new RuntimeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The input column ", " cannot be numeric."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{inputColName})));
            }
            none$ = None$.MODULE$;
        }
        None$ outputAttrNames = none$;
        Option filteredOutputAttrNames = outputAttrNames.map((Function1)new Serializable(this, inputColName){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OneHotEncoder $outer;
            public final String inputColName$3;

            public final String[] apply(String[] names) {
                String[] stringArray;
                if (BoxesRunTime.unboxToBoolean((Object)this.$outer.$((Param)this.$outer.dropLast()))) {
                    Predef$.MODULE$.require(names.length > 1, (Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$15 $outer;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The input column ", " should have at least two distinct values."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.inputColName$3}));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                    stringArray = (String[])Predef$.MODULE$.refArrayOps((Object[])names).dropRight(1);
                } else {
                    stringArray = names;
                }
                return stringArray;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.inputColName$3 = inputColName$3;
            }
        });
        if (filteredOutputAttrNames.isDefined()) {
            Attribute[] attrs = (Attribute[])Predef$.MODULE$.refArrayOps((Object[])filteredOutputAttrNames.get()).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final BinaryAttribute apply(String name) {
                    return BinaryAttribute$.MODULE$.defaultAttr().withName(name);
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Attribute.class)));
            attributeGroup = new AttributeGroup((String)this.$(this.outputCol()), attrs);
        } else {
            attributeGroup = new AttributeGroup((String)this.$(this.outputCol()));
        }
        AttributeGroup outputAttrGroup = attributeGroup;
        StructField[] outputFields = (StructField[])Predef$.MODULE$.refArrayOps((Object[])inputFields).$colon$plus((Object)outputAttrGroup.toStructField(), ClassTag$.MODULE$.apply(StructField.class));
        return new StructType(outputFields);
    }

    public OneHotEncoder(String uid) {
        this.uid = uid;
        HasInputCol.class.$init$((HasInputCol)this);
        HasOutputCol.class.$init$((HasOutputCol)this);
        HasDropLast$class.$init$(this);
        this.setDefault((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.dropLast().$minus$greater((Object)BoxesRunTime.boxToBoolean((boolean)true))}));
    }

    public OneHotEncoder() {
        this(Identifiable$.MODULE$.randomUID("oneHot"));
    }
}

