/*
 * Decompiled with CFR 0.152.
 */
package ml.combust.mleap.springboot;

import akka.actor.ActorSystem;
import com.google.protobuf.ByteString;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.concurrent.CompletionStage;
import ml.combust.mleap.executor.BundleMeta;
import ml.combust.mleap.executor.GetBundleMetaRequest;
import ml.combust.mleap.executor.GetModelRequest;
import ml.combust.mleap.executor.MleapExecutor;
import ml.combust.mleap.executor.Model;
import ml.combust.mleap.executor.TransformFrameRequest;
import ml.combust.mleap.executor.UnloadModelRequest;
import ml.combust.mleap.pb.LoadModelRequest;
import ml.combust.mleap.pb.LoadModelRequest$;
import ml.combust.mleap.pb.TransformFrameRequest$;
import ml.combust.mleap.pb.TransformFrameResponse;
import ml.combust.mleap.pb.TransformFrameResponse$;
import ml.combust.mleap.pb.TransformStatus;
import ml.combust.mleap.pb.TransformStatus$STATUS_ERROR$;
import ml.combust.mleap.runtime.frame.DefaultLeapFrame;
import ml.combust.mleap.runtime.frame.LeapFrame;
import ml.combust.mleap.runtime.serialization.FrameReader;
import ml.combust.mleap.runtime.serialization.FrameReader$;
import ml.combust.mleap.runtime.serialization.FrameWriter;
import ml.combust.mleap.runtime.serialization.FrameWriter$;
import ml.combust.mleap.springboot.JsonScoringController$;
import ml.combust.mleap.springboot.TypeConverters$;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.json4s.jackson.JsonMethods$;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.compat.java8.FutureConverters;
import scala.compat.java8.FutureConverters$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.Future$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scalapb.GeneratedMessage;
import scalapb.json4s.Parser;
import scalapb.json4s.Printer;

@RestController
@RequestMapping
@ScalaSignature(bytes="\u0006\u0001\t\u0005c\u0001B\f\u0019\u0001\u0005B\u0001\u0002\u000b\u0001\u0003\u0006\u0004%\t!\u000b\u0005\te\u0001\u0011\t\u0011)A\u0005U!A1\u0007\u0001BC\u0002\u0013\u0005A\u0007\u0003\u0005<\u0001\t\u0005\t\u0015!\u00036\u0011!a\u0004A!b\u0001\n\u0003i\u0004\u0002\u0003$\u0001\u0005\u0003\u0005\u000b\u0011\u0002 \t\u0011\u001d\u0003!Q1A\u0005\u0002!C\u0001\u0002\u0014\u0001\u0003\u0002\u0003\u0006I!\u0013\u0005\u0006\u001b\u0002!\tA\u0014\u0005\bq\u0001\u0011\r\u0011\"\u0003h\u0011\u0019q\u0007\u0001)A\u0005Q\")q\u000e\u0001C\u0001a\"9\u0011\u0011\u000f\u0001\u0005\u0002\u0005M\u0004bBAN\u0001\u0011\u0005\u0011Q\u0014\u0005\b\u0003k\u0003A\u0011AA\\\u0011\u001d\ti\r\u0001C\u0001\u0003\u001fDq!a:\u0001\t\u0013\tIoB\u0004\u0003(aA\tA!\u000b\u0007\r]A\u0002\u0012\u0001B\u0016\u0011\u0019i5\u0003\"\u0001\u0003.!I!qF\nC\u0002\u0013\u0005!\u0011\u0007\u0005\t\u0005\u007f\u0019\u0002\u0015!\u0003\u00034\t)\"j]8o'\u000e|'/\u001b8h\u0007>tGO]8mY\u0016\u0014(BA\r\u001b\u0003)\u0019\bO]5oO\n|w\u000e\u001e\u0006\u00037q\tQ!\u001c7fCBT!!\b\u0010\u0002\u000f\r|WNY;ti*\tq$\u0001\u0002nY\u000e\u00011C\u0001\u0001#!\t\u0019c%D\u0001%\u0015\u0005)\u0013!B:dC2\f\u0017BA\u0014%\u0005\u0019\te.\u001f*fM\u0006Y\u0011m\u0019;peNK8\u000f^3n+\u0005Q\u0003CA\u00161\u001b\u0005a#BA\u0017/\u0003\u0015\t7\r^8s\u0015\u0005y\u0013\u0001B1lW\u0006L!!\r\u0017\u0003\u0017\u0005\u001bGo\u001c:TsN$X-\\\u0001\rC\u000e$xN]*zgR,W\u000eI\u0001\u000e[2,\u0017\r]#yK\u000e,Ho\u001c:\u0016\u0003U\u0002\"AN\u001d\u000e\u0003]R!\u0001\u000f\u000e\u0002\u0011\u0015DXmY;u_JL!AO\u001c\u0003\u001b5cW-\u00199Fq\u0016\u001cW\u000f^8s\u00039iG.Z1q\u000bb,7-\u001e;pe\u0002\n1B[:p]B\u0013\u0018N\u001c;feV\ta\b\u0005\u0002@\t6\t\u0001I\u0003\u0002B\u0005\u00061!n]8oiMT\u0011aQ\u0001\bg\u000e\fG.\u00199c\u0013\t)\u0005IA\u0004Qe&tG/\u001a:\u0002\u0019)\u001cxN\u001c)sS:$XM\u001d\u0011\u0002\u0015)\u001cxN\u001c)beN,'/F\u0001J!\ty$*\u0003\u0002L\u0001\n1\u0001+\u0019:tKJ\f1B[:p]B\u000b'o]3sA\u00051A(\u001b8jiz\"RaT)bG\u0016\u0004\"\u0001\u0015\u0001\u000e\u0003aAQ\u0001K\u0005A\u0002)B#!U*\u0011\u0005Q{V\"A+\u000b\u0005Y;\u0016AC1o]>$\u0018\r^5p]*\u0011\u0001,W\u0001\bM\u0006\u001cGo\u001c:z\u0015\tQ6,A\u0003cK\u0006t7O\u0003\u0002];\u0006y1\u000f\u001d:j]\u001e4'/Y7fo>\u00148NC\u0001_\u0003\ry'oZ\u0005\u0003AV\u0013\u0011\"Q;u_^L'/\u001a3\t\u000bMJ\u0001\u0019A\u001b)\u0005\u0005\u001c\u0006\"\u0002\u001f\n\u0001\u0004q\u0004FA2T\u0011\u00159\u0015\u00021\u0001JQ\t)7+F\u0001i!\tIG.D\u0001k\u0015\tYG%\u0001\u0006d_:\u001cWO\u001d:f]RL!!\u001c6\u00031\u0015CXmY;uS>t7i\u001c8uKb$X\t_3dkR|'/A\u0005fq\u0016\u001cW\u000f^8sA\u0005IAn\\1e\u001b>$W\r\u001c\u000b\u0006c\u0006-\u00111\u0005\t\u0004ebTX\"A:\u000b\u0005-$(BA;w\u0003\u0011)H/\u001b7\u000b\u0003]\fAA[1wC&\u0011\u0011p\u001d\u0002\u0010\u0007>l\u0007\u000f\\3uS>t7\u000b^1hKB\u001910!\u0002\u000f\u0007q\f\t\u0001\u0005\u0002~I5\taP\u0003\u0002\u0000A\u00051AH]8pizJ1!a\u0001%\u0003\u0019\u0001&/\u001a3fM&!\u0011qAA\u0005\u0005\u0019\u0019FO]5oO*\u0019\u00111\u0001\u0013\t\r\u00055A\u00021\u0001{\u0003\u001d\u0011X-];fgRDC!a\u0003\u0002\u0012A!\u00111CA\u0010\u001b\t\t)BC\u0002W\u0003/QA!!\u0007\u0002\u001c\u0005!!-\u001b8e\u0015\r\tibW\u0001\u0004o\u0016\u0014\u0017\u0002BA\u0011\u0003+\u00111BU3rk\u0016\u001cHOQ8es\"9\u0011Q\u0005\u0007A\u0002\u0005\u001d\u0012a\u0002;j[\u0016|W\u000f\u001e\t\u0004G\u0005%\u0012bAA\u0016I\t\u0019\u0011J\u001c;)\u0019\u0005\r\u0012qFA\u001b\u0003o\tI$a\u000f\u0011\t\u0005M\u0011\u0011G\u0005\u0005\u0003g\t)BA\u0007SKF,Xm\u001d;IK\u0006$WM]\u0001\u0006m\u0006dW/Z\u0011\u0003\u0003K\tA\u0002Z3gCVdGOV1mk\u0016\f#!!\u0010\u0002\u000bY\u0002\u0004\u0007\r\u0019)\u000f1\t\t%!\u000e\u0002HA!\u00111CA\"\u0013\u0011\t)%!\u0006\u0003\u001dI+7\u000f]8og\u0016\u001cF/\u0019;vg\u0012\u0012\u0011\u0011J\u0005\u0005\u0003\u0017\ni%\u0001\u0005B\u0007\u000e+\u0005\u000bV#E\u0015\u0011\ty%!\u0015\u0002\u0015!#H\u000f]*uCR,8OC\u0002\u0002Tm\u000bA\u0001\u001b;ua\"zA\"a\u0016\u0002^\u0005}\u0013QMA4\u0003[\ny\u0007\u0005\u0003\u0002\u0014\u0005e\u0013\u0002BA.\u0003+\u00111\u0002U8ti6\u000b\u0007\u000f]5oO\u0006!\u0001/\u0019;iY\t\t\t'\t\u0002\u0002d\u00059q&\\8eK2\u001c\u0018\u0001C2p]N,X.Z:-\u0005\u0005%\u0014EAA6\u0003}\t\u0007\u000f\u001d7jG\u0006$\u0018n\u001c80UN|gn\u000f\u0011dQ\u0006\u00148/\u001a;>+R3U\u0006O\u0001\taJ|G-^2fg2\u0012\u0011\u0011N\u0001\fk:dw.\u00193N_\u0012,G\u000eF\u0003r\u0003k\n)\t\u0003\u0004\u0002x5\u0001\rA_\u0001\n[>$W\r\u001c(b[\u0016D\u0003\"!\u001e\u0002|\u0005U\u0012\u0011\u0011\t\u0005\u0003'\ti(\u0003\u0003\u0002\u0000\u0005U!\u0001\u0004)bi\"4\u0016M]5bE2,\u0017EAAB\u0003)iw\u000eZ3m?:\fW.\u001a\u0005\b\u0003Ki\u0001\u0019AA\u0014Q1\t))a\f\u00026\u0005]\u0012\u0011HA\u001eQ=i\u00111RA/\u0003#\u000b)'a&\u0002n\u0005e\u0005\u0003BA\n\u0003\u001bKA!a$\u0002\u0016\tiA)\u001a7fi\u0016l\u0015\r\u001d9j]\u001ed#!a%\"\u0005\u0005U\u0015\u0001F\u0018n_\u0012,Gn]\u0018|[>$W\r\\0oC6,W\u0010\f\u0002\u0002j1\u0012\u0011\u0011N\u0001\tO\u0016$Xj\u001c3fYR)\u0011/a(\u0002$\"1\u0011q\u000f\bA\u0002iD\u0003\"a(\u0002|\u0005U\u0012\u0011\u0011\u0005\b\u0003Kq\u0001\u0019AA\u0014Q1\t\u0019+a\f\u00026\u0005]\u0012\u0011HA\u001eQ=q\u0011\u0011VA/\u0003_\u000b)'!-\u0002n\u0005M\u0006\u0003BA\n\u0003WKA!!,\u0002\u0016\tQq)\u001a;NCB\u0004\u0018N\\4-\u0005\u0005MEFAA5Y\t\tI'A\u0004hKRlU\r^1\u0015\u000bE\fI,!0\t\r\u0005]t\u00021\u0001{Q!\tI,a\u001f\u00026\u0005\u0005\u0005bBA\u0013\u001f\u0001\u0007\u0011q\u0005\u0015\r\u0003{\u000by#!\u000e\u00028\u0005e\u00121\b\u0015\u0010\u001f\u0005%\u0016QLAb\u0003K\nI-!\u001c\u0002L2\u0012\u0011QY\u0011\u0003\u0003\u000f\f\u0011dL7pI\u0016d7oL>n_\u0012,Gn\u00188b[\u0016lx&\\3uC2\u0012\u0011\u0011\u000e\u0017\u0003\u0003S\n\u0011\u0002\u001e:b]N4wN]7\u0015\u000bE\f\t.a6\t\r\u0005M\u0007\u00031\u0001{\u0003\u0011\u0011w\u000eZ=)\t\u0005E\u0017\u0011\u0003\u0005\b\u0003K\u0001\u0002\u0019AA\u0014Q1\t9.a\f\u00026\u0005]\u0012\u0011HA\u001eQ=\u0001\u0012qKA/\u0003;\f)'a9\u0002n\u0005\u0015HFAApC\t\t\t/A\t0[>$W\r\\:0iJ\fgn\u001d4pe6d#!!\u001b-\u0005\u0005%\u0014A\u00065b]\u0012dW\r\u0016:b]N4wN]7GC&dWO]3\u0015\r\u0005-\u0018q\u001fB\u0001!\u0011\ti/a=\u000e\u0005\u0005=(bAAy5\u0005\u0011\u0001OY\u0005\u0005\u0003k\fyO\u0001\fUe\u0006t7OZ8s[\u001a\u0013\u0018-\\3SKN\u0004xN\\:f\u0011\u001d\tI0\u0005a\u0001\u0003w\f1\u0001^1h!\r\u0019\u0013Q`\u0005\u0004\u0003\u007f$#\u0001\u0002'p]\u001eDqAa\u0001\u0012\u0001\u0004\u0011)!\u0001\u0002fqB!!q\u0001B\t\u001d\u0011\u0011IA!\u0004\u000f\u0007u\u0014Y!C\u0001&\u0013\r\u0011y\u0001J\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\u0011\u0019B!\u0006\u0003\u0013QC'o\\<bE2,'b\u0001B\bI!\u001a\u0001A!\u0007\u0011\t\u0005M!1D\u0005\u0005\u0005;\t)B\u0001\bSKF,Xm\u001d;NCB\u0004\u0018N\\4)\u0007\u0001\u0011\t\u0003\u0005\u0003\u0002\u0014\t\r\u0012\u0002\u0002B\u0013\u0003+\u0011aBU3ti\u000e{g\u000e\u001e:pY2,'/A\u000bKg>t7kY8sS:<7i\u001c8ue>dG.\u001a:\u0011\u0005A\u001b2CA\n#)\t\u0011I#\u0001\u0004m_\u001e<WM]\u000b\u0003\u0005g\u0001BA!\u000e\u0003<5\u0011!q\u0007\u0006\u0004\u0005si\u0016!B:mMRR\u0017\u0002\u0002B\u001f\u0005o\u0011a\u0001T8hO\u0016\u0014\u0018a\u00027pO\u001e,'\u000f\t")
public class JsonScoringController {
    private final ActorSystem actorSystem;
    private final MleapExecutor mleapExecutor;
    private final Printer jsonPrinter;
    private final Parser jsonParser;
    private final ExecutionContextExecutor executor;

    public static Logger logger() {
        return JsonScoringController$.MODULE$.logger();
    }

    public ActorSystem actorSystem() {
        return this.actorSystem;
    }

    public MleapExecutor mleapExecutor() {
        return this.mleapExecutor;
    }

    public Printer jsonPrinter() {
        return this.jsonPrinter;
    }

    public Parser jsonParser() {
        return this.jsonParser;
    }

    private ExecutionContextExecutor executor() {
        return this.executor;
    }

    @PostMapping(path={"/models"}, consumes={"application/json; charset=UTF-8"}, produces={"application/json; charset=UTF-8"})
    @ResponseStatus(value=HttpStatus.ACCEPTED)
    public CompletionStage<String> loadModel(@RequestBody String request, @RequestHeader(value="timeout", defaultValue="60000") int timeout) {
        return FutureConverters.FutureOps$.MODULE$.toJava$extension(FutureConverters$.MODULE$.FutureOps(this.mleapExecutor().loadModel(TypeConverters$.MODULE$.pbToExecutorLoadModelRequest((LoadModelRequest)this.jsonParser().fromJsonString(request, LoadModelRequest$.MODULE$.messageCompanion())), TypeConverters$.MODULE$.getTimeout(timeout)).map((Function1 & Serializable & scala.Serializable)model -> TypeConverters$.MODULE$.executorToPbModel((Model)model), (ExecutionContext)this.executor()).map((Function1 & Serializable & scala.Serializable)model -> JsonMethods$.MODULE$.compact(this.jsonPrinter().toJson((GeneratedMessage)model)), (ExecutionContext)this.executor())));
    }

    @DeleteMapping(path={"/models/{model_name}"}, consumes={"application/json; charset=UTF-8"}, produces={"application/json; charset=UTF-8"})
    public CompletionStage<String> unloadModel(@PathVariable(value="model_name") String modelName, @RequestHeader(value="timeout", defaultValue="60000") int timeout) {
        return FutureConverters.FutureOps$.MODULE$.toJava$extension(FutureConverters$.MODULE$.FutureOps(this.mleapExecutor().unloadModel(new UnloadModelRequest(modelName), TypeConverters$.MODULE$.getTimeout(timeout)).map((Function1 & Serializable & scala.Serializable)model -> TypeConverters$.MODULE$.executorToPbModel((Model)model), (ExecutionContext)this.executor()).map((Function1 & Serializable & scala.Serializable)model -> JsonMethods$.MODULE$.compact(this.jsonPrinter().toJson((GeneratedMessage)model)), (ExecutionContext)this.executor())));
    }

    @GetMapping(path={"/models/{model_name}"}, consumes={"application/json; charset=UTF-8"}, produces={"application/json; charset=UTF-8"})
    public CompletionStage<String> getModel(@PathVariable(value="model_name") String modelName, @RequestHeader(value="timeout", defaultValue="60000") int timeout) {
        return FutureConverters.FutureOps$.MODULE$.toJava$extension(FutureConverters$.MODULE$.FutureOps(this.mleapExecutor().getModel(new GetModelRequest(modelName), TypeConverters$.MODULE$.getTimeout(timeout)).map((Function1 & Serializable & scala.Serializable)model -> TypeConverters$.MODULE$.executorToPbModel((Model)model), (ExecutionContext)this.executor()).map((Function1 & Serializable & scala.Serializable)model -> JsonMethods$.MODULE$.compact(this.jsonPrinter().toJson((GeneratedMessage)model)), (ExecutionContext)this.executor())));
    }

    @GetMapping(path={"/models/{model_name}/meta"}, consumes={"application/json; charset=UTF-8"}, produces={"application/json; charset=UTF-8"})
    public CompletionStage<String> getMeta(@PathVariable(value="model_name") String modelName, @RequestHeader(value="timeout", defaultValue="60000") int timeout) {
        return FutureConverters.FutureOps$.MODULE$.toJava$extension(FutureConverters$.MODULE$.FutureOps(this.mleapExecutor().getBundleMeta(new GetBundleMetaRequest(modelName), TypeConverters$.MODULE$.getTimeout(timeout)).map((Function1 & Serializable & scala.Serializable)meta -> TypeConverters$.MODULE$.executorToPbBundleMeta((BundleMeta)meta), (ExecutionContext)this.executor()).map((Function1 & Serializable & scala.Serializable)meta -> JsonMethods$.MODULE$.compact(this.jsonPrinter().toJson((GeneratedMessage)meta)), (ExecutionContext)this.executor())));
    }

    @PostMapping(path={"/models/transform"}, consumes={"application/json; charset=UTF-8"}, produces={"application/json; charset=UTF-8"})
    public CompletionStage<String> transform(@RequestBody String body2, @RequestHeader(value="timeout", defaultValue="60000") int timeout) {
        CompletionStage completionStage;
        Charset x$2;
        byte[] x$1;
        ml.combust.mleap.pb.TransformFrameRequest request = (ml.combust.mleap.pb.TransformFrameRequest)this.jsonParser().fromJsonString(body2, TransformFrameRequest$.MODULE$.messageCompanion());
        FrameReader qual$1 = FrameReader$.MODULE$.apply(request.format(), FrameReader$.MODULE$.apply$default$2());
        Try try_ = qual$1.fromBytes(x$1 = request.frame().toByteArray(), x$2 = qual$1.fromBytes$default$2());
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            DefaultLeapFrame frame = (DefaultLeapFrame)success.value();
            completionStage = FutureConverters.FutureOps$.MODULE$.toJava$extension(FutureConverters$.MODULE$.FutureOps(TypeConverters$.MODULE$.RichFuture(this.mleapExecutor().transform(new TransformFrameRequest(request.modelName(), frame, TypeConverters$.MODULE$.pbToExecutorTransformOptions(request.getOptions())), TypeConverters$.MODULE$.getTimeout(timeout))).mapAll(new scala.Serializable(this, request){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ JsonScoringController $outer;
                private final ml.combust.mleap.pb.TransformFrameRequest request$1;

                public final <A1 extends Try<Try<DefaultLeapFrame>>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x1;
                    if (A1 instanceof Success) {
                        TransformFrameResponse transformFrameResponse;
                        Success success = (Success)A1;
                        Try resp = (Try)success.value();
                        Try try_ = resp;
                        if (try_ instanceof Success) {
                            Success success2 = (Success)try_;
                            DefaultLeapFrame frame = (DefaultLeapFrame)success2.value();
                            long x$2 = this.request$1.tag();
                            FrameWriter qual$1 = FrameWriter$.MODULE$.apply((LeapFrame)frame, this.request$1.format(), FrameWriter$.MODULE$.apply$default$3(), ClassTag$.MODULE$.apply(DefaultLeapFrame.class));
                            Charset x$1 = qual$1.toBytes$default$1();
                            ByteString x$3 = ByteString.copyFrom((byte[])((byte[])qual$1.toBytes(x$1).get()));
                            String x$4 = TransformFrameResponse$.MODULE$.apply$default$2();
                            TransformStatus x$5 = TransformFrameResponse$.MODULE$.apply$default$4();
                            String x$6 = TransformFrameResponse$.MODULE$.apply$default$5();
                            String x$7 = TransformFrameResponse$.MODULE$.apply$default$6();
                            transformFrameResponse = new TransformFrameResponse(x$2, x$4, x$3, x$5, x$6, x$7);
                        } else if (try_ instanceof Failure) {
                            Failure failure = (Failure)try_;
                            Throwable ex = failure.exception();
                            transformFrameResponse = this.$outer.ml$combust$mleap$springboot$JsonScoringController$$handleTransformFailure(this.request$1.tag(), ex);
                        } else {
                            throw new MatchError((Object)try_);
                        }
                        object = transformFrameResponse;
                    } else if (A1 instanceof Failure) {
                        Failure failure = (Failure)A1;
                        Throwable ex = failure.exception();
                        object = this.$outer.ml$combust$mleap$springboot$JsonScoringController$$handleTransformFailure(this.request$1.tag(), ex);
                    } else {
                        object = function1.apply(x1);
                    }
                    return (B1)object;
                }

                public final boolean isDefinedAt(Try<Try<DefaultLeapFrame>> x1) {
                    Try<Try<DefaultLeapFrame>> try_ = x1;
                    boolean bl = try_ instanceof Success ? true : try_ instanceof Failure;
                    return bl;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.request$1 = request$1;
                }
            }, (ExecutionContext)this.executor()).map((Function1 & Serializable & scala.Serializable)resp -> JsonMethods$.MODULE$.compact(this.jsonPrinter().toJson((GeneratedMessage)resp)), (ExecutionContext)this.executor())));
        } else if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable ex = failure.exception();
            completionStage = FutureConverters.FutureOps$.MODULE$.toJava$extension(FutureConverters$.MODULE$.FutureOps(Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> JsonMethods$.MODULE$.compact(this.jsonPrinter().toJson((GeneratedMessage)this.ml$combust$mleap$springboot$JsonScoringController$$handleTransformFailure(request.tag(), ex))), (ExecutionContext)this.executor())));
        } else {
            throw new MatchError((Object)try_);
        }
        return completionStage;
    }

    public TransformFrameResponse ml$combust$mleap$springboot$JsonScoringController$$handleTransformFailure(long tag, Throwable ex) {
        JsonScoringController$.MODULE$.logger().error("Transform error due to ", ex);
        long x$1 = tag;
        TransformStatus$STATUS_ERROR$ x$2 = TransformStatus$STATUS_ERROR$.MODULE$;
        String x$3 = ExceptionUtils.getMessage((Throwable)ex);
        String x$4 = ExceptionUtils.getStackTrace((Throwable)ex);
        String x$5 = TransformFrameResponse$.MODULE$.apply$default$2();
        ByteString x$6 = TransformFrameResponse$.MODULE$.apply$default$3();
        return new TransformFrameResponse(x$1, x$5, x$6, x$2, x$3, x$4);
    }

    public JsonScoringController(@Autowired ActorSystem actorSystem, @Autowired MleapExecutor mleapExecutor, @Autowired Printer jsonPrinter, @Autowired Parser jsonParser) {
        this.actorSystem = actorSystem;
        this.mleapExecutor = mleapExecutor;
        this.jsonPrinter = jsonPrinter;
        this.jsonParser = jsonParser;
        this.executor = actorSystem.dispatcher();
    }
}

