/*
 * Decompiled with CFR 0.152.
 */
package ml.combust.mleap.springboot;

import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.annotation.PostConstruct;
import ml.combust.mleap.executor.MleapExecutor;
import ml.combust.mleap.pb.LoadModelRequest;
import ml.combust.mleap.pb.LoadModelRequest$;
import ml.combust.mleap.springboot.TypeConverters$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import scala.Function1;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scalapb.json4s.Parser;

@Component
@ScalaSignature(bytes="\u0006\u0001\u0005\u0005a\u0001B\u0007\u000f\u0001]A\u0001B\b\u0001\u0003\u0006\u0004%\ta\b\u0005\tM\u0001\u0011\t\u0011)A\u0005A!Aq\u0005\u0001BC\u0002\u0013\u0005\u0001\u0006\u0003\u00052\u0001\t\u0005\t\u0015!\u0003*\u0011\u0015\u0011\u0004\u0001\"\u00014\u0011\u001dA\u0005A1A\u0005\n%Ca!\u0016\u0001!\u0002\u0013Q\u0005bB/\u0001\u0005\u0004%IA\u0018\u0005\u0007K\u0002\u0001\u000b\u0011B0\t\u000f\u0019\u0004!\u0019!C\u0005O\"11\u000e\u0001Q\u0001\n!DQ\u0001\u001c\u0001\u0005\u00025\u00141\"T8eK2du.\u00193fe*\u0011q\u0002E\u0001\u000bgB\u0014\u0018N\\4c_>$(BA\t\u0013\u0003\u0015iG.Z1q\u0015\t\u0019B#A\u0004d_6\u0014Wo\u001d;\u000b\u0003U\t!!\u001c7\u0004\u0001M\u0011\u0001\u0001\u0007\t\u00033qi\u0011A\u0007\u0006\u00027\u0005)1oY1mC&\u0011QD\u0007\u0002\u0007\u0003:L(+\u001a4\u0002\u001b5dW-\u00199Fq\u0016\u001cW\u000f^8s+\u0005\u0001\u0003CA\u0011%\u001b\u0005\u0011#BA\u0012\u0011\u0003!)\u00070Z2vi>\u0014\u0018BA\u0013#\u00055iE.Z1q\u000bb,7-\u001e;pe\u0006qQ\u000e\\3ba\u0016CXmY;u_J\u0004\u0013A\u00036t_:\u0004\u0016M]:feV\t\u0011\u0006\u0005\u0002+_5\t1F\u0003\u0002-[\u00051!n]8oiMT\u0011AL\u0001\bg\u000e\fG.\u00199c\u0013\t\u00014F\u0001\u0004QCJ\u001cXM]\u0001\fUN|g\u000eU1sg\u0016\u0014\b%\u0001\u0004=S:LGO\u0010\u000b\u0004iY2\u0005CA\u001b\u0001\u001b\u0005q\u0001\"\u0002\u0010\u0006\u0001\u0004\u0001\u0003F\u0001\u001c9!\tID)D\u0001;\u0015\tYD(\u0001\u0006b]:|G/\u0019;j_:T!!\u0010 \u0002\u000f\u0019\f7\r^8ss*\u0011q\bQ\u0001\u0006E\u0016\fgn\u001d\u0006\u0003\u0003\n\u000bqb\u001d9sS:<gM]1nK^|'o\u001b\u0006\u0002\u0007\u0006\u0019qN]4\n\u0005\u0015S$!C!vi><\u0018N]3e\u0011\u00159S\u00011\u0001*Q\t1\u0005(A\bn_\u0012,GnQ8oM&<\u0007+\u0019;i+\u0005Q\u0005CA&S\u001d\ta\u0005\u000b\u0005\u0002N55\taJ\u0003\u0002P-\u00051AH]8pizJ!!\u0015\u000e\u0002\rA\u0013X\rZ3g\u0013\t\u0019FK\u0001\u0004TiJLgn\u001a\u0006\u0003#j\t\u0001#\\8eK2\u001cuN\u001c4jOB\u000bG\u000f\u001b\u0011)\t\u001d9&l\u0017\t\u0003saK!!\u0017\u001e\u0003\u000bY\u000bG.^3\u0002\u000bY\fG.^3\"\u0003q\u000bQ\u0004J>nY\u0016\f\u0007OL7pI\u0016dgfY8oM&<'hI>ok2dW0`\u0001\u0007Y><w-\u001a:\u0016\u0003}\u0003\"\u0001Y2\u000e\u0003\u0005T!A\u0019\"\u0002\u000bMdg\r\u000e6\n\u0005\u0011\f'A\u0002'pO\u001e,'/A\u0004m_\u001e<WM\u001d\u0011\u0002\u000fQLW.Z8viV\t\u0001\u000e\u0005\u0002\u001aS&\u0011!N\u0007\u0002\u0004\u0013:$\u0018\u0001\u0003;j[\u0016|W\u000f\u001e\u0011\u0002\u00131|\u0017\rZ'pI\u0016dG#\u00018\u0011\u0005ey\u0017B\u00019\u001b\u0005\u0011)f.\u001b;)\u00051\u0011\bCA:x\u001b\u0005!(BA\u001ev\u0015\u00051\u0018!\u00026bm\u0006D\u0018B\u0001=u\u00055\u0001vn\u001d;D_:\u001cHO];di\"\u0012\u0001A\u001f\t\u0003wzl\u0011\u0001 \u0006\u0003{\u0002\u000b!b\u001d;fe\u0016|G/\u001f9f\u0013\tyHPA\u0005D_6\u0004xN\\3oi\u0002")
public class ModelLoader {
    private final MleapExecutor mleapExecutor;
    private final Parser jsonParser;
    @Value(value="${mleap.model.config:#{null}}")
    private final String modelConfigPath;
    private final Logger logger;
    private final int timeout;

    public MleapExecutor mleapExecutor() {
        return this.mleapExecutor;
    }

    public Parser jsonParser() {
        return this.jsonParser;
    }

    private String modelConfigPath() {
        return this.modelConfigPath;
    }

    private Logger logger() {
        return this.logger;
    }

    private int timeout() {
        return this.timeout;
    }

    @PostConstruct
    public void loadModel() {
        if (this.modelConfigPath() == null) {
            this.logger().info("Skipping loading model on startup");
            return;
        }
        Path configPath = Paths.get(this.modelConfigPath(), new String[0]);
        if (!Files.exists(configPath, new LinkOption[0])) {
            this.logger().warn(new StringBuilder(27).append("Model path does not exist: ").append(this.modelConfigPath()).toString());
            return;
        }
        .colon.colon configFiles = Files.isDirectory(configPath, new LinkOption[0]) ? ((TraversableOnce)CollectionConverters$.MODULE$.asScalaIteratorConverter(Files.list(configPath).iterator()).asScala()).toList() : new .colon.colon((Object)configPath, (List)Nil$.MODULE$);
        configFiles.foreach((Function1 & Serializable & scala.Serializable)configFile -> {
            this.logger().info(new StringBuilder(19).append("Loading model from ").append(((Object)configFile).toString()).toString());
            String request = new String(Files.readAllBytes(configFile));
            return this.mleapExecutor().loadModel(TypeConverters$.MODULE$.pbToExecutorLoadModelRequest((LoadModelRequest)this.jsonParser().fromJsonString(request, LoadModelRequest$.MODULE$.messageCompanion())), TypeConverters$.MODULE$.getTimeout(this.timeout()));
        });
    }

    public ModelLoader(@Autowired MleapExecutor mleapExecutor, @Autowired Parser jsonParser) {
        this.mleapExecutor = mleapExecutor;
        this.jsonParser = jsonParser;
        this.modelConfigPath = null;
        this.logger = LoggerFactory.getLogger(ModelLoader.class);
        this.timeout = 60000;
    }
}

