/*
 * Decompiled with CFR 0.152.
 */
package ml.combust.mleap.tensor;

import java.io.Serializable;
import ml.combust.mleap.tensor.ByteString;
import ml.combust.mleap.tensor.DenseTensor;
import ml.combust.mleap.tensor.SparseTensor;
import ml.combust.mleap.tensor.Tensor;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.math.Numeric;
import scala.reflect.ClassTag;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

public final class Tensor$ {
    public static Tensor$ MODULE$;
    private final Class<Object> BooleanClass;
    private final Class<Object> ByteClass;
    private final Class<Object> ShortClass;
    private final Class<Object> IntClass;
    private final Class<Object> LongClass;
    private final Class<Object> FloatClass;
    private final Class<Object> DoubleClass;
    private final Class<String> StringClass;
    private final Class<ByteString> ByteStringClass;

    static {
        new Tensor$();
    }

    public Class<Object> BooleanClass() {
        return this.BooleanClass;
    }

    public Class<Object> ByteClass() {
        return this.ByteClass;
    }

    public Class<Object> ShortClass() {
        return this.ShortClass;
    }

    public Class<Object> IntClass() {
        return this.IntClass;
    }

    public Class<Object> LongClass() {
        return this.LongClass;
    }

    public Class<Object> FloatClass() {
        return this.FloatClass;
    }

    public Class<Object> DoubleClass() {
        return this.DoubleClass;
    }

    public Class<String> StringClass() {
        return this.StringClass;
    }

    public Class<ByteString> ByteStringClass() {
        return this.ByteStringClass;
    }

    public <T> Tensor<T> create(Object values, Seq<Object> dimensions, Option<Seq<Seq<Object>>> indices, ClassTag<T> evidence$1) {
        Tensor<T> tensor;
        Option<Seq<Seq<Object>>> option = indices;
        if (option instanceof Some) {
            Some some = (Some)option;
            Seq is = (Seq)some.value();
            if (!this.isKnownDimensions(dimensions)) {
                throw new IllegalArgumentException("dimensions must be known for SparseTensor");
            }
            tensor = new SparseTensor<T>((Seq<Seq<Object>>)is, values, dimensions, evidence$1);
        } else if (None$.MODULE$.equals(option)) {
            tensor = new DenseTensor<T>(values, this.normalizeDimensions(ScalaRunTime$.MODULE$.array_length(values), dimensions), evidence$1);
        } else {
            throw new MatchError(option);
        }
        return tensor;
    }

    public <T> Option<Seq<Seq<Object>>> create$default$3() {
        return None$.MODULE$;
    }

    public <T> DenseTensor<T> denseVector(Object values, ClassTag<T> evidence$2) {
        return new DenseTensor<T>(values, (Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{ScalaRunTime$.MODULE$.array_length(values)}))), evidence$2);
    }

    public <T> DenseTensor<T> scalar(T value, ClassTag<T> evidence$3) {
        return new DenseTensor<T>(Array$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{value}), evidence$3), (Seq<Object>)((Seq)Nil$.MODULE$), evidence$3);
    }

    public int denseIndex(Seq<Object> indices, Seq<Object> dimensions) {
        IntRef n = IntRef.create((int)BoxesRunTime.unboxToInt((Object)indices.last()));
        ObjectRef r = ObjectRef.create(dimensions);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), indices.length() - 1).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            r$1.elem = (Seq)((Seq)r$1.elem).tail();
            n$1.elem += BoxesRunTime.unboxToInt((Object)indices.apply(i)) * BoxesRunTime.unboxToInt((Object)((Seq)r$1.elem).product((Numeric)Numeric.IntIsIntegral$.MODULE$));
        });
        return n.elem;
    }

    public boolean isKnownDimensions(Seq<Object> dimensions) {
        return dimensions.count((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)dim -> dim == -1) == 0;
    }

    public Seq<Object> normalizeDimensions(int size, Seq<Object> dimensions) {
        Seq normalizedDimensions;
        Seq seq;
        int numOfUnknownDimensions = dimensions.count((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)dim -> dim == -1);
        if (numOfUnknownDimensions > 1) {
            throw new IllegalArgumentException("dimensions contains more then one `-1`");
        }
        if (numOfUnknownDimensions == 1) {
            int concreteDimension = size / BoxesRunTime.unboxToInt((Object)((TraversableOnce)dimensions.filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)dim -> dim != -1)).product((Numeric)Numeric.IntIsIntegral$.MODULE$));
            seq = (Seq)dimensions.map((Function1)(JFunction1.mcII.sp & Serializable & scala.Serializable)dim -> dim == -1 ? concreteDimension : dim, Seq$.MODULE$.canBuildFrom());
        } else {
            seq = normalizedDimensions = dimensions;
        }
        if (BoxesRunTime.unboxToInt((Object)normalizedDimensions.product((Numeric)Numeric.IntIsIntegral$.MODULE$)) != size) {
            throw new IllegalArgumentException("size of dimensions must equals size of values");
        }
        return normalizedDimensions;
    }

    private Tensor$() {
        MODULE$ = this;
        this.BooleanClass = Boolean.TYPE;
        this.ByteClass = Byte.TYPE;
        this.ShortClass = Short.TYPE;
        this.IntClass = Integer.TYPE;
        this.LongClass = Long.TYPE;
        this.FloatClass = Float.TYPE;
        this.DoubleClass = Double.TYPE;
        this.StringClass = String.class;
        this.ByteStringClass = ByteString.class;
    }
}

