/*
 * Decompiled with CFR 0.152.
 */
package ml.combust.mleap.tensorflow.converter;

import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import ml.combust.mleap.core.types.BasicType;
import ml.combust.mleap.core.types.TensorType;
import ml.combust.mleap.tensor.DenseTensor;
import org.tensorflow.Tensor;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.mutable.ArrayOps;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class TensorflowConverter$ {
    public static TensorflowConverter$ MODULE$;

    static {
        new TensorflowConverter$();
    }

    public DenseTensor<?> convert(Tensor<?> tensor, TensorType tt) {
        DenseTensor denseTensor;
        int size = (int)BoxesRunTime.unboxToLong((Object)new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(tensor.shape())).product((Numeric)Numeric.LongIsIntegral$.MODULE$));
        Seq dimensions = (Seq)tt.dimensions().get();
        BasicType basicType = tt.base();
        if (BasicType.Byte$.MODULE$.equals(basicType)) {
            ByteBuffer b = ByteBuffer.allocate(Math.max(1, size));
            tensor.writeTo(b);
            denseTensor = new DenseTensor((Object)b.array(), dimensions, ClassTag$.MODULE$.Byte());
        } else if (BasicType.Int$.MODULE$.equals(basicType)) {
            IntBuffer b = IntBuffer.allocate(Math.max(1, size));
            tensor.writeTo(b);
            denseTensor = new DenseTensor((Object)b.array(), dimensions, ClassTag$.MODULE$.Int());
        } else if (BasicType.Long$.MODULE$.equals(basicType)) {
            LongBuffer b = LongBuffer.allocate(Math.max(1, size));
            tensor.writeTo(b);
            denseTensor = new DenseTensor((Object)b.array(), dimensions, ClassTag$.MODULE$.Long());
        } else if (BasicType.Float$.MODULE$.equals(basicType)) {
            FloatBuffer b = FloatBuffer.allocate(Math.max(1, size));
            tensor.writeTo(b);
            denseTensor = new DenseTensor((Object)b.array(), dimensions, ClassTag$.MODULE$.Float());
        } else if (BasicType.Double$.MODULE$.equals(basicType)) {
            DoubleBuffer b = DoubleBuffer.allocate(Math.max(1, size));
            tensor.writeTo(b);
            denseTensor = new DenseTensor((Object)b.array(), dimensions, ClassTag$.MODULE$.Double());
        } else {
            throw new RuntimeException(new StringBuilder(29).append("unsupported tensorflow type: ").append(tt).toString());
        }
        return denseTensor;
    }

    private TensorflowConverter$() {
        MODULE$ = this;
    }
}

