/*
 * Decompiled with CFR 0.152.
 */
package ml.combust.mleap.tensorflow.converter;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.util.function.BiConsumer;
import ml.combust.mleap.core.types.BasicType;
import ml.combust.mleap.core.types.TensorType;
import ml.combust.mleap.tensor.ByteString;
import ml.combust.mleap.tensor.DenseTensor;
import org.tensorflow.Tensor;
import org.tensorflow.ndarray.NdArray;
import org.tensorflow.ndarray.buffer.DataBuffers;
import org.tensorflow.types.TFloat32;
import org.tensorflow.types.TFloat64;
import org.tensorflow.types.TInt32;
import org.tensorflow.types.TInt64;
import org.tensorflow.types.TString;
import org.tensorflow.types.TUint8;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction1;

public final class TensorflowConverter$ {
    public static TensorflowConverter$ MODULE$;

    static {
        new TensorflowConverter$();
    }

    public DenseTensor<?> convert(Tensor tensor, TensorType tensorType) {
        Seq<Object> dimensions = this.getShape(tensor);
        int size = this.getSize(tensor);
        Tensor tensor2 = tensor;
        if (tensor2 instanceof TUint8) {
            TUint8 tUint8 = (TUint8)tensor2;
            ByteBuffer buffer = ByteBuffer.allocate(size);
            tUint8.read(DataBuffers.of((ByteBuffer)buffer));
            return new DenseTensor((Object)buffer.array(), dimensions, ClassTag$.MODULE$.Byte());
        }
        if (tensor2 instanceof TInt32) {
            TInt32 tInt32 = (TInt32)tensor2;
            IntBuffer buffer = IntBuffer.allocate(size);
            tInt32.read(DataBuffers.of((IntBuffer)buffer));
            return new DenseTensor((Object)buffer.array(), dimensions, ClassTag$.MODULE$.Int());
        }
        if (tensor2 instanceof TInt64) {
            TInt64 tInt64 = (TInt64)tensor2;
            LongBuffer buffer = LongBuffer.allocate(size);
            tInt64.read(DataBuffers.of((LongBuffer)buffer));
            return new DenseTensor((Object)buffer.array(), dimensions, ClassTag$.MODULE$.Long());
        }
        if (tensor2 instanceof TFloat32) {
            TFloat32 tFloat32 = (TFloat32)tensor2;
            FloatBuffer buffer = FloatBuffer.allocate(size);
            tFloat32.read(DataBuffers.of((FloatBuffer)buffer));
            return new DenseTensor((Object)buffer.array(), dimensions, ClassTag$.MODULE$.Float());
        }
        if (tensor2 instanceof TFloat64) {
            TFloat64 tFloat64 = (TFloat64)tensor2;
            DoubleBuffer buffer = DoubleBuffer.allocate(size);
            tFloat64.read(DataBuffers.of((DoubleBuffer)buffer));
            return new DenseTensor((Object)buffer.array(), dimensions, ClassTag$.MODULE$.Double());
        }
        if (tensor2 instanceof TString) {
            TString tString = (TString)tensor2;
            BasicType basicType = tensorType.base();
            if (BasicType.String$.MODULE$.equals(basicType)) {
                ArrayBuffer arrayBuffer;
                ArrayBuffer array = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
                if (dimensions.isEmpty()) {
                    arrayBuffer = array.$plus$eq(tString.getObject(new long[0]));
                } else {
                    tString.scalars().forEachIndexed((BiConsumer)new BiConsumer<long[], NdArray<String>>(array){
                        private final ArrayBuffer array$1;

                        public BiConsumer<long[], NdArray<String>> andThen(BiConsumer<? super long[], ? super NdArray<String>> x$1) {
                            return BiConsumer.super.andThen(x$1);
                        }

                        public void accept(long[] i, NdArray<String> e) {
                            this.array$1.$plus$eq(e.getObject(new long[0]));
                        }
                        {
                            this.array$1 = array$1;
                        }
                    });
                    arrayBuffer = BoxedUnit.UNIT;
                }
                return new DenseTensor(array.toArray(ClassTag$.MODULE$.apply(String.class)), dimensions, ClassTag$.MODULE$.apply(String.class));
            }
            if (BasicType.ByteString$.MODULE$.equals(basicType)) {
                BoxedUnit boxedUnit;
                ArrayBuffer array = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
                if (dimensions.isEmpty()) {
                    boxedUnit = array.$plus$eq((Object)new ByteString((byte[])tString.asBytes().getObject(new long[0])));
                } else {
                    tString.asBytes().scalars().forEachIndexed((BiConsumer)new BiConsumer<long[], NdArray<byte[]>>(array){
                        private final ArrayBuffer array$2;

                        public BiConsumer<long[], NdArray<byte[]>> andThen(BiConsumer<? super long[], ? super NdArray<byte[]>> x$1) {
                            return BiConsumer.super.andThen(x$1);
                        }

                        public void accept(long[] i, NdArray<byte[]> e) {
                            this.array$2.$plus$eq((Object)new ByteString((byte[])e.getObject(new long[0])));
                        }
                        {
                            this.array$2 = array$2;
                        }
                    });
                    boxedUnit = BoxedUnit.UNIT;
                }
                return new DenseTensor(array.toArray(ClassTag$.MODULE$.apply(ByteString.class)), dimensions, ClassTag$.MODULE$.apply(ByteString.class));
            }
            throw new RuntimeException(new StringBuilder(59).append("unsupported ml TensorType ").append(tensorType).append(" when Tensorflow tensor is String").toString());
        }
        throw new RuntimeException(new StringBuilder(29).append("unsupported tensorflow type: ").append(tensor.dataType()).toString());
    }

    public int getSize(Tensor tensor) {
        return (int)tensor.shape().size();
    }

    public Seq<Object> getShape(Tensor tensor) {
        return (Seq)new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(tensor.shape().asArray())).toSeq().map((Function1)(JFunction1.mcIJ.sp & Serializable & scala.Serializable)x$1 -> (int)x$1, Seq$.MODULE$.canBuildFrom());
    }

    private TensorflowConverter$() {
        MODULE$ = this;
    }
}

