/*
 * Decompiled with CFR 0.152.
 */
package biz.k11i.xgboost;

import biz.k11i.xgboost.config.PredictorConfiguration;
import biz.k11i.xgboost.gbm.GradBooster;
import biz.k11i.xgboost.learner.ObjFunction;
import biz.k11i.xgboost.spark.SparkModelParam;
import biz.k11i.xgboost.util.FVec;
import biz.k11i.xgboost.util.ModelReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;

public class Predictor
implements Serializable {
    private ModelParam mparam;
    private SparkModelParam sparkModelParam;
    private String name_obj;
    private String name_gbm;
    private ObjFunction obj;
    private GradBooster gbm;

    public Predictor(InputStream inputStream) throws IOException {
        this(inputStream, null);
    }

    public Predictor(InputStream inputStream, PredictorConfiguration predictorConfiguration) throws IOException {
        if (predictorConfiguration == null) {
            predictorConfiguration = PredictorConfiguration.DEFAULT;
        }
        ModelReader modelReader = new ModelReader(inputStream);
        this.readParam(modelReader);
        this.initObjFunction(predictorConfiguration);
        this.initObjGbm();
        this.gbm.loadModel(modelReader, this.mparam.saved_with_pbuffer != 0);
    }

    void readParam(ModelReader modelReader) throws IOException {
        int n;
        float f;
        byte[] byArray = modelReader.readByteArray(4);
        byte[] byArray2 = modelReader.readByteArray(4);
        if (byArray[0] == 98 && byArray[1] == 105 && byArray[2] == 110 && byArray[3] == 102) {
            f = modelReader.asFloat(byArray2);
            n = modelReader.readUnsignedInt();
        } else if (byArray[0] == 0 && byArray[1] == 5 && byArray[2] == 95) {
            String string = null;
            if (byArray[3] == 99 && byArray2[0] == 108 && byArray2[1] == 115 && byArray2[2] == 95) {
                string = "_cls_";
            } else if (byArray[3] == 114 && byArray2[0] == 101 && byArray2[1] == 103 && byArray2[2] == 95) {
                string = "_reg_";
            }
            if (string != null) {
                int n2 = (byArray2[3] << 8) + modelReader.readByteAsInt();
                String string2 = modelReader.readUTF(n2);
                this.sparkModelParam = new SparkModelParam(string, string2, modelReader);
                f = modelReader.readFloat();
                n = modelReader.readUnsignedInt();
            } else {
                f = modelReader.asFloat(byArray);
                n = modelReader.asUnsignedInt(byArray2);
            }
        } else {
            f = modelReader.asFloat(byArray);
            n = modelReader.asUnsignedInt(byArray2);
        }
        this.mparam = new ModelParam(f, n, modelReader);
        this.name_obj = modelReader.readString();
        this.name_gbm = modelReader.readString();
    }

    void initObjFunction(PredictorConfiguration predictorConfiguration) {
        this.obj = predictorConfiguration.getObjFunction();
        if (this.obj == null) {
            this.obj = ObjFunction.fromName(this.name_obj);
        }
    }

    void initObjGbm() {
        this.obj = ObjFunction.fromName(this.name_obj);
        this.gbm = GradBooster.Factory.createGradBooster(this.name_gbm);
        this.gbm.setNumClass(this.mparam.num_class);
    }

    public double[] predict(FVec fVec) {
        return this.predict(fVec, false);
    }

    public double[] predict(FVec fVec, boolean bl) {
        return this.predict(fVec, bl, 0);
    }

    public double[] predict(FVec fVec, boolean bl, int n) {
        double[] dArray = this.predictRaw(fVec, n);
        if (!bl) {
            return this.obj.predTransform(dArray);
        }
        return dArray;
    }

    double[] predictRaw(FVec fVec, int n) {
        double[] dArray = this.gbm.predict(fVec, n);
        int n2 = 0;
        while (n2 < dArray.length) {
            int n3 = n2++;
            dArray[n3] = dArray[n3] + (double)this.mparam.base_score;
        }
        return dArray;
    }

    public double predictSingle(FVec fVec) {
        return this.predictSingle(fVec, false);
    }

    public double predictSingle(FVec fVec, boolean bl) {
        return this.predictSingle(fVec, bl, 0);
    }

    public double predictSingle(FVec fVec, boolean bl, int n) {
        double d = this.predictSingleRaw(fVec, n);
        if (!bl) {
            return this.obj.predTransform(d);
        }
        return d;
    }

    double predictSingleRaw(FVec fVec, int n) {
        return this.gbm.predictSingle(fVec, n) + (double)this.mparam.base_score;
    }

    public int[] predictLeaf(FVec fVec) {
        return this.predictLeaf(fVec, 0);
    }

    public int[] predictLeaf(FVec fVec, int n) {
        return this.gbm.predictLeaf(fVec, n);
    }

    public SparkModelParam getSparkModelParam() {
        return this.sparkModelParam;
    }

    public int getNumClass() {
        return this.mparam.num_class;
    }

    static class ModelParam
    implements Serializable {
        final float base_score;
        final int num_feature;
        final int num_class;
        final int saved_with_pbuffer;
        final int[] reserved;

        ModelParam(float f, int n, ModelReader modelReader) throws IOException {
            this.base_score = f;
            this.num_feature = n;
            this.num_class = modelReader.readInt();
            this.saved_with_pbuffer = modelReader.readInt();
            this.reserved = modelReader.readIntArray(30);
        }
    }
}

