/*
 * Decompiled with CFR 0.152.
 */
package biz.k11i.xgboost.gbm;

import biz.k11i.xgboost.gbm.GBBase;
import biz.k11i.xgboost.util.FVec;
import biz.k11i.xgboost.util.ModelReader;
import java.io.IOException;
import java.io.Serializable;

public class GBLinear
extends GBBase {
    private ModelParam mparam;
    private float[] weights;

    GBLinear() {
    }

    @Override
    public void loadModel(ModelReader modelReader, boolean bl) throws IOException {
        this.mparam = new ModelParam(modelReader);
        modelReader.readInt();
        this.weights = modelReader.readFloatArray((this.mparam.num_feature + 1) * this.mparam.num_output_group);
    }

    @Override
    public double[] predict(FVec fVec, int n) {
        double[] dArray = new double[this.mparam.num_output_group];
        for (int i = 0; i < this.mparam.num_output_group; ++i) {
            dArray[i] = this.pred(fVec, i);
        }
        return dArray;
    }

    @Override
    public double predictSingle(FVec fVec, int n) {
        if (this.mparam.num_output_group != 1) {
            throw new IllegalStateException("Can't invoke predictSingle() because this model outputs multiple values: " + this.mparam.num_output_group);
        }
        return this.pred(fVec, 0);
    }

    double pred(FVec fVec, int n) {
        double d = this.bias(n);
        for (int i = 0; i < this.mparam.num_feature; ++i) {
            double d2 = fVec.fvalue(i);
            if (Double.isNaN(d2)) continue;
            d += d2 * (double)this.weight(i, n);
        }
        return d;
    }

    @Override
    public int[] predictLeaf(FVec fVec, int n) {
        throw new UnsupportedOperationException("gblinear does not support predict leaf index");
    }

    float weight(int n, int n2) {
        return this.weights[n * this.mparam.num_output_group + n2];
    }

    float bias(int n) {
        return this.weights[this.mparam.num_feature * this.mparam.num_output_group + n];
    }

    static class ModelParam
    implements Serializable {
        final int num_feature;
        final int num_output_group;
        final int[] reserved;

        ModelParam(ModelReader modelReader) throws IOException {
            this.num_feature = modelReader.readInt();
            this.num_output_group = modelReader.readInt();
            this.reserved = modelReader.readIntArray(32);
            modelReader.readInt();
        }
    }
}

