/*
 * Decompiled with CFR 0.152.
 */
package biz.k11i.xgboost.gbm;

import biz.k11i.xgboost.gbm.GBBase;
import biz.k11i.xgboost.tree.RegTree;
import biz.k11i.xgboost.util.FVec;
import biz.k11i.xgboost.util.ModelReader;
import java.io.IOException;
import java.io.Serializable;

public class GBTree
extends GBBase {
    private ModelParam mparam;
    private RegTree[] trees;
    private int[] tree_info;
    private RegTree[][] _groupTrees;

    GBTree() {
    }

    @Override
    public void loadModel(ModelReader modelReader, boolean bl) throws IOException {
        int n;
        this.mparam = new ModelParam(modelReader);
        this.trees = new RegTree[this.mparam.num_trees];
        for (n = 0; n < this.mparam.num_trees; ++n) {
            this.trees[n] = new RegTree();
            this.trees[n].loadModel(modelReader);
        }
        if (this.mparam.num_trees != 0) {
            this.tree_info = modelReader.readIntArray(this.mparam.num_trees);
        }
        if (this.mparam.num_pbuffer != 0L && bl) {
            modelReader.skip(4L * this.mparam.predBufferSize());
            modelReader.skip(4L * this.mparam.predBufferSize());
        }
        this._groupTrees = new RegTree[this.mparam.num_output_group][];
        for (n = 0; n < this.mparam.num_output_group; ++n) {
            int n2;
            int n3 = 0;
            for (n2 = 0; n2 < this.tree_info.length; ++n2) {
                if (this.tree_info[n2] != n) continue;
                ++n3;
            }
            this._groupTrees[n] = new RegTree[n3];
            n3 = 0;
            for (n2 = 0; n2 < this.tree_info.length; ++n2) {
                if (this.tree_info[n2] != n) continue;
                this._groupTrees[n][n3++] = this.trees[n2];
            }
        }
    }

    @Override
    public double[] predict(FVec fVec, int n) {
        double[] dArray = new double[this.mparam.num_output_group];
        for (int i = 0; i < this.mparam.num_output_group; ++i) {
            dArray[i] = this.pred(fVec, i, 0, n);
        }
        return dArray;
    }

    @Override
    public double predictSingle(FVec fVec, int n) {
        if (this.mparam.num_output_group != 1) {
            throw new IllegalStateException("Can't invoke predictSingle() because this model outputs multiple values: " + this.mparam.num_output_group);
        }
        return this.pred(fVec, 0, 0, n);
    }

    double pred(FVec fVec, int n, int n2, int n3) {
        RegTree[] regTreeArray = this._groupTrees[n];
        int n4 = n3 == 0 ? regTreeArray.length : n3;
        double d = 0.0;
        for (int i = 0; i < n4; ++i) {
            d += regTreeArray[i].getLeafValue(fVec, n2);
        }
        return d;
    }

    @Override
    public int[] predictLeaf(FVec fVec, int n) {
        return this.predPath(fVec, 0, n);
    }

    int[] predPath(FVec fVec, int n, int n2) {
        int n3 = n2 == 0 ? this.trees.length : n2;
        int[] nArray = new int[n3];
        for (int i = 0; i < n3; ++i) {
            nArray[i] = this.trees[i].getLeafIndex(fVec, n);
        }
        return nArray;
    }

    static class ModelParam
    implements Serializable {
        final int num_trees;
        final int num_roots;
        final int num_feature;
        final long num_pbuffer;
        final int num_output_group;
        final int size_leaf_vector;
        final int[] reserved;

        ModelParam(ModelReader modelReader) throws IOException {
            this.num_trees = modelReader.readInt();
            this.num_roots = modelReader.readInt();
            this.num_feature = modelReader.readInt();
            modelReader.readInt();
            this.num_pbuffer = modelReader.readLong();
            this.num_output_group = modelReader.readInt();
            this.size_leaf_vector = modelReader.readInt();
            this.reserved = modelReader.readIntArray(31);
            modelReader.readInt();
        }

        long predBufferSize() {
            return (long)this.num_output_group * this.num_pbuffer * (long)(this.size_leaf_vector + 1);
        }
    }
}

