/*
 * Decompiled with CFR 0.152.
 */
package biz.k11i.xgboost.spark;

import biz.k11i.xgboost.util.ModelReader;
import java.io.IOException;
import java.io.Serializable;

public class SparkModelParam
implements Serializable {
    public static final String MODEL_TYPE_CLS = "_cls_";
    public static final String MODEL_TYPE_REG = "_reg_";
    final String modelType;
    final String featureCol;
    final String labelCol;
    final String predictionCol;
    final String rawPredictionCol;
    final double[] thresholds;

    public SparkModelParam(String string, String string2, ModelReader modelReader) throws IOException {
        this.modelType = string;
        this.featureCol = string2;
        this.labelCol = modelReader.readUTF();
        this.predictionCol = modelReader.readUTF();
        if (MODEL_TYPE_CLS.equals(string)) {
            this.rawPredictionCol = modelReader.readUTF();
            int n = modelReader.readIntBE();
            this.thresholds = n > 0 ? modelReader.readDoubleArrayBE(n) : null;
        } else if (MODEL_TYPE_REG.equals(string)) {
            this.rawPredictionCol = null;
            this.thresholds = null;
        } else {
            throw new UnsupportedOperationException("Unknown modelType: " + string);
        }
    }

    public String getModelType() {
        return this.modelType;
    }

    public String getFeatureCol() {
        return this.featureCol;
    }

    public String getLabelCol() {
        return this.labelCol;
    }

    public String getPredictionCol() {
        return this.predictionCol;
    }

    public String getRawPredictionCol() {
        return this.rawPredictionCol;
    }

    public double[] getThresholds() {
        return this.thresholds;
    }
}

