/*
 * Decompiled with CFR 0.152.
 */
package biz.k11i.xgboost.learner;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import net.jafama.FastMath;

public class ObjFunction
implements Serializable {
    private static final Map<String, ObjFunction> FUNCTIONS = new HashMap<String, ObjFunction>();

    public static ObjFunction fromName(String string) {
        ObjFunction objFunction = FUNCTIONS.get(string);
        if (objFunction == null) {
            throw new IllegalArgumentException(string + " is not supported objective function.");
        }
        return objFunction;
    }

    public static void register(String string, ObjFunction objFunction) {
        FUNCTIONS.put(string, objFunction);
    }

    public static void useFastMathExp(boolean bl) {
        if (bl) {
            ObjFunction.register("binary:logistic", new RegLossObjLogistic_Jafama());
            ObjFunction.register("multi:softprob", new SoftmaxMultiClassObjProb_Jafama());
        } else {
            ObjFunction.register("binary:logistic", new RegLossObjLogistic());
            ObjFunction.register("multi:softprob", new SoftmaxMultiClassObjProb());
        }
    }

    public double[] predTransform(double[] dArray) {
        return dArray;
    }

    public double predTransform(double d) {
        return d;
    }

    static {
        ObjFunction.register("rank:pairwise", new ObjFunction());
        ObjFunction.register("binary:logistic", new RegLossObjLogistic());
        ObjFunction.register("binary:logitraw", new ObjFunction());
        ObjFunction.register("multi:softmax", new SoftmaxMultiClassObjClassify());
        ObjFunction.register("multi:softprob", new SoftmaxMultiClassObjProb());
        ObjFunction.register("reg:linear", new ObjFunction());
    }

    static class SoftmaxMultiClassObjProb_Jafama
    extends SoftmaxMultiClassObjProb {
        SoftmaxMultiClassObjProb_Jafama() {
        }

        @Override
        double exp(double d) {
            return FastMath.exp((double)d);
        }
    }

    static class SoftmaxMultiClassObjProb
    extends ObjFunction {
        SoftmaxMultiClassObjProb() {
        }

        @Override
        public double[] predTransform(double[] dArray) {
            int n;
            double d = dArray[0];
            for (int i = 1; i < dArray.length; ++i) {
                d = Math.max(dArray[i], d);
            }
            double d2 = 0.0;
            for (n = 0; n < dArray.length; ++n) {
                dArray[n] = this.exp(dArray[n] - d);
                d2 += dArray[n];
            }
            n = 0;
            while (n < dArray.length) {
                int n2 = n++;
                dArray[n2] = dArray[n2] / (double)((float)d2);
            }
            return dArray;
        }

        @Override
        public double predTransform(double d) {
            throw new UnsupportedOperationException();
        }

        double exp(double d) {
            return Math.exp(d);
        }
    }

    static class SoftmaxMultiClassObjClassify
    extends ObjFunction {
        SoftmaxMultiClassObjClassify() {
        }

        @Override
        public double[] predTransform(double[] dArray) {
            int n = 0;
            double d = dArray[0];
            for (int i = 1; i < dArray.length; ++i) {
                if (!(d < dArray[i])) continue;
                n = i;
                d = dArray[i];
            }
            return new double[]{n};
        }

        @Override
        public double predTransform(double d) {
            throw new UnsupportedOperationException();
        }
    }

    static class RegLossObjLogistic_Jafama
    extends RegLossObjLogistic {
        RegLossObjLogistic_Jafama() {
        }

        @Override
        double sigmoid(double d) {
            return 1.0 / (1.0 + FastMath.exp((double)(-d)));
        }
    }

    static class RegLossObjLogistic
    extends ObjFunction {
        RegLossObjLogistic() {
        }

        @Override
        public double[] predTransform(double[] dArray) {
            for (int i = 0; i < dArray.length; ++i) {
                dArray[i] = this.sigmoid(dArray[i]);
            }
            return dArray;
        }

        @Override
        public double predTransform(double d) {
            return this.sigmoid(d);
        }

        double sigmoid(double d) {
            return 1.0 / (1.0 + Math.exp(-d));
        }
    }
}

