/*
 * Decompiled with CFR 0.152.
 */
package biz.k11i.xgboost.tree;

import biz.k11i.xgboost.util.FVec;
import biz.k11i.xgboost.util.ModelReader;
import java.io.IOException;
import java.io.Serializable;

public class RegTree
implements Serializable {
    private Param param;
    private Node[] nodes;
    private RTreeNodeStat[] stats;

    public void loadModel(ModelReader modelReader) throws IOException {
        int n;
        this.param = new Param(modelReader);
        this.nodes = new Node[this.param.num_nodes];
        for (n = 0; n < this.param.num_nodes; ++n) {
            this.nodes[n] = new Node(modelReader);
        }
        this.stats = new RTreeNodeStat[this.param.num_nodes];
        for (n = 0; n < this.param.num_nodes; ++n) {
            this.stats[n] = new RTreeNodeStat(modelReader);
        }
    }

    public int getLeafIndex(FVec fVec, int n) {
        int n2 = n;
        while (true) {
            Node node = this.nodes[n2];
            if (node._isLeaf) break;
            n2 = node.next(fVec);
        }
        return n2;
    }

    public double getLeafValue(FVec fVec, int n) {
        Node node = this.nodes[n];
        while (!node._isLeaf) {
            node = this.nodes[node.next(fVec)];
        }
        return node.leaf_value;
    }

    static class RTreeNodeStat
    implements Serializable {
        final float loss_chg;
        final float sum_hess;
        final float base_weight;
        final int leaf_child_cnt;

        RTreeNodeStat(ModelReader modelReader) throws IOException {
            this.loss_chg = modelReader.readFloat();
            this.sum_hess = modelReader.readFloat();
            this.base_weight = modelReader.readFloat();
            this.leaf_child_cnt = modelReader.readInt();
        }
    }

    static class Node
    implements Serializable {
        final int parent_;
        final int cleft_;
        final int cright_;
        final int sindex_;
        final double leaf_value;
        final double split_cond;
        private final int _defaultNext;
        private final int _splitIndex;
        final boolean _isLeaf;

        Node(ModelReader modelReader) throws IOException {
            this.parent_ = modelReader.readInt();
            this.cleft_ = modelReader.readInt();
            this.cright_ = modelReader.readInt();
            this.sindex_ = modelReader.readInt();
            if (this.is_leaf()) {
                this.leaf_value = modelReader.readFloat();
                this.split_cond = Double.NaN;
            } else {
                this.split_cond = modelReader.readFloat();
                this.leaf_value = Double.NaN;
            }
            this._defaultNext = this.cdefault();
            this._splitIndex = this.split_index();
            this._isLeaf = this.is_leaf();
        }

        boolean is_leaf() {
            return this.cleft_ == -1;
        }

        int split_index() {
            return (int)((long)this.sindex_ & Integer.MAX_VALUE);
        }

        int cdefault() {
            return this.default_left() ? this.cleft_ : this.cright_;
        }

        boolean default_left() {
            return this.sindex_ >>> 31 != 0;
        }

        int next(FVec fVec) {
            double d = fVec.fvalue(this._splitIndex);
            if (d != d) {
                return this._defaultNext;
            }
            return d < this.split_cond ? this.cleft_ : this.cright_;
        }
    }

    static class Param
    implements Serializable {
        final int num_roots;
        final int num_nodes;
        final int num_deleted;
        final int max_depth;
        final int num_feature;
        final int size_leaf_vector;
        final int[] reserved;

        Param(ModelReader modelReader) throws IOException {
            this.num_roots = modelReader.readInt();
            this.num_nodes = modelReader.readInt();
            this.num_deleted = modelReader.readInt();
            this.max_depth = modelReader.readInt();
            this.num_feature = modelReader.readInt();
            this.size_leaf_vector = modelReader.readInt();
            this.reserved = modelReader.readIntArray(31);
        }
    }
}

