/*
 * Decompiled with CFR 0.152.
 */
package biz.k11i.xgboost.util;

import java.io.Closeable;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UTFDataFormatException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;

public class ModelReader
implements Closeable {
    private final InputStream stream;
    private byte[] buffer;

    @Deprecated
    public ModelReader(String string) throws IOException {
        this(new FileInputStream(string));
    }

    public ModelReader(InputStream inputStream) throws IOException {
        this.stream = inputStream;
    }

    private int fillBuffer(int n) throws IOException {
        int n2;
        int n3;
        if (this.buffer == null || this.buffer.length < n) {
            this.buffer = new byte[n];
        }
        for (n2 = 0; n2 < n; n2 += n3) {
            n3 = this.stream.read(this.buffer, n2, n - n2);
            if (n3 >= 0) continue;
            return n2;
        }
        return n2;
    }

    public int readByteAsInt() throws IOException {
        return this.stream.read();
    }

    public byte[] readByteArray(int n) throws IOException {
        int n2 = this.fillBuffer(n);
        if (n2 < n) {
            throw new EOFException(String.format("Cannot read byte array (shortage): expected = %d, actual = %d", n, n2));
        }
        byte[] byArray = new byte[n];
        System.arraycopy(this.buffer, 0, byArray, 0, n);
        return byArray;
    }

    public int readInt() throws IOException {
        return this.readInt(ByteOrder.LITTLE_ENDIAN);
    }

    public int readIntBE() throws IOException {
        return this.readInt(ByteOrder.BIG_ENDIAN);
    }

    private int readInt(ByteOrder byteOrder) throws IOException {
        int n = this.fillBuffer(4);
        if (n < 4) {
            throw new EOFException("Cannot read int value (shortage): " + n);
        }
        return ByteBuffer.wrap(this.buffer).order(byteOrder).getInt();
    }

    public int[] readIntArray(int n) throws IOException {
        int n2 = this.fillBuffer(n * 4);
        if (n2 < n * 4) {
            throw new EOFException(String.format("Cannot read int array (shortage): expected = %d, actual = %d", n * 4, n2));
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(this.buffer).order(ByteOrder.LITTLE_ENDIAN);
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = byteBuffer.getInt();
        }
        return nArray;
    }

    public int readUnsignedInt() throws IOException {
        int n = this.readInt();
        if (n < 0) {
            throw new IOException("Cannot read unsigned int (overflow): " + n);
        }
        return n;
    }

    public long readLong() throws IOException {
        int n = this.fillBuffer(8);
        if (n < 8) {
            throw new IOException("Cannot read long value (shortage): " + n);
        }
        return ByteBuffer.wrap(this.buffer).order(ByteOrder.LITTLE_ENDIAN).getLong();
    }

    public float asFloat(byte[] byArray) {
        return ByteBuffer.wrap(byArray).order(ByteOrder.LITTLE_ENDIAN).getFloat();
    }

    public int asUnsignedInt(byte[] byArray) throws IOException {
        int n = ByteBuffer.wrap(byArray).order(ByteOrder.LITTLE_ENDIAN).getInt();
        if (n < 0) {
            throw new IOException("Cannot treat as unsigned int (overflow): " + n);
        }
        return n;
    }

    public float readFloat() throws IOException {
        int n = this.fillBuffer(4);
        if (n < 4) {
            throw new IOException("Cannot read float value (shortage): " + n);
        }
        return ByteBuffer.wrap(this.buffer).order(ByteOrder.LITTLE_ENDIAN).getFloat();
    }

    public float[] readFloatArray(int n) throws IOException {
        int n2 = this.fillBuffer(n * 4);
        if (n2 < n * 4) {
            throw new EOFException(String.format("Cannot read float array (shortage): expected = %d, actual = %d", n * 4, n2));
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(this.buffer).order(ByteOrder.LITTLE_ENDIAN);
        float[] fArray = new float[n];
        for (int i = 0; i < n; ++i) {
            fArray[i] = byteBuffer.getFloat();
        }
        return fArray;
    }

    public double[] readDoubleArrayBE(int n) throws IOException {
        int n2 = this.fillBuffer(n * 8);
        if (n2 < n * 8) {
            throw new EOFException(String.format("Cannot read double array (shortage): expected = %d, actual = %d", n * 8, n2));
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(this.buffer).order(ByteOrder.BIG_ENDIAN);
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = byteBuffer.getDouble();
        }
        return dArray;
    }

    public void skip(long l) throws IOException {
        long l2 = this.stream.skip(l);
        if (l2 < l) {
            throw new IOException("Cannot skip bytes: " + l2);
        }
    }

    public String readString() throws IOException {
        long l = this.readLong();
        if (l > Integer.MAX_VALUE) {
            throw new IOException("Too long string: " + l);
        }
        return this.readString((int)l);
    }

    public String readString(int n) throws IOException {
        int n2 = this.fillBuffer(n);
        if (n2 < n) {
            throw new IOException(String.format("Cannot read string(%d) (shortage): %d", n, n2));
        }
        return new String(this.buffer, 0, n, Charset.forName("UTF-8"));
    }

    public String readUTF() throws IOException {
        int n = this.readByteAsInt();
        n = (short)(n << 8 | this.readByteAsInt());
        return this.readUTF(n);
    }

    public String readUTF(int n) throws IOException {
        int n2;
        int n3;
        int n4 = this.fillBuffer(n);
        if (n4 < n) {
            throw new EOFException(String.format("Cannot read UTF string bytes: expected = %d, actual = %d", n, n4));
        }
        char[] cArray = new char[n];
        int n5 = 0;
        for (n3 = 0; n3 < n && (n2 = this.buffer[n3] & 0xFF) <= 127; ++n3) {
            cArray[n5++] = (char)n2;
        }
        block6: while (n3 < n) {
            n2 = this.buffer[n3] & 0xFF;
            switch (n2 >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++n3;
                    cArray[n5++] = (char)n2;
                    continue block6;
                }
                case 12: 
                case 13: {
                    if ((n3 += 2) > n) {
                        throw new UTFDataFormatException("malformed input: partial character at end");
                    }
                    byte by = this.buffer[n3 - 1];
                    if ((by & 0xC0) != 128) {
                        throw new UTFDataFormatException("malformed input around byte " + n3);
                    }
                    cArray[n5++] = (char)((n2 & 0x1F) << 6 | by & 0x3F);
                    continue block6;
                }
                case 14: {
                    if ((n3 += 3) > n) {
                        throw new UTFDataFormatException("malformed input: partial character at end");
                    }
                    byte by = this.buffer[n3 - 2];
                    byte by2 = this.buffer[n3 - 1];
                    if ((by & 0xC0) != 128 || (by2 & 0xC0) != 128) {
                        throw new UTFDataFormatException("malformed input around byte " + (n3 - 1));
                    }
                    cArray[n5++] = (char)((n2 & 0xF) << 12 | (by & 0x3F) << 6 | (by2 & 0x3F) << 0);
                    continue block6;
                }
            }
            throw new UTFDataFormatException("malformed input around byte " + n3);
        }
        return new String(cArray, 0, n5);
    }

    @Override
    public void close() throws IOException {
        this.stream.close();
    }
}

