/*
 * Decompiled with CFR 0.152.
 */
package ml.comet.examples;

import java.io.File;
import java.io.IOException;
import java.util.Scanner;
import ml.comet.experiment.OnlineExperiment;
import ml.comet.experiment.OnlineExperimentImpl;
import org.apache.commons.io.FileUtils;

public class OnlineExperimentExample {
    public static void main(String[] args) throws IOException {
        OnlineExperimentImpl experiment = new OnlineExperimentImpl();
        experiment.setInterceptStdout();
        experiment.setExperimentName("Java-SDK15");
        experiment.nextStep();
        experiment.logMetric("strMetric", (Object)"123");
        experiment.logMetric("numMetric", (Object)123, 123L);
        experiment.logMetric("doubleMetric", (Object)123.5);
        OnlineExperimentExample.generateCharts((OnlineExperiment)experiment);
        experiment.setStep(1234L);
        experiment.logHtml(OnlineExperimentExample.generateCustomHtmlReport(), false);
        experiment.logParameter("batch_size", (Object)"500");
        experiment.logParameter("learning_rate", (Object)12);
        experiment.uploadAsset(OnlineExperimentExample.getFile("chart.png"), "amazing chart.png", false);
        experiment.uploadAsset(OnlineExperimentExample.getFile("model.hd5"), false);
        experiment.logOther("Parameter", (Object)4);
        System.out.println("Epoch 1/20");
        System.out.println("- loss: 0.7858 - acc: 0.7759 - val_loss: 0.3416 - val_acc: 0.9026");
        experiment.logGraph(OnlineExperimentExample.loadGraph("graph.json"));
        experiment.end();
    }

    public static String askUserForInputOn(String message) {
        System.out.println(message);
        Scanner scan = new Scanner(System.in);
        String s = scan.next();
        scan.close();
        return s;
    }

    private static File getFile(String imageName) {
        File file = new File(OnlineExperimentExample.class.getClassLoader().getResource(imageName).getFile());
        return file;
    }

    private static void generateCharts(OnlineExperiment experiment) {
        int i;
        long currentStep = experiment.getStep();
        for (i = 1; i < 15; ++i) {
            experiment.logMetric("numMetric", (Object)(123 + i), currentStep + (long)i);
        }
        for (i = 1; i < 15; ++i) {
            experiment.logMetric("strMetric", (Object)("123" + i), currentStep + (long)i);
        }
        for (i = 1; i < 15; ++i) {
            experiment.logMetric("doubleMetric", (Object)(123.12 + (double)i), currentStep + (long)i);
        }
    }

    private static String generateCustomHtmlReport() throws IOException {
        File file = new File(OnlineExperimentExample.class.getClassLoader().getResource("report.html").getFile());
        return FileUtils.readFileToString((File)file, (String)"UTF-8");
    }

    private static String loadGraph(String fileName) throws IOException {
        File file = new File(OnlineExperimentExample.class.getClassLoader().getResource(fileName).getFile());
        return FileUtils.readFileToString((File)file, (String)"UTF-8");
    }
}

