/*
 * Decompiled with CFR 0.152.
 */
package ml.comet.examples;

import java.util.Objects;
import java.util.Random;
import java.util.UUID;
import ml.comet.experiment.ExperimentBuilder;
import ml.comet.experiment.OnlineExperiment;
import ml.comet.experiment.impl.config.CometConfig;

public class ExistingExperimentExample {
    public static void main(String[] args) throws Exception {
        if (Objects.isNull(System.getenv(CometConfig.COMET_EXPERIMENT_KEY.getEnvironmentKey()))) {
            System.err.println("To run this experiment you should set COMET_EXPERIMENT_KEY environment variable with ID of existing Comet experiment.");
            System.exit(1);
        }
        try (OnlineExperiment experiment = (OnlineExperiment)ExperimentBuilder.OnlineExperiment().build();){
            ExistingExperimentExample.runExample(experiment);
        }
    }

    private static void runExample(OnlineExperiment experiment) {
        Random rd = new Random();
        String metricName = UUID.randomUUID().toString();
        for (int i = 0; i < 100; ++i) {
            experiment.logMetric(metricName, (Object)(rd.nextDouble() * 20.0), (long)i);
        }
        experiment.logMetric(metricName, (Object)20, 100L);
    }
}

