/*
 * Decompiled with CFR 0.152.
 */
package ml.comet.examples;

import java.util.List;
import java.util.Objects;
import java.util.UUID;
import ml.comet.experiment.CometApi;
import ml.comet.experiment.ExperimentBuilder;
import ml.comet.experiment.OnlineExperiment;
import ml.comet.experiment.model.ExperimentMetadata;
import ml.comet.experiment.model.Project;
import ml.comet.experiment.model.Value;

public class ApiExamples {
    static final String randomExperimentName = UUID.randomUUID().toString();

    public static void main(String[] args) throws Exception {
        ApiExamples.run();
    }

    private static void run() throws Exception {
        String experimentKey;
        String experimentWorkspaceName;
        String experimentProjectName;
        try (OnlineExperiment experiment = (OnlineExperiment)ExperimentBuilder.OnlineExperiment().interceptStdout().build();){
            experiment.setExperimentName(randomExperimentName);
            experiment.logMetric("some-metric", (Object)10);
            experimentProjectName = experiment.getProjectName();
            experimentWorkspaceName = experiment.getWorkspaceName();
            experimentKey = experiment.getExperimentKey();
        }
        var4_1 = null;
        try (CometApi api = (CometApi)ExperimentBuilder.CometApi().build();){
            System.out.println("===== All user's workspaces =====");
            List availableWorkspaces = api.getAllWorkspaces();
            availableWorkspaces.forEach(System.out::println);
            System.out.println("=====\n");
            String workspace = (String)availableWorkspaces.get(0);
            System.out.printf("===== Projects in workspace: '%s' =====\n", workspace);
            List projects = api.getAllProjects(workspace);
            projects.forEach(System.out::println);
            System.out.println("=====\n");
            Project project = (Project)projects.get(0);
            System.out.printf("===== First 10 Experiments in project: '%s' =====\n", project.getProjectName());
            List experiments = api.getAllExperiments(project.getProjectId());
            experiments.stream().filter(experimentMetadata -> !Objects.isNull(experimentMetadata.getExperimentName())).limit(10L).forEach(System.out::println);
            System.out.println("=====\n");
            System.out.printf("===== Experiment(-s) by name/regex '%s' in workspace/project: '%s/%s' =====\n", randomExperimentName, experimentWorkspaceName, experimentProjectName);
            experiments = api.getExperiments(experimentWorkspaceName, experimentProjectName, randomExperimentName);
            if (experiments.size() == 1) {
                ApiExamples.displayExperiment((ExperimentMetadata)experiments.get(0));
            } else {
                System.out.printf("*** No, or more than one experiment was found. Found: %d experiments.\n", experiments.size());
            }
            System.out.println("=====\n");
            System.out.printf("===== Experiment's metadata by experiment key: '%s' =====\n", experimentKey);
            ExperimentMetadata metadata = api.getExperimentMetadata(experimentKey);
            System.out.println(metadata);
            System.out.println("=====\n");
        }
        catch (Throwable throwable) {
            var4_1 = throwable;
            throw throwable;
        }
    }

    private static void displayExperiment(ExperimentMetadata experimentMetadata) throws Exception {
        try (OnlineExperiment experiment = (OnlineExperiment)ExperimentBuilder.OnlineExperiment().withExistingExperimentKey(experimentMetadata.getExperimentKey()).build();){
            System.out.printf("\nFound experiment: [%s] with key: %s\n", experimentMetadata.getExperimentName(), experimentMetadata.getExperimentKey());
            List metrics = experiment.getMetrics();
            System.out.println("Metrics:");
            for (Value metric : metrics) {
                System.out.printf("\t%s : %s\n", metric.getName(), metric.getCurrent());
            }
            System.out.println("====================");
        }
    }
}

