/*
 * Decompiled with CFR 0.152.
 */
package ml.comet.examples;

import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import ml.comet.examples.Utils;
import ml.comet.experiment.OnlineExperiment;
import ml.comet.experiment.model.Curve;
import ml.comet.experiment.model.DataPoint;
import org.apache.commons.io.file.PathUtils;

interface BaseExample {
    public static final String CHART_IMAGE_FILE = "chart.png";
    public static final String AMAZING_CHART_NAME = "amazing chart.png";
    public static final String MODEL_FILE = "model.hd5";
    public static final String HTML_REPORT_FILE = "report.html";
    public static final String GRAPH_JSON_FILE = "graph.json";
    public static final String CODE_FILE = "code_sample.py";
    public static final Map<String, Object> SOME_METADATA = new HashMap<String, Object>(){
        {
            this.put("metaInt", 10);
            this.put("metaString", "test");
            this.put("metaBoolean", true);
        }
    };

    public static void generateCharts(OnlineExperiment experiment) {
        int i;
        long currentStep = experiment.getStep();
        Random rd = new Random();
        for (i = 1; i < 15; ++i) {
            int value = (int)(Math.sin(i) * 20.0);
            experiment.logMetric("numMetricChart", (Object)value, currentStep + (long)i, BaseExample.getUpdatedEpochValue(experiment));
        }
        for (i = 1; i < 15; ++i) {
            float value = rd.nextFloat() * 100.0f;
            experiment.logMetric("strMetricChart", (Object)String.valueOf(value), currentStep + (long)i, BaseExample.getUpdatedEpochValue(experiment));
        }
        for (i = 1; i < 15; ++i) {
            double value = Math.cos(i);
            experiment.logMetric("doubleMetricChart", (Object)(123.12 + value), currentStep + (long)i, BaseExample.getUpdatedEpochValue(experiment));
        }
    }

    public static String generateCustomHtmlReport() throws IOException {
        return Utils.readResourceToString(HTML_REPORT_FILE);
    }

    public static long getUpdatedEpochValue(OnlineExperiment experiment) {
        return experiment.getEpoch() + experiment.getStep() / 5L;
    }

    public static Path copyResourcesToTmpDir() throws IOException {
        Path root = Files.createTempDirectory("onlineExperimentExample", new FileAttribute[0]);
        PathUtils.copyFileToDirectory((Path)Objects.requireNonNull(Utils.getResourceFile(CHART_IMAGE_FILE)).toPath(), (Path)root, (CopyOption[])new CopyOption[0]);
        PathUtils.copyFileToDirectory((Path)Objects.requireNonNull(Utils.getResourceFile(MODEL_FILE)).toPath(), (Path)root, (CopyOption[])new CopyOption[0]);
        Files.createTempFile(root, "empty_file", ".txt", new FileAttribute[0]);
        Path subDir = Files.createTempDirectory(root, "subDir", new FileAttribute[0]);
        PathUtils.copyFileToDirectory((Path)Objects.requireNonNull(Utils.getResourceFile(HTML_REPORT_FILE)).toPath(), (Path)subDir, (CopyOption[])new CopyOption[0]);
        PathUtils.copyFileToDirectory((Path)Objects.requireNonNull(Utils.getResourceFile(GRAPH_JSON_FILE)).toPath(), (Path)subDir, (CopyOption[])new CopyOption[0]);
        return root;
    }

    public static Map<String, Object> createMetaData() {
        HashMap<String, Object> metadata = new HashMap<String, Object>();
        metadata.put("someInt", 10);
        metadata.put("someString", "test string");
        metadata.put("someBoolean", true);
        return metadata;
    }

    public static Curve buildCurve(String name, int pointsCount) {
        DataPoint[] dataPoints = new DataPoint[pointsCount];
        for (int i = 0; i < pointsCount; ++i) {
            dataPoints[i] = DataPoint.of((float)i, (float)((float)Math.log((i + 1) * 10)));
        }
        return new Curve(dataPoints, name);
    }
}

