/*
 * Decompiled with CFR 0.152.
 */
package ml.comet.examples;

import java.net.URI;
import java.nio.file.Path;
import ml.comet.examples.BaseExample;
import ml.comet.examples.Utils;
import ml.comet.experiment.ExperimentBuilder;
import ml.comet.experiment.OnlineExperiment;
import ml.comet.experiment.context.ExperimentContext;
import ml.comet.experiment.model.Curve;
import org.apache.commons.io.file.PathUtils;

public class OnlineExperimentExample
implements BaseExample {
    public static void main(String[] args) throws Exception {
        OnlineExperiment experiment = (OnlineExperiment)ExperimentBuilder.OnlineExperiment().interceptStdout().build();
        try {
            OnlineExperimentExample.run(experiment);
        }
        finally {
            experiment.end();
        }
    }

    private static void run(OnlineExperiment experiment) throws Exception {
        experiment.setExperimentName("OnlineExperimentExample");
        experiment.nextStep();
        experiment.logMetric("strMetric", (Object)"123", 1L);
        experiment.logMetric("numMetric", (Object)123, 123L, 4L);
        experiment.nextEpoch();
        experiment.logMetric("doubleMetric", (Object)123.5, 1L);
        experiment.setEpoch(3L);
        BaseExample.generateCharts(experiment);
        experiment.setStep(1234L);
        experiment.logHtml(BaseExample.generateCustomHtmlReport(), false);
        experiment.logParameter("batch_size", (Object)"500");
        experiment.logParameter("learning_rate", (Object)12);
        experiment.logText("Sample text", ExperimentContext.builder().withContext("train").withStep(12L).build(), SOME_METADATA);
        Curve curve = BaseExample.buildCurve("Sample curve", 100);
        experiment.logCurve(curve, false);
        experiment.uploadAsset(Utils.getResourceFile("chart.png"), "amazing chart.png", false);
        experiment.uploadAsset(Utils.getResourceFile("model.hd5"), false, ExperimentContext.builder().withContext("train").build());
        experiment.nextStep();
        Path assetDir = BaseExample.copyResourcesToTmpDir();
        experiment.logAssetFolder(assetDir.toFile(), true, true);
        experiment.logRemoteAsset(new URI("s3://bucket/folder/dataCorpus.hd5"), "modelDataCorpus", false);
        experiment.logOther("Parameter", (Object)4);
        System.out.println("Epoch 1/20");
        System.out.println("- loss: 0.7858 - acc: 0.7759 - val_loss: 0.3416 - val_acc: 0.9026");
        experiment.logGraph(Utils.readResourceToString("graph.json"));
        experiment.logCode(Utils.getResourceFile("code_sample.py"), ExperimentContext.builder().withContext("test").build());
        System.out.println("===== Experiment completed ====");
        experiment.end();
        PathUtils.deleteDirectory((Path)assetDir);
    }
}

