/*
 * Decompiled with CFR 0.152.
 */
package ml.comet.examples;

import java.io.IOException;
import ml.comet.examples.Utils;
import ml.comet.experiment.OnlineExperiment;
import ml.comet.experiment.OnlineExperimentImpl;

public class OnlineExperimentExample {
    public static void main(String[] args) {
        OnlineExperimentExample main = new OnlineExperimentExample();
        try {
            main.run();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void run() throws IOException {
        OnlineExperimentImpl experiment = new OnlineExperimentImpl();
        experiment.setInterceptStdout();
        experiment.setExperimentName("Java-SDK 2.0.2");
        experiment.nextStep();
        experiment.logMetric("strMetric", (Object)"123");
        experiment.logMetric("numMetric", (Object)123, 123L, 4L);
        experiment.nextEpoch();
        experiment.logMetric("doubleMetric", (Object)123.5);
        experiment.setEpoch(3L);
        OnlineExperimentExample.generateCharts((OnlineExperiment)experiment);
        experiment.setStep(1234L);
        experiment.logHtml(OnlineExperimentExample.generateCustomHtmlReport(), false);
        experiment.logParameter("batch_size", (Object)"500");
        experiment.logParameter("learning_rate", (Object)12);
        experiment.uploadAsset(Utils.getResourceFile("chart.png"), "amazing chart.png", false);
        experiment.uploadAsset(Utils.getResourceFile("model.hd5"), false);
        experiment.logOther("Parameter", (Object)4);
        System.out.println("Epoch 1/20");
        System.out.println("- loss: 0.7858 - acc: 0.7759 - val_loss: 0.3416 - val_acc: 0.9026");
        experiment.logGraph(Utils.readResourceToString("graph.json"));
        System.out.println("===== Experiment completed ====");
        experiment.end();
    }

    private static void generateCharts(OnlineExperiment experiment) {
        int i;
        long currentStep = experiment.getStep();
        for (i = 1; i < 15; ++i) {
            experiment.logMetric("numMetric", (Object)(123 + i), currentStep + (long)i, OnlineExperimentExample.getUpdatedEpochValue(experiment));
        }
        for (i = 1; i < 15; ++i) {
            experiment.logMetric("strMetric", (Object)("123" + i), currentStep + (long)i, OnlineExperimentExample.getUpdatedEpochValue(experiment));
        }
        for (i = 1; i < 15; ++i) {
            experiment.logMetric("doubleMetric", (Object)(123.12 + (double)i), currentStep + (long)i, OnlineExperimentExample.getUpdatedEpochValue(experiment));
        }
    }

    private static String generateCustomHtmlReport() throws IOException {
        return Utils.readResourceToString("report.html");
    }

    private static long getUpdatedEpochValue(OnlineExperiment experiment) {
        return experiment.getEpoch() + experiment.getStep() / 5L;
    }
}

