/*
 * Decompiled with CFR 0.152.
 */
package ml.comet.examples;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import ml.comet.examples.BaseExample;
import ml.comet.examples.Utils;
import ml.comet.experiment.ExperimentBuilder;
import ml.comet.experiment.OnlineExperiment;
import ml.comet.experiment.artifact.Artifact;
import ml.comet.experiment.artifact.ArtifactAsset;
import ml.comet.experiment.artifact.AssetOverwriteStrategy;
import ml.comet.experiment.artifact.DownloadedArtifact;
import ml.comet.experiment.artifact.LoggedArtifact;
import ml.comet.experiment.artifact.LoggedArtifactAsset;
import org.apache.commons.io.IOUtils;

public class ArtifactExample
implements BaseExample {
    private static final Map<String, Object> SOME_METADATA = new HashMap<String, Object>();

    public static void main(String[] args) throws Exception {
        try (OnlineExperiment experiment = (OnlineExperiment)ExperimentBuilder.OnlineExperiment().interceptStdout().build();){
            ArtifactExample.run(experiment);
        }
    }

    private static void run(OnlineExperiment experiment) throws Exception {
        experiment.setExperimentName("Artifact Example");
        List<String> aliases = Arrays.asList("alias1", "alias2");
        List<String> tags = Arrays.asList("tag1", "tag2");
        String artifactName = "someArtifact";
        String artifactType = "someType";
        Artifact artifact = Artifact.newArtifact((String)artifactName, (String)artifactType).withAliases(aliases).withVersionTags(tags).withMetadata(SOME_METADATA).build();
        URI firstAssetLink = new URI("s3://bucket/folder/firstAssetFile.extension");
        String firstAssetFileName = "firstAssetFileName";
        artifact.addRemoteAsset(firstAssetLink, firstAssetFileName);
        String secondAssetExpectedFileName = "secondAssetFile.extension";
        URI secondAssetLink = new URI("s3://bucket/folder/" + secondAssetExpectedFileName);
        artifact.addRemoteAsset(secondAssetLink, secondAssetExpectedFileName);
        artifact.addAsset(Utils.getResourceFile("chart.png"), "amazing chart.png", false, SOME_METADATA);
        artifact.addAsset(Utils.getResourceFile("model.hd5"), false);
        byte[] someData = "some data".getBytes(StandardCharsets.UTF_8);
        String someDataName = "someDataName";
        artifact.addAsset(someData, someDataName);
        Path assetDir = BaseExample.copyResourcesToTmpDir();
        artifact.addAssetFolder(assetDir.toFile(), true, true);
        CompletableFuture futureArtifact = experiment.logArtifact(artifact);
        LoggedArtifact loggedArtifact = (LoggedArtifact)futureArtifact.get(60L, TimeUnit.SECONDS);
        System.out.printf("\nArtifact upload complete: %s\n\n", loggedArtifact.getFullName());
        Collection loggedAssets = loggedArtifact.getAssets();
        System.out.printf("Received %d logged artifact assets from the Comet server. Downloading asset files...\n", loggedAssets.size());
        Path assetsTmpDir = Files.createTempDirectory("ArtifactExampleAssets", new FileAttribute[0]);
        loggedAssets.forEach(loggedArtifactAsset -> {
            if (!loggedArtifactAsset.isRemote()) {
                ArtifactAsset asset = loggedArtifactAsset.download(assetsTmpDir);
                System.out.printf("Downloaded asset '%s' of size %d bytes to '%s'\n", asset.getLogicalPath(), asset.getSize().orElse(0L), asset.getFile());
            } else {
                URI uri = loggedArtifactAsset.getLink().orElse(null);
                System.out.printf("Skipping download of the remote asset %s. It must be downloaded using its URI '%s'\n", loggedArtifactAsset.getLogicalPath(), uri);
            }
        });
        System.out.printf("Assets of the artifact's '%s' successfully downloaded to the folder: %s\n\n", loggedArtifact.getFullName(), assetsTmpDir);
        LoggedArtifactAsset asset = loggedAssets.stream().filter(loggedArtifactAsset -> {
            Long size = loggedArtifactAsset.getSize().orElse(0L);
            return !loggedArtifactAsset.isRemote() && size > 0L;
        }).findFirst().orElse(null);
        if (asset != null) {
            System.out.printf("Loading content of the artifact asset '%s' into memory\n", asset.getAssetId());
            int buffSize = 512;
            try (BufferedInputStream in = new BufferedInputStream(asset.openStream(), buffSize);){
                int count;
                byte[] buff = IOUtils.byteArray((int)buffSize);
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                while ((count = ((InputStream)in).read(buff)) > 0) {
                    out.write(buff, 0, count);
                }
                System.out.printf("Content of the asset '%s' successfully loaded into memory, data size: %d.\n\n", asset.getLogicalPath(), out.size());
            }
            catch (Throwable t) {
                System.err.printf("Failed to read asset data, reason: %s\n\n", t);
                throw t;
            }
        }
        Path artifactTmpDir = Files.createTempDirectory("ArtifactExampleArtifact", new FileAttribute[0]);
        System.out.printf("Downloading artifact to the folder: %s\n", artifactTmpDir.toFile().getAbsoluteFile());
        DownloadedArtifact downloadedArtifact = loggedArtifact.download(artifactTmpDir, AssetOverwriteStrategy.FAIL_IF_DIFFERENT);
        Collection assets = downloadedArtifact.getAssets();
        System.out.printf("Artifact '%s' successfully downloaded. Received %d artifact assets from the Comet server.\n\n", downloadedArtifact.getFullName(), assets.size());
        System.out.printf("Starting update of the artifact: %s\n", downloadedArtifact.getFullName());
        downloadedArtifact.getAliases().add("downloaded");
        downloadedArtifact.getMetadata().put("updated", "someUpdatedValue");
        downloadedArtifact.addAsset(Utils.getResourceFile("graph.json"), "updated_graph.json", false, SOME_METADATA);
        downloadedArtifact.incrementMinorVersion();
        CompletableFuture futureUpdatedArtifact = experiment.logArtifact((Artifact)downloadedArtifact);
        loggedArtifact = (LoggedArtifact)futureUpdatedArtifact.get(60L, TimeUnit.SECONDS);
        System.out.printf("\nArtifact update completed, new artifact version created: %s\n\n", loggedArtifact.getFullName());
        System.out.printf("Finding asset '%s' of the artifact: %s\n", "amazing chart.png", loggedArtifact.getFullName());
        asset = loggedArtifact.getAsset("amazing chart.png");
        System.out.printf("Successfully found asset '%s' of the artifact: %s\n\n", asset, loggedArtifact.getFullName());
        System.out.println("===== Experiment completed ====");
    }

    static {
        SOME_METADATA.put("someInt", 10);
        SOME_METADATA.put("someString", "test string");
        SOME_METADATA.put("someBoolean", true);
    }
}

