/*
 * Decompiled with CFR 0.152.
 */
package ml.comet.examples;

import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import ml.comet.examples.BaseExample;
import ml.comet.examples.Utils;
import ml.comet.experiment.ExperimentBuilder;
import ml.comet.experiment.OnlineExperiment;
import ml.comet.experiment.context.ExperimentContext;
import ml.comet.experiment.impl.asset.AssetType;
import org.awaitility.Awaitility;

public class LogModelExample
implements BaseExample {
    static final String SOME_MODEL_NAME = "someModelNameExample";
    static final String SOME_MODEL_LOGICAL_PATH = "someExampleModelData.dat";
    static final String SOME_MODEL_DATA = "some model data string";

    public static void main(String[] args) throws Exception {
        try (OnlineExperiment experiment = (OnlineExperiment)ExperimentBuilder.OnlineExperiment().interceptStdout().build();){
            LogModelExample.run(experiment);
        }
    }

    private static void run(OnlineExperiment experiment) throws Exception {
        experiment.setExperimentName("LogModel Examples");
        ExperimentContext context = new ExperimentContext(0L, 0L, "example");
        Map<String, Object> metadata = BaseExample.createMetaData();
        File file = Utils.getResourceFile("chart.png");
        experiment.logModel(SOME_MODEL_NAME, file, "amazing chart.png", true, metadata, context);
        System.out.printf("Logging file '%s' of the model '%s' with logical path '%s'\n\n", file, SOME_MODEL_NAME, "amazing chart.png");
        byte[] data = SOME_MODEL_DATA.getBytes(StandardCharsets.UTF_8);
        experiment.logModel(SOME_MODEL_NAME, data, SOME_MODEL_LOGICAL_PATH, true, metadata, context);
        System.out.printf("Logging data of the model '%s' with logical path '%s'\n\n", SOME_MODEL_NAME, SOME_MODEL_LOGICAL_PATH);
        Path assetDir = BaseExample.copyResourcesToTmpDir();
        experiment.logModelFolder(SOME_MODEL_NAME, assetDir.toFile(), true, metadata, context);
        System.out.printf("Logging data folder '%s' of the model '%s''\n\n", assetDir, SOME_MODEL_NAME);
        ArrayList assets = new ArrayList();
        Awaitility.await((String)"failed to wait for model's assets to be uploaded").atMost(60L, TimeUnit.SECONDS).pollInterval(1L, TimeUnit.SECONDS).until(() -> {
            List loggedAsset = experiment.getAssetList(AssetType.MODEL_ELEMENT.type());
            if (loggedAsset.size() > 0) {
                assets.addAll(loggedAsset);
                return true;
            }
            return false;
        });
        System.out.printf("Retrieved %d logged assets of the model '%s':\n", assets.size(), SOME_MODEL_NAME);
        assets.forEach(loggedExperimentAsset -> System.out.printf("\t%s\n", loggedExperimentAsset));
        System.out.println("===== Experiment completed ====");
    }
}

