/*
 * Decompiled with CFR 0.152.
 */
package ml.comet.examples;

import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import ml.comet.examples.BaseExample;
import ml.comet.experiment.CometApi;
import ml.comet.experiment.ExperimentBuilder;
import ml.comet.experiment.OnlineExperiment;
import ml.comet.experiment.context.ExperimentContext;
import ml.comet.experiment.impl.asset.AssetType;
import ml.comet.experiment.impl.utils.ModelUtils;
import ml.comet.experiment.registrymodel.DownloadModelOptions;
import ml.comet.experiment.registrymodel.Model;
import ml.comet.experiment.registrymodel.ModelDownloadInfo;
import ml.comet.experiment.registrymodel.ModelRegistryRecord;
import org.apache.commons.io.file.PathUtils;
import org.awaitility.Awaitility;

public class RegistryModelExample {
    static final String SOME_MODEL_DESCRIPTION = "LogModelExample model";
    static final String SOME_MODEL_VERSION = "1.0.0";
    static final String SOME_MODEL_VERSION_UP = "1.0.1";
    static final String STAGE_PRODUCTION = "production";

    public static void main(String[] args) throws Exception {
        try (OnlineExperiment experiment = (OnlineExperiment)ExperimentBuilder.OnlineExperiment().interceptStdout().withExperimentName("RegistryModel Examples").build();){
            RegistryModelExample.run(experiment);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void run(OnlineExperiment experiment) throws Exception {
        ExperimentContext context = new ExperimentContext(0L, 0L, "example");
        Map<String, Object> metadata = BaseExample.createMetaData();
        Path assetDir = BaseExample.copyResourcesToTmpDir();
        experiment.logModelFolder("someModelNameExample", assetDir.toFile(), true, metadata, context);
        System.out.printf("Logging data folder '%s' of the model '%s''\n\n", assetDir, "someModelNameExample");
        Awaitility.await((String)"failed to wait for model's assets to be uploaded").atMost(60L, TimeUnit.SECONDS).pollInterval(1L, TimeUnit.SECONDS).until(() -> {
            List loggedAsset = experiment.getAssetList(AssetType.MODEL_ELEMENT.type());
            if (loggedAsset.size() > 0) {
                System.out.printf("Successfully uploaded %d logged assets of the model '%s':\n", loggedAsset.size(), "someModelNameExample");
                return true;
            }
            return false;
        });
        Path modelTmpDir = Files.createTempDirectory("RegistryModelExample", new FileAttribute[0]);
        try (CometApi api = (CometApi)ExperimentBuilder.CometApi().build();){
            String registryName = String.format("%s-%d", "someModelNameExample", System.currentTimeMillis());
            registryName = ModelUtils.createRegistryModelName((String)registryName);
            System.out.printf("\nRegistering model '%s' in the Comet model registry under workspace '%s'.\n", registryName, experiment.getWorkspaceName());
            Model model = Model.newModel((String)"someModelNameExample").withRegistryName(registryName).withDescription(SOME_MODEL_DESCRIPTION).withStages(Collections.singletonList("example")).withVersion(SOME_MODEL_VERSION).build();
            ModelRegistryRecord record = api.registerModel(model, experiment.getExperimentKey());
            System.out.printf("The experiment's model was successfully registered under record: %s\n\n", record);
            System.out.printf("Updating model '%s' in the Comet model registry with new version '%s'.\n", registryName, SOME_MODEL_VERSION_UP);
            Model updatedModel = Model.newModel((String)"someModelNameExample").withRegistryName(registryName).withDescription(SOME_MODEL_DESCRIPTION).withStages(Collections.singletonList(STAGE_PRODUCTION)).withVersion(SOME_MODEL_VERSION_UP).build();
            record = api.registerModel(updatedModel, experiment.getExperimentKey());
            System.out.printf("The experiment's model was successfully updated with record: %s\n\n", record);
            System.out.println("Downloading and expanding model's file assets.");
            ModelDownloadInfo info = api.downloadRegistryModel(modelTmpDir, registryName, experiment.getWorkspaceName());
            System.out.printf("Successfully downloaded model's file assets to folder '%s'.\n\n", info.getDownloadPath());
            System.out.println("Downloading model's file assets as ZIP file.");
            DownloadModelOptions opts = DownloadModelOptions.Op().withExpand(false).withStage(STAGE_PRODUCTION).build();
            info = api.downloadRegistryModel(modelTmpDir, registryName, experiment.getWorkspaceName(), opts);
            System.out.printf("Successfully downloaded model's file assets as ZIP file '%s'.\n\n", info.getDownloadPath());
        }
        finally {
            PathUtils.deleteDirectory((Path)modelTmpDir);
        }
        System.out.println("===== Experiment completed ====");
    }
}

