/*
 * Decompiled with CFR 0.152.
 */
package ml.comet.experiment;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import ml.comet.experiment.Connection;
import ml.comet.experiment.OnlineExperiment;
import ml.comet.response.AssetInfo;
import ml.comet.response.AssetListResponse;
import ml.comet.response.CodeResponse;
import ml.comet.response.ExperimentResponse;
import ml.comet.response.ExperimentRest;
import ml.comet.response.GitMetadata;
import ml.comet.response.GraphResponse;
import ml.comet.response.HtmlResponse;
import ml.comet.response.LogOtherResponse;
import ml.comet.response.MetricsResponse;
import ml.comet.response.OutputResponse;
import ml.comet.response.ParametersResponse;
import ml.comet.response.ProjectResponse;
import ml.comet.response.ProjectRest;
import ml.comet.response.TagsResponse;
import ml.comet.response.WorkspaceResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CometApi {
    public static final ObjectMapper objectMapper = new ObjectMapper();
    private final Connection connection;
    private Logger logger = LoggerFactory.getLogger(OnlineExperiment.class);

    public CometApi(Config config, String restApiKey) {
        this.connection = new Connection(config.getString("comet.url"), Optional.empty(), Optional.of(restApiKey), this.logger);
    }

    public List<String> getAllWorkspaces() {
        Optional<String> body = this.connection.sendGet("/workspaces", Collections.emptyMap());
        if (!body.isPresent()) {
            return Collections.emptyList();
        }
        try {
            WorkspaceResponse workspaceResponse = (WorkspaceResponse)objectMapper.readValue(body.get(), WorkspaceResponse.class);
            return workspaceResponse.getWorkspaces();
        }
        catch (IOException ex) {
            this.logger.error("failed to parse workspace endpoint response", (Throwable)ex);
            throw new RuntimeException("failed to parse workspace endpoint response", ex);
        }
    }

    public List<ProjectRest> getAllProjects(String workspace) {
        Optional<String> body = this.connection.sendGet("/projects", Collections.singletonMap("workspace", workspace));
        if (!body.isPresent()) {
            return Collections.emptyList();
        }
        try {
            ProjectResponse projectResponse = (ProjectResponse)objectMapper.readValue(body.get(), ProjectResponse.class);
            return projectResponse.getProjects();
        }
        catch (IOException ex) {
            this.logger.error("failed to parse project endpoint response", (Throwable)ex);
            throw new RuntimeException("failed to parse project endpoint response", ex);
        }
    }

    public List<ExperimentRest> getAllExperiments(String projectId) {
        Optional<ExperimentResponse> response = this.getObjectForProject(projectId, "/experiments", ExperimentResponse.class);
        if (!response.isPresent()) {
            return Collections.emptyList();
        }
        return response.get().getExperiments();
    }

    public Optional<GitMetadata> getGitMetadata(String experimentKey) {
        return this.getObjectForExperiment(experimentKey, "/experiment/git-metadata", GitMetadata.class);
    }

    public Optional<String> getHtml(String experimentKey) {
        Optional<HtmlResponse> response = this.getObjectForExperiment(experimentKey, "/experiment/html", HtmlResponse.class);
        return response.map(HtmlResponse::getHtml);
    }

    public Optional<String> getCode(String experimentKey) {
        Optional<CodeResponse> response = this.getObjectForExperiment(experimentKey, "/experiment/code", CodeResponse.class);
        return response.map(CodeResponse::getCode);
    }

    public Optional<String> getOutput(String experimentKey) {
        Optional<OutputResponse> response = this.getObjectForExperiment(experimentKey, "/experiment/stdout", OutputResponse.class);
        return response.map(OutputResponse::getOutput);
    }

    public Optional<String> getGraph(String experimentKey) {
        Optional<GraphResponse> response = this.getObjectForExperiment(experimentKey, "/experiment/graph", GraphResponse.class);
        return response.map(GraphResponse::getGraph);
    }

    public Optional<ParametersResponse> getParameters(String experimentKey) {
        return this.getObjectForExperiment(experimentKey, "/experiment/params", ParametersResponse.class);
    }

    public Optional<MetricsResponse> getMetrics(String experimentKey) {
        return this.getObjectForExperiment(experimentKey, "/experiment/metrics", MetricsResponse.class);
    }

    public Optional<LogOtherResponse> getLogOther(String experimentKey) {
        return this.getObjectForExperiment(experimentKey, "/experiment/log-other", LogOtherResponse.class);
    }

    public Optional<TagsResponse> getTags(String experimentKey) {
        return this.getObjectForExperiment(experimentKey, "/experiment/tags", TagsResponse.class);
    }

    public Optional<AssetListResponse> getAssetList(final String experimentKey, final String type) {
        Optional<List<AssetInfo>> assets = this.getObject("/asset/get-asset-list", (Map<String, String>)new HashMap<String, String>(){
            {
                this.put("experimentKey", experimentKey);
                this.put("type", type);
            }
        }, new TypeReference<List<AssetInfo>>(){});
        return assets.map(x -> new AssetListResponse((List<AssetInfo>)x));
    }

    public <T> Optional<T> getObjectForExperiment(String experimentKey, String endpoint, Class<T> clazz) {
        return this.getObject(endpoint, Collections.singletonMap("experimentKey", experimentKey), clazz);
    }

    public <T> Optional<T> getObjectForProject(String experimentKey, String endpoint, Class<T> clazz) {
        return this.getObject(endpoint, Collections.singletonMap("projectId", experimentKey), clazz);
    }

    public <T> Optional<T> getObject(String endpoint, Map<String, String> parameters, Class<T> clazz) {
        Optional<String> body = this.connection.sendGet(endpoint, parameters);
        if (!body.isPresent()) {
            return Optional.empty();
        }
        try {
            Object decodedResponse = objectMapper.readValue(body.get(), clazz);
            return Optional.ofNullable(decodedResponse);
        }
        catch (IOException ex) {
            this.logger.error("failed to parse endpoint response", (Throwable)ex);
            throw new RuntimeException("failed to parse endpoint response", ex);
        }
    }

    public <T> Optional<T> getObject(String endpoint, Map<String, String> parameters, TypeReference<T> typeReference) {
        Optional<String> body = this.connection.sendGet(endpoint, parameters);
        if (!body.isPresent()) {
            return Optional.empty();
        }
        try {
            Object decodedResponse = objectMapper.readValue(body.get(), typeReference);
            return Optional.ofNullable(decodedResponse);
        }
        catch (IOException ex) {
            this.logger.error("failed to parse endpoint response", (Throwable)ex);
            throw new RuntimeException("failed to parse endpoint response", ex);
        }
    }

    public static CometApiBuilder builder(String restApiKey) {
        return new CometApiBuilder(restApiKey);
    }

    public static class CometApiBuilder {
        private Config config;
        private String restApiKey;

        public CometApiBuilder(String restApiKey) {
            this.restApiKey = restApiKey;
            this.config = ConfigFactory.parseFile((File)new File(this.getClass().getClassLoader().getResource("defaults.conf").getFile()));
        }

        public CometApiBuilder withConfig(File overrideConfig) {
            this.config = ConfigFactory.parseFile((File)overrideConfig).withFallback((ConfigMergeable)this.config).resolve();
            return this;
        }

        public CometApi build() {
            return new CometApi(this.config, this.restApiKey);
        }
    }
}

