/*
 * Decompiled with CFR 0.152.
 */
package ml.comet.experiment;

import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.ListenableFuture;
import com.ning.http.client.Response;
import com.ning.http.client.multipart.FilePart;
import com.ning.http.client.multipart.Part;
import java.io.File;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.http.client.utils.URIBuilder;
import org.slf4j.Logger;

public class Connection {
    private Logger logger;
    static AsyncHttpClient asyncHttpClient = new AsyncHttpClient();
    static ExecutorService executorService = Executors.newSingleThreadExecutor();
    Optional<String> apiKey;
    Optional<String> restApiKey;
    String cometBaseUrl;
    int maxAuthRetries;

    protected Connection(String cometBaseUrl, Optional<String> apiKey, Optional<String> restApiKey, Logger logger, int maxAuthRetries) {
        this.cometBaseUrl = cometBaseUrl;
        this.apiKey = apiKey;
        this.restApiKey = restApiKey;
        this.logger = logger;
        this.maxAuthRetries = maxAuthRetries;
    }

    protected Connection(String cometBaseUrl, Optional<String> apiKey, Optional<String> restApiKey, Logger logger) {
        this.cometBaseUrl = cometBaseUrl;
        this.apiKey = apiKey;
        this.restApiKey = restApiKey;
        this.logger = logger;
        this.maxAuthRetries = 1;
    }

    public Optional<String> sendPost(String body, String endpoint) {
        try {
            String url = this.cometBaseUrl + "/write" + endpoint;
            this.logger.debug(String.format("sending {} to {}", body, url));
            Response response = null;
            for (int i = 1; i < this.maxAuthRetries; ++i) {
                response = (Response)asyncHttpClient.preparePost(url).setBody(body).addHeader("Content-Type", "application/json").addHeader("Comet-Sdk-Api", this.apiKey.get()).execute().get();
                if (response.getStatusCode() != 200) {
                    if (i < this.maxAuthRetries) {
                        this.logger.debug(String.format("for body %s and endpoint %s response %s, retrying\n", body, endpoint, response.getResponseBody()));
                        Thread.sleep((2 ^ i) * 1000);
                        continue;
                    }
                    this.logger.error(String.format("for body %s and endpoint %s response %s, last retry failed\n", body, endpoint, response.getResponseBody()));
                    continue;
                }
                this.logger.debug(String.format("for body %s and endpoint %s response %s\n", body, endpoint, response.getResponseBody()));
                break;
            }
            if (response == null) {
                return Optional.empty();
            }
            return Optional.ofNullable(response.getResponseBody());
        }
        catch (Exception e) {
            this.logger.error("Failed to post to " + endpoint);
            e.printStackTrace();
            return Optional.empty();
        }
    }

    public void sendPostAsync(String body, String endpoint) {
        try {
            String url = this.cometBaseUrl + "/write" + endpoint;
            ListenableFuture future = asyncHttpClient.preparePost(url).setBody(body).addHeader("Content-Type", "application/json").addHeader("Comet-Sdk-Api", this.apiKey.get()).execute();
            if (!endpoint.equals("/output")) {
                future.addListener((Runnable)new ResponseListener(body, endpoint, (ListenableFuture<Response>)future), (Executor)executorService);
            }
        }
        catch (Exception e) {
            this.logger.error("Failed to post to " + endpoint);
            e.printStackTrace();
        }
    }

    public Optional<String> sendPost(File file, String endpoint, Map<String, String> params) {
        try {
            String url = Connection.getUrl(this.cometBaseUrl + "/write" + endpoint, params);
            Response response = (Response)asyncHttpClient.preparePost(url).addBodyPart((Part)new FilePart("file", file)).addHeader("Content-Type", "multipart/form-data").addHeader("Comet-Sdk-Api", this.apiKey.get()).execute().get();
            if (response.getStatusCode() != 200) {
                this.logger.error(String.format("endpoint %s response %s", endpoint, response.getResponseBody()));
            } else {
                this.logger.debug(String.format("endpoint %s response %s", endpoint, response.getResponseBody()));
            }
            return Optional.ofNullable(response.getResponseBody());
        }
        catch (Exception e) {
            this.logger.error("Failed to post to " + endpoint);
            e.printStackTrace();
            return Optional.empty();
        }
    }

    public Optional<String> sendGet(String endpoint, Map<String, String> params) {
        try {
            String url = Connection.getUrl(this.cometBaseUrl + endpoint, params);
            AsyncHttpClient.BoundRequestBuilder builder = asyncHttpClient.prepareGet(url).addHeader("Content-Type", "application/json");
            if (this.apiKey.isPresent()) {
                builder.addHeader("Comet-Sdk-Api", this.apiKey.get());
            } else {
                builder.addHeader("Authorization", this.restApiKey.get());
            }
            Response response = (Response)builder.execute().get();
            if (response.getStatusCode() != 200) {
                this.logger.error(String.format("endpoint %s response %s", endpoint, response.getResponseBody()));
            } else {
                this.logger.debug(String.format("endpoint %s response %s", endpoint, response.getResponseBody()));
            }
            return Optional.ofNullable(response.getResponseBody());
        }
        catch (Exception ex) {
            this.logger.error("Failed to get from " + endpoint);
            ex.printStackTrace();
            return Optional.empty();
        }
    }

    private static String getUrl(String url, Map<String, String> params) {
        try {
            URIBuilder builder = new URIBuilder(url);
            params.forEach((k, v) -> builder.addParameter(k, v));
            return builder.build().toString();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("failed to create URL ", e);
        }
    }

    class ResponseListener
    implements Runnable {
        private String body;
        private String endpoint;
        private ListenableFuture<Response> future;

        public ResponseListener(String body, String endpoint, ListenableFuture<Response> future) {
            this.body = body;
            this.endpoint = endpoint;
            this.future = future;
        }

        @Override
        public void run() {
            try {
                Response response = (Response)this.future.get();
                if (response.getStatusCode() != 200) {
                    Connection.this.logger.error(String.format("for body %s and endpoint %s response %s\n", this.body, this.endpoint, response.getResponseBody()));
                } else {
                    Connection.this.logger.debug(String.format("for body %s and endpoint %s response %s\n", this.body, this.endpoint, response.getResponseBody()));
                }
            }
            catch (Exception ex) {
                Connection.this.logger.error("failed to get response for " + this.endpoint);
                ex.printStackTrace();
            }
        }
    }
}

