/*
 * Decompiled with CFR 0.152.
 */
package ml.comet.experiment;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import ml.comet.experiment.Connection;
import ml.comet.experiment.Experiment;
import ml.comet.experiment.ExperimentBuilder;
import ml.comet.experiment.StdOutLogger;
import ml.comet.response.GitMetadata;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnlineExperiment
implements Experiment {
    public static final String OUTPUT = "/output";
    private static ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
    private Connection connection;
    private Config config;
    private Optional<String> experimentKey = Optional.empty();
    private Optional<String> experimentLink = Optional.empty();
    private String projectName;
    private String workspace;
    private Optional<String> experimentName = Optional.empty();
    private Optional<StdOutLogger> stdOutLogger = Optional.empty();
    private Optional<StdOutLogger> stdErrLogger = Optional.empty();
    private boolean interceptStdout = false;
    private Logger logger = LoggerFactory.getLogger(OnlineExperiment.class);
    private Optional<String> apiKey;
    private Optional<ScheduledFuture> pingStatusFuture = Optional.empty();
    private long step = 0L;
    private String context = "";
    private final int maxAuthRetries = 4;

    private OnlineExperiment(String apiKey, String projectName, String workspace, Optional<String> experimentName, Optional<String> experimentKey, Optional<Logger> logger, Config config, boolean interceptStdout) {
        this.config = config;
        this.projectName = projectName;
        this.workspace = workspace;
        this.apiKey = Optional.of(apiKey);
        this.experimentName = experimentName;
        this.experimentKey = experimentKey;
        this.interceptStdout = interceptStdout;
        if (logger.isPresent()) {
            this.logger = logger.get();
        }
        this.initializeExperiment();
    }

    public OnlineExperiment() {
        this.config = ConfigFactory.parseFile((File)new File(this.getClass().getClassLoader().getResource("defaults.conf").getFile()));
        String apiKey = this.config.getString("comet.apiKey");
        String project = this.config.getString("comet.project");
        String workspace = this.config.getString("comet.workspace");
        this.projectName = project;
        this.workspace = workspace;
        this.apiKey = Optional.of(apiKey);
        this.initializeExperiment();
    }

    public static OnlineExperiment of(String apiKey, String projectName, String workspace) {
        Config config = ConfigFactory.parseFile((File)new File(OnlineExperiment.class.getClassLoader().getResource("defaults.conf").getFile()));
        OnlineExperiment onlineExperiment = new OnlineExperiment(apiKey, projectName, workspace, Optional.empty(), Optional.empty(), Optional.empty(), config, true);
        return onlineExperiment;
    }

    public static OnlineExperimentBuilder builder(String apiKey, String projectName, String workspace) {
        return new OnlineExperimentBuilder(apiKey, projectName, workspace);
    }

    private void initializeExperiment() {
        this.setupConnection();
        this.setupStdOutIntercept();
        this.registerExperiment();
    }

    private void setupConnection() {
        if (!this.apiKey.isPresent()) {
            throw new RuntimeException("Api Key required");
        }
        this.connection = new Connection(this.config.getString("comet.url"), this.apiKey, Optional.empty(), this.logger, this.maxAuthRetries);
    }

    private void setupStdOutIntercept() {
        if (this.interceptStdout) {
            try {
                this.captureStdout();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void registerExperiment() {
        if (this.experimentKey.isPresent()) {
            this.logger.debug("Not registering a new experiment.  Using experiment key {}", (Object)this.experimentKey.get());
            return;
        }
        JSONObject obj = new JSONObject();
        obj.put("project_name", (Object)this.projectName);
        obj.put("workspace", (Object)this.workspace);
        this.experimentName.ifPresent(experiment -> obj.put("experiment_name", experiment));
        Optional<String> responseOptional = this.connection.sendPost(obj.toString(), "/new-experiment");
        responseOptional.ifPresent(response -> {
            JSONObject result = new JSONObject(response);
            if (result.has("experimentKey")) {
                this.experimentKey = Optional.ofNullable(result.getString("experimentKey"));
                this.experimentLink = Optional.ofNullable(result.getString("link"));
                this.logger.info("Experiment is live on comet.ml " + this.experimentLink.orElse(""));
                this.pingStatusFuture = Optional.of(scheduledExecutorService.scheduleAtFixedRate(new StatusPing(this), 1L, 3L, TimeUnit.SECONDS));
            }
        });
        if (!this.experimentKey.isPresent()) {
            throw new RuntimeException("Failed to register onlineExperiment with Comet ML");
        }
    }

    @Override
    public void exit() {
        if (this.pingStatusFuture.isPresent()) {
            this.pingStatusFuture.get().cancel(true);
            this.pingStatusFuture = Optional.empty();
        }
    }

    @Override
    public void setInterceptStdout() throws IOException {
        if (!this.interceptStdout) {
            this.interceptStdout = true;
            this.captureStdout();
        }
    }

    @Override
    public void stopInterceptStdout() {
        if (this.stdOutLogger.isPresent()) {
            this.stdOutLogger.get().stop();
            this.stdOutLogger = Optional.empty();
            this.interceptStdout = false;
        }
        if (this.stdErrLogger.isPresent()) {
            this.stdErrLogger.get().stop();
            this.stdErrLogger = Optional.empty();
        }
    }

    @Override
    public void setStep(long step) {
        this.step = step;
    }

    @Override
    public void nextStep() {
        ++this.step;
    }

    @Override
    public long getStep() {
        return this.step;
    }

    @Override
    public void setContext(String context) {
        this.context = context;
    }

    @Override
    public String getContext() {
        return this.context;
    }

    @Override
    public String getExperimentKey() {
        return this.experimentKey.get();
    }

    @Override
    public Optional<String> getExperimentLink() {
        return this.experimentLink;
    }

    @Override
    public void setExperimentName(String experimentName) {
        this.logOther("Name", experimentName);
    }

    @Override
    public void logMetric(String metricName, Object metricValue) {
        this.logMetric(metricName, metricValue, this.step);
    }

    @Override
    public void logMetric(String metricName, Object metricValue, long step) {
        this.setStep(step);
        this.logger.debug("logMetric {} {}", (Object)metricName, metricValue);
        this.experimentKey.ifPresent(key -> {
            JSONObject obj = new JSONObject();
            obj.put("experimentKey", key);
            obj.put("metricName", (Object)metricName);
            obj.put("metricValue", (Object)this.getObjectValue(metricValue));
            obj.put("step", step);
            obj.put("timestamp", System.currentTimeMillis());
            this.connection.sendPostAsync(obj.toString(), "/metric");
        });
    }

    @Override
    public void logParameter(String parameterName, Object paramValue) {
        this.logParameter(parameterName, paramValue, this.step);
    }

    @Override
    public void logParameter(String parameterName, Object paramValue, long step) {
        this.setStep(step);
        this.logger.debug("logParameter {} {}", (Object)parameterName, paramValue);
        this.experimentKey.ifPresent(key -> {
            JSONObject obj = new JSONObject();
            obj.put("experimentKey", key);
            obj.put("paramName", (Object)parameterName);
            obj.put("paramValue", (Object)this.getObjectValue(paramValue));
            obj.put("step", step);
            this.connection.sendPostAsync(obj.toString(), "/parameter");
        });
    }

    @Override
    public void logHtml(String html, boolean override) {
        this.logger.debug("logHtml {} {}", (Object)html, (Object)override);
        this.experimentKey.ifPresent(key -> {
            JSONObject obj = new JSONObject();
            obj.put("experimentKey", key);
            obj.put("html", (Object)html);
            obj.put("override", override);
            this.connection.sendPostAsync(obj.toString(), "/html");
        });
    }

    @Override
    public void logCode(String code) {
        this.logger.debug("logCode {}", (Object)code);
        this.experimentKey.ifPresent(key -> {
            JSONObject obj = new JSONObject();
            obj.put("experimentKey", key);
            obj.put("code", (Object)code);
            this.connection.sendPostAsync(obj.toString(), "/code");
        });
    }

    @Override
    public void logOther(String key, Object value) {
        this.logger.debug("logOther {} {}", (Object)key, value);
        this.experimentKey.ifPresent(expKey -> {
            JSONObject obj = new JSONObject();
            obj.put("experimentKey", expKey);
            obj.put("key", (Object)key);
            obj.put("val", (Object)this.getObjectValue(value));
            this.connection.sendPostAsync(obj.toString(), "/log-other");
        });
    }

    @Override
    public void addTag(String tag) {
        this.logger.debug("logTag {}", (Object)tag);
        this.experimentKey.ifPresent(expKey -> {
            JSONObject obj = new JSONObject();
            obj.put("experimentKey", expKey);
            obj.put("addedTags", Collections.singletonList(tag));
            this.connection.sendPostAsync(obj.toString(), "/add-tags-to-experiment");
        });
    }

    @Override
    public void logGraph(String graph) {
        this.logger.debug("logOther {}", (Object)graph);
        this.experimentKey.ifPresent(expKey -> {
            JSONObject obj = new JSONObject();
            obj.put("experimentKey", expKey);
            obj.put("graph", (Object)graph);
            obj.put("offset", this.step);
            this.connection.sendPostAsync(obj.toString(), "/graph");
        });
    }

    @Override
    public void logStartTime(long startTimeMillis) {
        this.logger.debug("logStartTime {}", (Object)startTimeMillis);
        this.experimentKey.ifPresent(key -> {
            JSONObject obj = new JSONObject();
            obj.put("experimentKey", key);
            obj.put("start_time_millis", startTimeMillis);
            this.connection.sendPostAsync(obj.toString(), "/experiment-start-end-time");
        });
    }

    @Override
    public void logEndTime(long endTimeMillis) {
        this.logger.debug("logEndTime {}", (Object)endTimeMillis);
        this.experimentKey.ifPresent(key -> {
            JSONObject obj = new JSONObject();
            obj.put("experimentKey", key);
            obj.put("end_time_millis", endTimeMillis);
            this.connection.sendPostAsync(obj.toString(), "/experiment-start-end-time");
        });
    }

    @Override
    public void uploadAsset(File asset, final String fileName, final boolean overwrite) {
        this.logger.debug(String.format("uploadAsset {} {} {}", asset.getName(), fileName, overwrite));
        this.experimentKey.ifPresent(key -> this.connection.sendPost(asset, "/upload-asset", (Map<String, String>)new HashMap<String, String>(){
            {
                this.put("experimentKey", key);
                this.put("fileName", fileName);
                this.put("step", Long.toString(OnlineExperiment.this.step));
                this.put("context", OnlineExperiment.this.context);
                this.put("overwrite", Boolean.toString(overwrite));
            }
        }));
    }

    @Override
    public void uploadAsset(File asset, boolean overwrite) {
        this.uploadAsset(asset, asset.getName(), overwrite);
    }

    @Override
    public void uploadImage(File image, final String imageName, final boolean overwrite) {
        this.logger.debug(String.format("uploadImage {} {} {}", image.getName(), imageName, overwrite));
        this.experimentKey.ifPresent(key -> this.connection.sendPost(image, "/upload-image", (Map<String, String>)new HashMap<String, String>(){
            {
                this.put("experimentKey", key);
                this.put("figureName", imageName);
                this.put("step", Long.toString(OnlineExperiment.this.step));
                this.put("context", OnlineExperiment.this.context);
                this.put("overwrite", Boolean.toString(overwrite));
            }
        }));
    }

    @Override
    public void logGitMetadata(GitMetadata gitMetadata) {
        this.logger.debug(String.format("gitMetadata {}", gitMetadata));
        this.experimentKey.ifPresent(key -> {
            JSONObject outer = new JSONObject();
            outer.put("experimentKey", key);
            JSONObject inner = new JSONObject();
            inner.put("runContext", (Object)this.context);
            JSONObject metadata = new JSONObject();
            metadata.put("user", (Object)gitMetadata.getUser());
            metadata.put("origin", (Object)gitMetadata.getOrigin());
            metadata.put("branch", (Object)gitMetadata.getBranch());
            metadata.put("root", (Object)gitMetadata.getRoot());
            metadata.put("parent", (Object)gitMetadata.getParent());
            inner.put("sdkGitMetadata", (Object)metadata);
            outer.put("sdkGitMetadataWithContext", (Object)inner);
            this.connection.sendPostAsync(outer.toString(), "/git_metadata");
        });
    }

    @Override
    public void uploadImage(File image, boolean overwrite) {
        this.uploadImage(image, image.getName(), overwrite);
    }

    private void captureStdout() throws IOException {
        StdOutLogger logger = StdOutLogger.createStdoutLogger(this);
        this.stdOutLogger = Optional.of(logger);
        StdOutLogger errorLogger = StdOutLogger.createStderrLogger(this);
        this.stdErrLogger = Optional.of(errorLogger);
    }

    protected void logLine(String line, int offset, boolean stderr) {
        this.experimentKey.ifPresent(key -> {
            JSONObject stdoutLine = new JSONObject();
            stdoutLine.put("stdout", (Object)line);
            stdoutLine.put("stderr", stderr);
            stdoutLine.put("local_timestamp", System.currentTimeMillis());
            stdoutLine.put("offset", offset);
            JSONArray stdoutArray = new JSONArray();
            stdoutArray.put(0, (Object)stdoutLine);
            JSONObject obj = new JSONObject();
            obj.put("experimentKey", key);
            obj.put("stdoutLines", (Object)stdoutArray);
            obj.put("runContext", (Object)this.context);
            this.connection.sendPostAsync(obj.toString(), OUTPUT);
        });
    }

    protected void pingStatus() {
        this.experimentKey.ifPresent(key -> {
            this.logger.debug("pingStatus");
            JSONObject obj = new JSONObject();
            obj.put("experimentKey", key);
            this.connection.sendPostAsync(obj.toString(), "/experiment-status");
        });
    }

    private String getObjectValue(Object val) {
        return val.toString();
    }

    static class StatusPing
    implements Runnable {
        OnlineExperiment onlineExperiment;

        StatusPing(OnlineExperiment onlineExperiment) {
            this.onlineExperiment = onlineExperiment;
        }

        @Override
        public void run() {
            this.onlineExperiment.pingStatus();
        }
    }

    public static class OnlineExperimentBuilder
    implements ExperimentBuilder {
        private String projectName;
        private String workspace;
        private String apiKey;
        private Optional<String> experimentName = Optional.empty();
        private Optional<String> experimentKey = Optional.empty();
        private Optional<Logger> logger = Optional.empty();
        private Config config = ConfigFactory.parseFile((File)new File(this.getClass().getClassLoader().getResource("defaults.conf").getFile()));
        private boolean interceptStdout = false;

        private OnlineExperimentBuilder(String apiKey, String projectName, String workspace) {
            this.projectName = projectName;
            this.workspace = workspace;
            this.apiKey = apiKey;
        }

        @Override
        public OnlineExperimentBuilder withProjectName(String projectName) {
            this.projectName = projectName;
            return this;
        }

        @Override
        public OnlineExperimentBuilder withWorkspace(String workspace) {
            this.workspace = workspace;
            return this;
        }

        @Override
        public OnlineExperimentBuilder withApiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        @Override
        public OnlineExperimentBuilder withExperimentName(String experimentName) {
            this.experimentName = Optional.of(experimentName);
            return this;
        }

        @Override
        public OnlineExperimentBuilder withExistingExperimentKey(String experimentKey) {
            this.experimentKey = Optional.of(experimentKey);
            return this;
        }

        @Override
        public OnlineExperimentBuilder withLogger(Logger logger) {
            this.logger = Optional.ofNullable(logger);
            return this;
        }

        @Override
        public OnlineExperimentBuilder withConfig(File overrideConfig) {
            this.config = ConfigFactory.parseFile((File)overrideConfig).withFallback((ConfigMergeable)this.config).resolve();
            return this;
        }

        @Override
        public OnlineExperimentBuilder interceptStdout() {
            this.interceptStdout = true;
            return this;
        }

        @Override
        public OnlineExperiment build() {
            return new OnlineExperiment(this.apiKey, this.projectName, this.workspace, this.experimentName, this.experimentKey, this.logger, this.config, this.interceptStdout);
        }
    }
}

