/*
 * Decompiled with CFR 0.152.
 */
package ml.comet.experiment;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.util.concurrent.atomic.AtomicInteger;
import ml.comet.experiment.CopyOutputStream;
import ml.comet.experiment.OnlineExperiment;

public class StdOutLogger
implements Runnable {
    static AtomicInteger offset = new AtomicInteger();
    PrintStream original;
    OnlineExperiment onlineExperiment;
    BufferedReader reader;
    boolean stdOut;

    private StdOutLogger(PrintStream original, OnlineExperiment onlineExperiment, BufferedReader reader, boolean stdOut) {
        this.original = original;
        this.onlineExperiment = onlineExperiment;
        this.reader = reader;
        this.stdOut = stdOut;
    }

    @Override
    public void run() {
        try {
            while (true) {
                String line = this.reader.readLine();
                this.onlineExperiment.logLine(line, offset.incrementAndGet(), !this.stdOut);
            }
        }
        catch (IOException ex) {
            return;
        }
    }

    public void stop() {
        if (this.stdOut) {
            System.setOut(this.original);
        } else {
            System.setErr(this.original);
        }
    }

    public static StdOutLogger createStdoutLogger(OnlineExperiment onlineExperiment) throws IOException {
        return StdOutLogger.createLogger(onlineExperiment, System.out, true);
    }

    public static StdOutLogger createStderrLogger(OnlineExperiment onlineExperiment) throws IOException {
        return StdOutLogger.createLogger(onlineExperiment, System.err, false);
    }

    private static StdOutLogger createLogger(OnlineExperiment onlineExperiment, PrintStream original, boolean stdOut) throws IOException {
        PipedInputStream in = new PipedInputStream();
        PipedOutputStream out = new PipedOutputStream(in);
        CopyOutputStream copyStream = new CopyOutputStream(original, out);
        PrintStream replacement = new PrintStream(copyStream);
        if (stdOut) {
            System.setOut(replacement);
        } else {
            System.setErr(replacement);
        }
        BufferedReader stdoutReader = new BufferedReader(new InputStreamReader(new BufferedInputStream(in)));
        StdOutLogger logger = new StdOutLogger(original, onlineExperiment, stdoutReader, stdOut);
        Thread loggerThread = new Thread(logger);
        loggerThread.start();
        return logger;
    }
}

