/*
 * Decompiled with CFR 0.152.
 */
package ml.comet.experiment;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigMergeable;
import java.io.File;
import java.util.Optional;
import ml.comet.experiment.BaseExperiment;
import ml.comet.experiment.builder.ApiExperimentBuilder;
import ml.comet.experiment.http.Connection;
import ml.comet.experiment.http.ConnectionInitializer;
import ml.comet.experiment.utils.ConfigUtils;
import okhttp3.HttpUrl;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiExperiment
extends BaseExperiment {
    private final Config config;
    private final String apiKey;
    private final String experimentKey;
    private final Connection connection;
    private Logger logger = LoggerFactory.getLogger(ApiExperiment.class);

    private ApiExperiment(String apiKey, String experimentKey, Logger logger, Config config) {
        this.config = config;
        this.apiKey = apiKey;
        this.experimentKey = experimentKey;
        if (logger != null) {
            this.logger = logger;
        }
        this.connection = ConnectionInitializer.initConnection(this.config, this.apiKey, this.logger);
    }

    public ApiExperiment(String experimentKey) {
        this.experimentKey = experimentKey;
        this.config = ConfigUtils.getDefaultConfigFromClassPath();
        this.apiKey = this.config.getString("comet.apiKey");
        this.connection = ConnectionInitializer.initConnection(this.config, this.apiKey, this.logger);
    }

    public static ApiExperimentBuilderImpl builder(String experimentKey) {
        return new ApiExperimentBuilderImpl(experimentKey);
    }

    @Override
    protected Connection getConnection() {
        return this.connection;
    }

    @Override
    protected Logger getLogger() {
        return this.logger;
    }

    @Override
    public String getContext() {
        return "";
    }

    @Override
    public String getWorkspaceName() {
        return this.getMetadata().getWorkspaceName();
    }

    @Override
    public String getProjectName() {
        return this.getMetadata().getProjectName();
    }

    @Override
    public String getExperimentName() {
        return this.getMetadata().getExperimentName();
    }

    @Override
    public String getExperimentKey() {
        return this.experimentKey;
    }

    @Override
    public Optional<String> getExperimentLink() {
        if (StringUtils.isEmpty((CharSequence)this.experimentKey)) {
            return Optional.empty();
        }
        String baseUrl = this.config.getString("comet.url");
        HttpUrl.Builder builder = HttpUrl.get((String)baseUrl).newBuilder();
        builder.addPathSegment(this.getWorkspaceName());
        builder.addPathSegment(this.getProjectName());
        builder.addPathSegment(this.experimentKey);
        String link = builder.build().toString();
        return Optional.of(link);
    }

    public static class ApiExperimentBuilderImpl
    implements ApiExperimentBuilder {
        private final String experimentKey;
        private String apiKey;
        private Logger logger;
        private Config config = ConfigUtils.getDefaultConfigFromClassPath();

        private ApiExperimentBuilderImpl(String experimentKey) {
            this.apiKey = this.config.getString("comet.apiKey");
            this.experimentKey = experimentKey;
        }

        @Override
        public ApiExperimentBuilderImpl withApiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        @Override
        public ApiExperimentBuilderImpl withLogger(Logger logger) {
            this.logger = logger;
            return this;
        }

        @Override
        public ApiExperimentBuilderImpl withConfig(File overrideConfig) {
            this.config = ConfigUtils.getConfigFromFile(overrideConfig).withFallback((ConfigMergeable)this.config).resolve();
            return this;
        }

        @Override
        public ApiExperiment build() {
            return new ApiExperiment(this.apiKey, this.experimentKey, this.logger, this.config);
        }
    }
}

