/*
 * Decompiled with CFR 0.152.
 */
package ml.comet.experiment;

import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import ml.comet.experiment.Experiment;
import ml.comet.experiment.http.Connection;
import ml.comet.experiment.model.AddGraphRest;
import ml.comet.experiment.model.AddTagsToExperimentRest;
import ml.comet.experiment.model.CreateGitMetadata;
import ml.comet.experiment.model.ExperimentAssetLink;
import ml.comet.experiment.model.ExperimentAssetListResponse;
import ml.comet.experiment.model.ExperimentMetadataRest;
import ml.comet.experiment.model.ExperimentTimeRequest;
import ml.comet.experiment.model.GetGraphResponse;
import ml.comet.experiment.model.GetHtmlResponse;
import ml.comet.experiment.model.GetOutputResponse;
import ml.comet.experiment.model.GitMetadataRest;
import ml.comet.experiment.model.HtmlRest;
import ml.comet.experiment.model.LogOtherRest;
import ml.comet.experiment.model.MetricRest;
import ml.comet.experiment.model.MinMaxResponse;
import ml.comet.experiment.model.ParameterRest;
import ml.comet.experiment.model.TagsResponse;
import ml.comet.experiment.model.ValueMinMaxDto;
import ml.comet.experiment.utils.JsonUtils;
import org.slf4j.Logger;

public abstract class BaseExperiment
implements Experiment {
    protected abstract String getContext();

    protected abstract Connection getConnection();

    protected abstract Logger getLogger();

    @Override
    public void setExperimentName(String experimentName) {
        this.logOther("Name", experimentName);
    }

    @Override
    public void logMetric(String metricName, Object metricValue, long step) {
        this.getLogger().debug("logMetric {} {}", (Object)metricName, metricValue);
        this.validateExperimentKeyPresent();
        MetricRest request = this.getLogMetricRequest(metricName, metricValue, step);
        this.getConnection().sendPostAsync(request, "/api/rest/v2/write/experiment/metric");
    }

    @Override
    public void logParameter(String parameterName, Object paramValue, long step) {
        this.getLogger().debug("logParameter {} {}", (Object)parameterName, paramValue);
        this.validateExperimentKeyPresent();
        ParameterRest request = this.getLogParameterRequest(parameterName, paramValue, step);
        this.getConnection().sendPostAsync(request, "/api/rest/v2/write/experiment/parameter");
    }

    @Override
    public void logHtml(String html, boolean override) {
        this.getLogger().debug("logHtml {} {}", (Object)html, (Object)override);
        this.validateExperimentKeyPresent();
        HtmlRest request = this.getLogHtmlRequest(html, override);
        this.getConnection().sendPostAsync(request, "/api/rest/v2/write/experiment/html");
    }

    @Override
    public void logCode(String code, final String fileName) {
        this.getLogger().debug("log raw code");
        this.validateExperimentKeyPresent();
        this.getConnection().sendPostAsync(code.getBytes(StandardCharsets.UTF_8), "/api/rest/v2/write/experiment/upload-asset", (Map<String, String>)new HashMap<String, String>(){
            {
                this.put("experimentKey", BaseExperiment.this.getExperimentKey());
                this.put("fileName", fileName);
                this.put("context", BaseExperiment.this.getContext());
                this.put("type", "source_code");
                this.put("overwrite", Boolean.toString(false));
            }
        });
    }

    @Override
    public void logCode(final File asset) {
        this.getLogger().debug("logCode {}", (Object)asset.getName());
        this.validateExperimentKeyPresent();
        this.getConnection().sendPostAsync(asset, "/api/rest/v2/write/experiment/upload-asset", (Map<String, String>)new HashMap<String, String>(){
            {
                this.put("experimentKey", BaseExperiment.this.getExperimentKey());
                this.put("fileName", asset.getName());
                this.put("context", BaseExperiment.this.getContext());
                this.put("type", "source_code");
                this.put("overwrite", Boolean.toString(false));
            }
        });
    }

    @Override
    public void logOther(String key, Object value) {
        this.getLogger().debug("logOther {} {}", (Object)key, value);
        this.validateExperimentKeyPresent();
        LogOtherRest request = this.getLogOtherRequest(key, value);
        this.getConnection().sendPostAsync(request, "/api/rest/v2/write/experiment/log-other");
    }

    @Override
    public void addTag(String tag) {
        this.getLogger().debug("logTag {}", (Object)tag);
        this.validateExperimentKeyPresent();
        AddTagsToExperimentRest request = this.getTagRequest(tag);
        this.getConnection().sendPostAsync(request, "/api/rest/v2/write/experiment/tags");
    }

    @Override
    public void logGraph(String graph) {
        this.getLogger().debug("logOther {}", (Object)graph);
        this.validateExperimentKeyPresent();
        AddGraphRest request = this.getGraphRequest(graph);
        this.getConnection().sendPostAsync(request, "/api/rest/v2/write/experiment/graph");
    }

    @Override
    public void logStartTime(long startTimeMillis) {
        this.getLogger().debug("logStartTime {}", (Object)startTimeMillis);
        this.validateExperimentKeyPresent();
        ExperimentTimeRequest request = this.getLogStartTimeRequest(startTimeMillis);
        this.getConnection().sendPostAsync(request, "/api/rest/v2/write/experiment/set-start-end-time");
    }

    @Override
    public void logEndTime(long endTimeMillis) {
        this.getLogger().debug("logEndTime {}", (Object)endTimeMillis);
        this.validateExperimentKeyPresent();
        ExperimentTimeRequest request = this.getLogEndTimeRequest(endTimeMillis);
        this.getConnection().sendPostAsync(request, "/api/rest/v2/write/experiment/set-start-end-time");
    }

    @Override
    public void uploadAsset(File asset, final String fileName, final boolean overwrite, final long step) {
        this.getLogger().debug("uploadAsset {} {} {}", new Object[]{asset.getName(), fileName, overwrite});
        this.validateExperimentKeyPresent();
        this.getConnection().sendPostAsync(asset, "/api/rest/v2/write/experiment/upload-asset", (Map<String, String>)new HashMap<String, String>(){
            {
                this.put("experimentKey", BaseExperiment.this.getExperimentKey());
                this.put("fileName", fileName);
                this.put("step", Long.toString(step));
                this.put("context", BaseExperiment.this.getContext());
                this.put("overwrite", Boolean.toString(overwrite));
            }
        });
    }

    @Override
    public void uploadAsset(File asset, boolean overwrite, long step) {
        this.uploadAsset(asset, asset.getName(), overwrite, step);
    }

    @Override
    public void logGitMetadata(CreateGitMetadata gitMetadata) {
        this.getLogger().debug("gitMetadata {}", (Object)gitMetadata);
        this.validateExperimentKeyPresent();
        this.getConnection().sendPostAsync(gitMetadata, "/api/rest/v2/write/experiment/git/metadata");
    }

    @Override
    public ExperimentMetadataRest getMetadata() {
        String experimentKey = this.validateAndGetExperimentKey();
        this.getLogger().debug("get metadata for experiment {}", (Object)experimentKey);
        return this.getForExperimentByKey("/api/rest/v2/experiment/metadata", ExperimentMetadataRest.class);
    }

    @Override
    public GitMetadataRest getGitMetadata() {
        String experimentKey = this.validateAndGetExperimentKey();
        this.getLogger().debug("get git metadata for experiment {}", (Object)experimentKey);
        return this.getForExperimentByKey("/api/rest/v2/experiment/git/metadata", GitMetadataRest.class);
    }

    @Override
    public Optional<String> getHtml() {
        String experimentKey = this.validateAndGetExperimentKey();
        this.getLogger().debug("get html for experiment {}", (Object)experimentKey);
        GetHtmlResponse response = this.getForExperimentByKey("/api/rest/v2/experiment/html", GetHtmlResponse.class);
        return Optional.ofNullable(response.getHtml());
    }

    @Override
    public Optional<String> getOutput() {
        String experimentKey = this.validateAndGetExperimentKey();
        this.getLogger().debug("get output for experiment {}", (Object)experimentKey);
        GetOutputResponse response = this.getForExperimentByKey("/api/rest/v2/experiment/output", GetOutputResponse.class);
        return Optional.ofNullable(response.getOutput());
    }

    @Override
    public Optional<String> getGraph() {
        String experimentKey = this.validateAndGetExperimentKey();
        this.getLogger().debug("get graph for experiment {}", (Object)experimentKey);
        GetGraphResponse response = this.getForExperimentByKey("/api/rest/v2/experiment/graph", GetGraphResponse.class);
        return Optional.ofNullable(response.getGraph());
    }

    @Override
    public List<ValueMinMaxDto> getParameters() {
        String experimentKey = this.validateAndGetExperimentKey();
        this.getLogger().debug("get params for experiment {}", (Object)experimentKey);
        MinMaxResponse response = this.getForExperimentByKey("/api/rest/v2/experiment/parameters", MinMaxResponse.class);
        return response.getValues();
    }

    @Override
    public List<ValueMinMaxDto> getMetrics() {
        String experimentKey = this.validateAndGetExperimentKey();
        this.getLogger().debug("get metrics summary for experiment {}", (Object)experimentKey);
        MinMaxResponse response = this.getForExperimentByKey("/api/rest/v2/experiment/metrics/summary", MinMaxResponse.class);
        return response.getValues();
    }

    @Override
    public List<ValueMinMaxDto> getLogOther() {
        String experimentKey = this.validateAndGetExperimentKey();
        this.getLogger().debug("get log other for experiment {}", (Object)experimentKey);
        MinMaxResponse response = this.getForExperimentByKey("/api/rest/v2/experiment/log-other", MinMaxResponse.class);
        return response.getValues();
    }

    @Override
    public List<String> getTags() {
        String experimentKey = this.validateAndGetExperimentKey();
        this.getLogger().debug("get tags for experiment {}", (Object)experimentKey);
        TagsResponse response = this.getForExperimentByKey("/api/rest/v2/experiment/tags", TagsResponse.class);
        return response.getTags();
    }

    @Override
    public List<ExperimentAssetLink> getAssetList(final String type) {
        final String experimentKey = this.validateAndGetExperimentKey();
        this.getLogger().debug("get tags for experiment {}", (Object)experimentKey);
        HashMap<String, String> params = new HashMap<String, String>(){
            {
                this.put("experimentKey", experimentKey);
                this.put("type", type);
            }
        };
        ExperimentAssetListResponse response = this.getForExperiment("/api/rest/v2/experiment/asset/list", (Map<String, String>)params, ExperimentAssetListResponse.class);
        return response.getAssets();
    }

    private <T> T getForExperimentByKey(String endpoint, Class<T> clazz) {
        return this.getForExperiment(endpoint, Collections.singletonMap("experimentKey", this.getExperimentKey()), clazz);
    }

    private <T> T getForExperiment(String endpoint, Map<String, String> params, Class<T> clazz) {
        return (T)this.getConnection().sendGet(endpoint, params).map(body -> JsonUtils.fromJson(body, clazz)).orElseThrow(() -> new IllegalArgumentException("Empty response received for experiment from " + endpoint));
    }

    private String getObjectValue(Object val) {
        return val.toString();
    }

    private void validateExperimentKeyPresent() {
        if (this.getExperimentKey() == null) {
            throw new IllegalStateException("Experiment key must be present!");
        }
    }

    private String validateAndGetExperimentKey() {
        this.validateExperimentKeyPresent();
        return this.getExperimentKey();
    }

    private MetricRest getLogMetricRequest(String metricName, Object metricValue, long step) {
        MetricRest request = new MetricRest();
        request.setExperimentKey(this.getExperimentKey());
        request.setMetricName(metricName);
        request.setMetricValue(this.getObjectValue(metricValue));
        request.setStep(step);
        request.setTimestamp(System.currentTimeMillis());
        return request;
    }

    private ParameterRest getLogParameterRequest(String parameterName, Object paramValue, long step) {
        ParameterRest request = new ParameterRest();
        request.setExperimentKey(this.getExperimentKey());
        request.setParameterName(parameterName);
        request.setParameterValue(this.getObjectValue(paramValue));
        request.setStep(step);
        request.setTimestamp(System.currentTimeMillis());
        return request;
    }

    private HtmlRest getLogHtmlRequest(String html, boolean override) {
        HtmlRest request = new HtmlRest();
        request.setExperimentKey(this.getExperimentKey());
        request.setHtml(html);
        request.setOverride(override);
        request.setTimestamp(System.currentTimeMillis());
        return request;
    }

    private LogOtherRest getLogOtherRequest(String key, Object value) {
        LogOtherRest request = new LogOtherRest();
        request.setExperimentKey(this.getExperimentKey());
        request.setKey(key);
        request.setValue(this.getObjectValue(value));
        request.setTimestamp(System.currentTimeMillis());
        return request;
    }

    private AddTagsToExperimentRest getTagRequest(String tag) {
        AddTagsToExperimentRest request = new AddTagsToExperimentRest();
        request.setExperimentKey(this.getExperimentKey());
        request.setAddedTags(Collections.singletonList(tag));
        return request;
    }

    private AddGraphRest getGraphRequest(String graph) {
        AddGraphRest request = new AddGraphRest();
        request.setExperimentKey(this.getExperimentKey());
        request.setGraph(graph);
        return request;
    }

    private ExperimentTimeRequest getLogStartTimeRequest(long startTimeMillis) {
        ExperimentTimeRequest request = new ExperimentTimeRequest();
        request.setExperimentKey(this.getExperimentKey());
        request.setStartTimeMillis(startTimeMillis);
        return request;
    }

    private ExperimentTimeRequest getLogEndTimeRequest(long endTimeMillis) {
        ExperimentTimeRequest request = new ExperimentTimeRequest();
        request.setExperimentKey(this.getExperimentKey());
        request.setEndTimeMillis(endTimeMillis);
        return request;
    }
}

