/*
 * Decompiled with CFR 0.152.
 */
package ml.comet.experiment.env;

import org.apache.commons.lang3.StringUtils;

public final class EnvironmentVariableExtractor {
    private static final String API_KEY = "COMET_API_KEY";
    private static final String PROJECT_NAME = "COMET_PROJECT_NAME";
    private static final String WORKSPACE_NAME = "COMET_WORKSPACE_NAME";

    public static String getApiKeyOrThrow() {
        return EnvironmentVariableExtractor.getEnvVariableOrThrow(API_KEY);
    }

    public static String getProjectNameOrThrow() {
        return EnvironmentVariableExtractor.getEnvVariableOrThrow(PROJECT_NAME);
    }

    public static String getWorkspaceNameOrThrow() {
        return EnvironmentVariableExtractor.getEnvVariableOrThrow(WORKSPACE_NAME);
    }

    private static String getEnvVariableOrThrow(String variableName) {
        String res = System.getenv(variableName);
        if (StringUtils.isEmpty((CharSequence)res)) {
            throw new IllegalStateException("No environment variable with name " + variableName);
        }
        return res;
    }

    private EnvironmentVariableExtractor() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

