/*
 * Decompiled with CFR 0.152.
 */
package ml.comet.experiment.http;

import java.beans.ConstructorProperties;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import ml.comet.experiment.utils.JsonUtils;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.lang3.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public final class Connection {
    private static final OkHttpClient CLIENT = new OkHttpClient();
    private static final String COMET_SDK_API = "Comet-Sdk-Api";
    private static final MediaType MEDIA_TYPE_JSON = MediaType.get((String)"application/json");
    private static final MediaType MEDIATYPE_FORM_DATA = MediaType.get((String)"multipart/form-data");
    private static final String FILE = "file";
    private final String cometBaseUrl;
    private final String apiKey;
    private final Logger logger;
    private final int maxAuthRetries;

    public Optional<String> sendGet(String endpoint, Map<String, String> params) {
        String url = Connection.getUrl(this.cometBaseUrl + endpoint, params);
        Request.Builder builder = new Request.Builder().url(url);
        return this.executeRequestWithAuth(builder, url);
    }

    public Optional<String> sendPost(String body, String endpoint) {
        String url = this.cometBaseUrl + endpoint;
        this.logger.debug("sending {} to {}", (Object)body, (Object)url);
        Request.Builder builder = this.createPostJsonRequest(body, url);
        return this.executeRequestWithAuth(builder, url);
    }

    public Optional<String> sendPost(File file, String endpoint, Map<String, String> params) {
        String url = Connection.getUrl(this.cometBaseUrl + endpoint, params);
        this.logger.debug("sending POST file {} to {}", (Object)file.getName(), (Object)url);
        Request.Builder builder = this.createPostFileRequest(file, url);
        return this.executeRequestWithAuth(builder, url);
    }

    public Optional<String> sendPost(byte[] bytes, String endpoint, Map<String, String> params) {
        String url = Connection.getUrl(this.cometBaseUrl + endpoint, params);
        this.logger.debug("sending POST bytearray with length {} to {}", (Object)bytes.length, (Object)url);
        Request.Builder builder = this.createPostByteArrayRequest(bytes, url);
        return this.executeRequestWithAuth(builder, url);
    }

    public void sendPostAsync(Object payload, String endpoint) {
        this.sendPostAsync(JsonUtils.toJson(payload), endpoint);
    }

    public void sendPostAsync(String body, String endpoint) {
        String url = this.cometBaseUrl + endpoint;
        Request.Builder builder = this.createPostJsonRequest(body, url);
        this.executeRequestWithAuthAsync(builder);
    }

    public void sendPostAsync(File file, String endpoint, Map<String, String> params) {
        String url = Connection.getUrl(this.cometBaseUrl + endpoint, params);
        Request.Builder builder = this.createPostFileRequest(file, url);
        this.executeRequestWithAuthAsync(builder);
    }

    public void sendPostAsync(byte[] bytes, String endpoint, Map<String, String> params) {
        String url = Connection.getUrl(this.cometBaseUrl + endpoint, params);
        this.logger.debug("sending POST bytearray with length {} to {}", (Object)bytes.length, (Object)url);
        Request.Builder builder = this.createPostByteArrayRequest(bytes, url);
        this.executeRequestWithAuthAsync(builder);
    }

    private void executeRequestWithAuthAsync(Request.Builder requestBuilder) {
        requestBuilder.addHeader(COMET_SDK_API, this.apiKey);
        Request request = requestBuilder.build();
        CLIENT.newCall(request).enqueue(this.getAsyncCallback());
    }

    private Optional<String> executeRequestWithAuth(Request.Builder requestBuilder, String endpoint) {
        requestBuilder.addHeader(COMET_SDK_API, this.apiKey);
        Request request = requestBuilder.build();
        try {
            Response response = null;
            for (int i = 1; i < this.maxAuthRetries; ++i) {
                response = CLIENT.newCall(request).execute();
                if (!response.isSuccessful()) {
                    if (i < this.maxAuthRetries - 1) {
                        this.logger.debug("for endpoint {} response {}, retrying\n", (Object)endpoint, (Object)response.body());
                        Thread.sleep((long)(2 ^ i) * 1000L);
                        continue;
                    }
                    this.logger.error("for endpoint {} response {}, last retry failed\n", (Object)endpoint, (Object)response.body());
                    continue;
                }
                this.logger.debug("for endpoint {} response {}\n", (Object)endpoint, (Object)response.body());
                break;
            }
            if (ObjectUtils.anyNull((Object[])new Object[]{response, response.body()})) {
                return Optional.empty();
            }
            return Optional.of(response.body().string());
        }
        catch (Exception e) {
            this.logger.error("Failed to post to " + endpoint);
            e.printStackTrace();
            return Optional.empty();
        }
    }

    private Request.Builder createPostJsonRequest(String body, String url) {
        return new Request.Builder().url(url).post(RequestBody.create((String)body, (MediaType)MEDIA_TYPE_JSON));
    }

    private Request.Builder createPostFileRequest(File file, String url) {
        MultipartBody.Builder builder = new MultipartBody.Builder().setType(MultipartBody.FORM);
        builder.addFormDataPart(FILE, file.getName(), RequestBody.create((File)file, (MediaType)MultipartBody.FORM));
        return new Request.Builder().url(url).post((RequestBody)builder.build());
    }

    private Request.Builder createPostByteArrayRequest(byte[] bytes, String url) {
        MultipartBody.Builder builder = new MultipartBody.Builder().setType(MultipartBody.FORM);
        builder.addFormDataPart(FILE, FILE, RequestBody.create((byte[])bytes, (MediaType)MultipartBody.FORM));
        return new Request.Builder().url(url).post((RequestBody)builder.build());
    }

    private static String getUrl(String url, Map<String, String> params) {
        HttpUrl.Builder builder = HttpUrl.get((String)url).newBuilder();
        params.forEach((arg_0, arg_1) -> ((HttpUrl.Builder)builder).addQueryParameter(arg_0, arg_1));
        return builder.build().toString();
    }

    private Callback getAsyncCallback() {
        return new Callback(){

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                Connection.this.logger.error("failed to get response for " + call.request().url());
                e.printStackTrace();
            }

            public void onResponse(@NotNull Call call, @NotNull Response response) {
                if (response.isSuccessful()) {
                    Connection.this.logger.debug("for endpoint {} response {}\n", (Object)call.request().url(), (Object)response.body());
                } else {
                    Connection.this.logger.error("for endpoint {} response {}\n", (Object)call.request().url(), (Object)response.body());
                }
            }
        };
    }

    @ConstructorProperties(value={"cometBaseUrl", "apiKey", "logger", "maxAuthRetries"})
    public Connection(String cometBaseUrl, String apiKey, Logger logger, int maxAuthRetries) {
        this.cometBaseUrl = cometBaseUrl;
        this.apiKey = apiKey;
        this.logger = logger;
        this.maxAuthRetries = maxAuthRetries;
    }

    public String getCometBaseUrl() {
        return this.cometBaseUrl;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public int getMaxAuthRetries() {
        return this.maxAuthRetries;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Connection)) {
            return false;
        }
        Connection other = (Connection)o;
        String this$cometBaseUrl = this.getCometBaseUrl();
        String other$cometBaseUrl = other.getCometBaseUrl();
        if (this$cometBaseUrl == null ? other$cometBaseUrl != null : !this$cometBaseUrl.equals(other$cometBaseUrl)) {
            return false;
        }
        String this$apiKey = this.getApiKey();
        String other$apiKey = other.getApiKey();
        if (this$apiKey == null ? other$apiKey != null : !this$apiKey.equals(other$apiKey)) {
            return false;
        }
        Logger this$logger = this.getLogger();
        Logger other$logger = other.getLogger();
        if (this$logger == null ? other$logger != null : !this$logger.equals(other$logger)) {
            return false;
        }
        return this.getMaxAuthRetries() == other.getMaxAuthRetries();
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $cometBaseUrl = this.getCometBaseUrl();
        result = result * 59 + ($cometBaseUrl == null ? 43 : $cometBaseUrl.hashCode());
        String $apiKey = this.getApiKey();
        result = result * 59 + ($apiKey == null ? 43 : $apiKey.hashCode());
        Logger $logger = this.getLogger();
        result = result * 59 + ($logger == null ? 43 : $logger.hashCode());
        result = result * 59 + this.getMaxAuthRetries();
        return result;
    }

    public String toString() {
        return "Connection(cometBaseUrl=" + this.getCometBaseUrl() + ", apiKey=" + this.getApiKey() + ", logger=" + this.getLogger() + ", maxAuthRetries=" + this.getMaxAuthRetries() + ")";
    }
}

