/*
 * Decompiled with CFR 0.152.
 */
package ml.comet.experiment.http;

import com.typesafe.config.Config;
import ml.comet.experiment.http.Connection;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

public final class ConnectionInitializer {
    public static Connection initConnection(Config config, String apiKey, Logger logger) {
        String cometBaseUrl = config.getString("comet.url");
        int maxAuthRetries = config.getInt("comet.maxAuthRetries");
        if (StringUtils.isEmpty((CharSequence)apiKey)) {
            throw new IllegalArgumentException("Api key required!");
        }
        return new Connection(cometBaseUrl, apiKey, logger, maxAuthRetries);
    }

    private ConnectionInitializer() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

