/*
 * Decompiled with CFR 0.152.
 */
package ml.comet.experiment;

import com.typesafe.config.Config;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import ml.comet.experiment.CometApi;
import ml.comet.experiment.http.Connection;
import ml.comet.experiment.http.ConnectionInitializer;
import ml.comet.experiment.model.ExperimentMetadataRest;
import ml.comet.experiment.model.GetExperimentsResponse;
import ml.comet.experiment.model.GetProjectsResponse;
import ml.comet.experiment.model.GetWorkspacesResponse;
import ml.comet.experiment.model.RestProject;
import ml.comet.experiment.utils.ConfigUtils;
import ml.comet.experiment.utils.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CometApiImpl
implements CometApi {
    private final Connection connection;

    public CometApiImpl(String apiKey, String baseUrl, int maxAuthRetries) {
        Logger logger = LoggerFactory.getLogger(CometApiImpl.class);
        this.connection = ConnectionInitializer.initConnection(apiKey, baseUrl, maxAuthRetries, logger);
    }

    @Override
    public List<String> getAllWorkspaces() {
        GetWorkspacesResponse response = this.getObject("/api/rest/v2/workspaces", Collections.emptyMap(), GetWorkspacesResponse.class);
        return response.getWorkspaceNames();
    }

    @Override
    public List<RestProject> getAllProjects(String workspaceName) {
        Map<String, String> params = Collections.singletonMap("workspaceName", workspaceName);
        GetProjectsResponse response = this.getObject("/api/rest/v2/projects", params, GetProjectsResponse.class);
        return response.getProjects();
    }

    @Override
    public List<ExperimentMetadataRest> getAllExperiments(String projectId) {
        Map<String, String> params = Collections.singletonMap("projectId", projectId);
        GetExperimentsResponse response = this.getObject("/api/rest/v2/experiments", params, GetExperimentsResponse.class);
        return response.getExperiments();
    }

    private <T> T getObject(String endpoint, Map<String, String> params, Class<T> clazz) {
        return (T)this.connection.sendGet(endpoint, params).map(body -> JsonUtils.fromJson(body, clazz)).orElseThrow(() -> new IllegalArgumentException("Failed to parse endpoint response " + endpoint));
    }

    public static CometApiBuilder builder() {
        return new CometApiBuilder();
    }

    public static class CometApiBuilder {
        private String apiKey = ConfigUtils.getApiKey().orElse(null);
        private String baseUrl = ConfigUtils.getBaseUrlOrDefault();
        private int maxAuthRetries = ConfigUtils.getMaxAuthRetriesOrDefault();

        public CometApiBuilder withConfig(File overrideConfig) {
            Config config = ConfigUtils.getConfigFromFile(overrideConfig);
            this.apiKey = config.getString("comet.apiKey");
            this.baseUrl = config.getString("comet.url");
            this.maxAuthRetries = config.getInt("comet.maxAuthRetries");
            return this;
        }

        public CometApiBuilder withApiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public CometApiImpl build() {
            return new CometApiImpl(this.apiKey, this.baseUrl, this.maxAuthRetries);
        }
    }
}

