/*
 * Decompiled with CFR 0.152.
 */
package ml.comet.experiment.utils;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.io.File;
import java.net.URL;
import java.util.Optional;
import ml.comet.experiment.env.EnvironmentVariableExtractor;
import org.apache.commons.lang3.StringUtils;

public final class ConfigUtils {
    public static String getApiKeyOrThrow() {
        return ConfigUtils.getValueFromSystemOrThrow("COMET_API_KEY", "comet.apiKey");
    }

    public static Optional<String> getApiKey() {
        return ConfigUtils.getValueFromSystem("COMET_API_KEY", "comet.apiKey");
    }

    public static String getProjectNameOrThrow() {
        return ConfigUtils.getValueFromSystemOrThrow("COMET_PROJECT_NAME", "comet.project");
    }

    public static Optional<String> getProjectName() {
        return ConfigUtils.getValueFromSystem("COMET_PROJECT_NAME", "comet.project");
    }

    public static String getWorkspaceNameOrThrow() {
        return ConfigUtils.getValueFromSystemOrThrow("COMET_WORKSPACE_NAME", "comet.workspace");
    }

    public static Optional<String> getWorkspaceName() {
        return ConfigUtils.getValueFromSystem("COMET_WORKSPACE_NAME", "comet.workspace");
    }

    public static String getBaseUrlOrDefault() {
        return ConfigUtils.getValueFromSystem("COMET_BASE_URL", "comet.url").orElse("https://www.comet.ml");
    }

    public static int getMaxAuthRetriesOrDefault() {
        return ConfigUtils.getValueFromSystem("COMET_MAX_AUTH_RETRIES", "comet.maxAuthRetries").map(Integer::parseInt).orElse(4);
    }

    public static Config getConfigFromFile(File configFile) {
        return ConfigFactory.parseFile((File)configFile);
    }

    private static Config getDefaultConfigFromClassPath() {
        URL resource = ConfigUtils.getContextClassLoader().getResource("defaults.conf");
        if (resource == null) {
            return null;
        }
        return ConfigFactory.parseFile((File)new File(resource.getFile()));
    }

    private static String getValueFromSystemOrThrow(String envVarName, String configValueName) {
        return ConfigUtils.getValueFromSystem(envVarName, configValueName).orElseThrow(() -> new IllegalStateException("No parameter with name " + configValueName + "found! Please specify it in env vars or config"));
    }

    private static Optional<String> getValueFromSystem(String envVarName, String configValueName) {
        Optional<String> envVariable = EnvironmentVariableExtractor.getEnvVariable(envVarName);
        if (envVariable.isPresent()) {
            return envVariable;
        }
        Config defaultConfig = ConfigUtils.getDefaultConfigFromClassPath();
        if (defaultConfig == null) {
            return Optional.empty();
        }
        String configValue = defaultConfig.getString(configValueName);
        if (StringUtils.isEmpty((CharSequence)configValue)) {
            return Optional.empty();
        }
        return Optional.of(configValue);
    }

    private static ClassLoader getContextClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    private ConfigUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

