/*
 * Decompiled with CFR 0.152.
 */
package ml.comet.experiment.impl;

import com.vdurmont.semver4j.Semver;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import ml.comet.experiment.impl.utils.RestApiUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

abstract class BaseArtifactImpl {
    private final String name;
    private final String type;
    Set<String> aliases;
    Semver semanticVersion;
    Set<String> versionTags;
    String metadataJson;
    private Map<String, Object> metadata;

    BaseArtifactImpl(String name, String type) {
        this.name = name;
        this.type = type;
    }

    public Map<String, Object> getMetadata() {
        if (this.metadata != null) {
            return this.metadata;
        }
        if (StringUtils.isNotBlank((CharSequence)this.metadataJson)) {
            try {
                this.metadata = RestApiUtils.metadataFromJson(this.metadataJson);
                return this.metadata;
            }
            catch (Throwable e) {
                this.getLogger().error("Failed to parse artifact metadata from JSON {}", (Object)this.metadataJson, (Object)e);
            }
        }
        return new HashMap<String, Object>();
    }

    public Set<String> getAliases() {
        if (this.aliases == null) {
            return new HashSet<String>();
        }
        return this.aliases;
    }

    public Set<String> getVersionTags() {
        if (this.versionTags == null) {
            return new HashSet<String>();
        }
        return this.versionTags;
    }

    abstract Logger getLogger();

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public void setAliases(Set<String> aliases) {
        this.aliases = aliases;
    }

    public Semver getSemanticVersion() {
        return this.semanticVersion;
    }

    public void setSemanticVersion(Semver semanticVersion) {
        this.semanticVersion = semanticVersion;
    }

    public void setVersionTags(Set<String> versionTags) {
        this.versionTags = versionTags;
    }

    public void setMetadataJson(String metadataJson) {
        this.metadataJson = metadataJson;
    }

    public void setMetadata(Map<String, Object> metadata) {
        this.metadata = metadata;
    }
}

