/*
 * Decompiled with CFR 0.152.
 */
package ml.comet.experiment.impl.utils;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public final class ResourceUtils {
    private static final String SDK_OPTIONS_RESOURCE_FILE = "comet-java-sdk-options.properties";
    private static final String COMET_SDK_VERSION_KEY = "comet.java.sdk.version";

    public static Properties readProperties(String properties) throws IOException {
        Properties p = new Properties();
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(properties);
        if (is == null) {
            throw new FileNotFoundException(properties);
        }
        p.load(is);
        return p;
    }

    static String readCometSdkVersion() {
        try {
            Properties p = ResourceUtils.readProperties(SDK_OPTIONS_RESOURCE_FILE);
            if (p.containsKey(COMET_SDK_VERSION_KEY)) {
                return p.getProperty(COMET_SDK_VERSION_KEY);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return "";
    }

    private ResourceUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

