/*
 * Decompiled with CFR 0.152.
 */
package ml.comet.experiment.impl;

import com.vdurmont.semver4j.Semver;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.NonNull;
import ml.comet.experiment.artifact.Artifact;
import ml.comet.experiment.artifact.ArtifactAsset;
import ml.comet.experiment.artifact.ArtifactBuilder;
import ml.comet.experiment.artifact.ConflictingArtifactAssetNameException;
import ml.comet.experiment.impl.BaseArtifactImpl;
import ml.comet.experiment.impl.asset.ArtifactAssetImpl;
import ml.comet.experiment.impl.asset.AssetImpl;
import ml.comet.experiment.impl.asset.RemoteAssetImpl;
import ml.comet.experiment.impl.resources.LogMessages;
import ml.comet.experiment.impl.utils.AssetUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArtifactImpl
extends BaseArtifactImpl
implements Artifact {
    private final Logger logger = LoggerFactory.getLogger(Artifact.class);
    final HashMap<String, ArtifactAsset> assetsMap = new HashMap();
    private final boolean prefixWithFolderName;

    ArtifactImpl(String name, String type) {
        super(name, type);
        this.prefixWithFolderName = true;
    }

    @Override
    public Collection<ArtifactAsset> getAssets() {
        return this.assetsMap.values();
    }

    @Override
    public void addAsset(@NonNull File file, @NonNull String logicalPath, boolean overwrite, Map<String, Object> metadata) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        if (logicalPath == null) {
            throw new NullPointerException("logicalPath is marked non-null but is null");
        }
        this.addAsset(file, logicalPath, overwrite, Optional.of(metadata));
    }

    @Override
    public void addAsset(@NonNull File file, boolean overwrite, @NonNull Map<String, Object> metadata) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        if (metadata == null) {
            throw new NullPointerException("metadata is marked non-null but is null");
        }
        this.addAsset(file, file.getName(), overwrite, Optional.of(metadata));
    }

    @Override
    public void addAsset(File file, String logicalPath, boolean overwrite) throws ConflictingArtifactAssetNameException {
        this.addAsset(file, logicalPath, overwrite, Optional.empty());
    }

    @Override
    public void addAsset(@NonNull File file, boolean overwrite) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        this.addAsset(file, file.getName(), false, Optional.empty());
    }

    private void addAsset(@NonNull File file, @NonNull String name, boolean overwrite, @NonNull Optional<Map<String, Object>> metadata) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (metadata == null) {
            throw new NullPointerException("metadata is marked non-null but is null");
        }
        AssetImpl asset = AssetUtils.createAssetFromFile(file, Optional.of(name), overwrite, metadata, Optional.empty());
        this.appendAsset(new ArtifactAssetImpl(asset));
    }

    @Override
    public void addAsset(byte[] data, String logicalPath, boolean overwrite, @NonNull Map<String, Object> metadata) {
        if (metadata == null) {
            throw new NullPointerException("metadata is marked non-null but is null");
        }
        this.addAsset(data, logicalPath, overwrite, Optional.of(metadata));
    }

    @Override
    public void addAsset(byte[] data, String logicalPath, boolean overwrite) {
        this.addAsset(data, logicalPath, overwrite, Optional.empty());
    }

    @Override
    public void addAsset(byte[] data, String logicalPath) throws ConflictingArtifactAssetNameException {
        this.addAsset(data, logicalPath, false);
    }

    private void addAsset(byte[] data, @NonNull String name, boolean overwrite, @NonNull Optional<Map<String, Object>> metadata) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (metadata == null) {
            throw new NullPointerException("metadata is marked non-null but is null");
        }
        AssetImpl asset = AssetUtils.createAssetFromData(data, name, overwrite, metadata, Optional.empty());
        this.appendAsset(new ArtifactAssetImpl(asset));
    }

    @Override
    public void addRemoteAsset(@NonNull URI uri, @NonNull String logicalPath, boolean overwrite, @NonNull Map<String, Object> metadata) {
        if (uri == null) {
            throw new NullPointerException("uri is marked non-null but is null");
        }
        if (logicalPath == null) {
            throw new NullPointerException("logicalPath is marked non-null but is null");
        }
        if (metadata == null) {
            throw new NullPointerException("metadata is marked non-null but is null");
        }
        this.addRemoteAsset(uri, logicalPath, overwrite, Optional.of(metadata));
    }

    @Override
    public void addRemoteAsset(@NonNull URI uri, @NonNull String logicalPath, boolean overwrite) {
        if (uri == null) {
            throw new NullPointerException("uri is marked non-null but is null");
        }
        if (logicalPath == null) {
            throw new NullPointerException("logicalPath is marked non-null but is null");
        }
        this.addRemoteAsset(uri, logicalPath, overwrite, Optional.empty());
    }

    @Override
    public void addRemoteAsset(@NonNull URI uri, @NonNull String logicalPath) {
        if (uri == null) {
            throw new NullPointerException("uri is marked non-null but is null");
        }
        if (logicalPath == null) {
            throw new NullPointerException("logicalPath is marked non-null but is null");
        }
        this.addRemoteAsset(uri, logicalPath, false, Optional.empty());
    }

    private void addRemoteAsset(@NonNull URI uri, @NonNull String name, boolean overwrite, @NonNull Optional<Map<String, Object>> metadata) {
        if (uri == null) {
            throw new NullPointerException("uri is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (metadata == null) {
            throw new NullPointerException("metadata is marked non-null but is null");
        }
        RemoteAssetImpl asset = AssetUtils.createRemoteAsset(uri, Optional.of(name), overwrite, metadata, Optional.empty());
        this.appendAsset(new ArtifactAssetImpl(asset));
    }

    @Override
    public void addAssetFolder(@NonNull File folder, boolean logFilePath, boolean recursive, @NonNull Map<String, Object> metadata) throws ConflictingArtifactAssetNameException, IOException {
        if (folder == null) {
            throw new NullPointerException("folder is marked non-null but is null");
        }
        if (metadata == null) {
            throw new NullPointerException("metadata is marked non-null but is null");
        }
        this.addAssetFolder(folder, logFilePath, recursive, Optional.of(metadata));
    }

    @Override
    public void addAssetFolder(@NonNull File folder, boolean logFilePath, boolean recursive) throws ConflictingArtifactAssetNameException, IOException {
        if (folder == null) {
            throw new NullPointerException("folder is marked non-null but is null");
        }
        this.addAssetFolder(folder, logFilePath, recursive, Optional.empty());
    }

    @Override
    public void addAssetFolder(@NonNull File folder, boolean logFilePath) throws ConflictingArtifactAssetNameException, IOException {
        if (folder == null) {
            throw new NullPointerException("folder is marked non-null but is null");
        }
        this.addAssetFolder(folder, false, false);
    }

    @Override
    public void addAssetFolder(@NonNull File folder) throws ConflictingArtifactAssetNameException, IOException {
        if (folder == null) {
            throw new NullPointerException("folder is marked non-null but is null");
        }
        this.addAssetFolder(folder, false);
    }

    private void addAssetFolder(@NonNull File folder, boolean logFilePath, boolean recursive, Optional<Map<String, Object>> metadata) throws ConflictingArtifactAssetNameException, IOException {
        if (folder == null) {
            throw new NullPointerException("folder is marked non-null but is null");
        }
        AssetUtils.walkFolderAssets(folder, logFilePath, recursive, this.prefixWithFolderName, metadata, Optional.empty(), Optional.empty()).forEach(asset -> this.appendAsset(new ArtifactAssetImpl((AssetImpl)asset)));
    }

    <T extends ArtifactAsset> void appendAsset(@NonNull T asset) throws ConflictingArtifactAssetNameException {
        if (asset == null) {
            throw new NullPointerException("asset is marked non-null but is null");
        }
        String key = asset.getLogicalPath();
        ArtifactAsset a = this.assetsMap.get(key);
        if (a != null) {
            throw new ConflictingArtifactAssetNameException(LogMessages.getString("CONFLICTING_ARTIFACT_ASSET_NAME", asset, key, a));
        }
        this.assetsMap.put(key, asset);
    }

    @Override
    Logger getLogger() {
        return this.logger;
    }

    ArtifactAsset findAsset(@NonNull String logicalPath) {
        if (logicalPath == null) {
            throw new NullPointerException("logicalPath is marked non-null but is null");
        }
        return this.assetsMap.get(logicalPath);
    }

    public static ArtifactBuilder builder(@NonNull String name, @NonNull String type) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        return new ArtifactBuilderImpl(name, type);
    }

    static final class ArtifactBuilderImpl
    implements ArtifactBuilder {
        private final ArtifactImpl artifact;

        ArtifactBuilderImpl(String name, String type) {
            this.artifact = new ArtifactImpl(name, type);
        }

        @Override
        public ArtifactBuilderImpl withAliases(@NonNull List<String> aliases) {
            if (aliases == null) {
                throw new NullPointerException("aliases is marked non-null but is null");
            }
            this.artifact.aliases = new HashSet<String>(aliases);
            return this;
        }

        @Override
        public ArtifactBuilderImpl withMetadata(@NonNull Map<String, Object> metadata) {
            if (metadata == null) {
                throw new NullPointerException("metadata is marked non-null but is null");
            }
            this.artifact.setMetadata((Map)metadata);
            return this;
        }

        @Override
        public ArtifactBuilderImpl withVersion(String version) {
            this.artifact.semanticVersion = new Semver(version);
            return this;
        }

        @Override
        public ArtifactBuilderImpl withVersionTags(@NonNull List<String> tags) {
            if (tags == null) {
                throw new NullPointerException("tags is marked non-null but is null");
            }
            this.artifact.versionTags = new HashSet<String>(tags);
            return this;
        }

        @Override
        public Artifact build() {
            return this.artifact;
        }
    }
}

