/*
 * Decompiled with CFR 0.152.
 */
package ml.comet.experiment.impl.utils;

import java.net.URI;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import lombok.NonNull;
import ml.comet.experiment.context.ExperimentContext;
import ml.comet.experiment.impl.utils.ResourceUtils;
import org.apache.commons.lang3.StringUtils;

public final class CometUtils {
    public static final String COMET_JAVA_SDK_VERSION = ResourceUtils.readCometSdkVersion();

    public static void printCometSdkVersion() {
        System.out.println();
        System.out.println("Comet Java SDK version: " + COMET_JAVA_SDK_VERSION);
        System.out.println();
    }

    public static String createExperimentLink(String baseUrl, String workspaceName, String projectName, String experimentKey) {
        String url = String.format("%s/%s/%s/%s", baseUrl, workspaceName, projectName, experimentKey);
        URI uri = URI.create(url);
        return uri.toString();
    }

    public static String generateGUID() {
        String guid = UUID.randomUUID().toString();
        return StringUtils.remove((String)guid, (char)'-');
    }

    public static <T> void putNotNull(@NonNull Map<T, String> map, @NonNull T key, Object value) {
        if (map == null) {
            throw new NullPointerException("map is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (value != null) {
            map.put(key, value.toString());
        }
    }

    public static String fullMetricName(@NonNull String name, @NonNull ExperimentContext context) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (StringUtils.isEmpty((CharSequence)context.getContext())) {
            return name;
        }
        return String.format("%s_%s", context.getContext(), name);
    }

    public static Instant instantOrNull(Long timestamp) {
        if (timestamp != null) {
            return Instant.ofEpochMilli(timestamp);
        }
        return null;
    }

    public static Duration durationOrNull(Long durationMillis) {
        if (durationMillis != null) {
            return Duration.of(durationMillis, ChronoUnit.MILLIS);
        }
        return null;
    }

    public static <T> Set<T> setFromList(List<T> list) {
        if (list == null) {
            return Collections.emptySet();
        }
        return new HashSet<T>(list);
    }

    private CometUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

