/*
 * Decompiled with CFR 0.152.
 */
package ml.comet.experiment.impl;

import java.io.File;
import java.time.Duration;
import java.util.Optional;
import lombok.NonNull;
import ml.comet.experiment.ApiExperiment;
import ml.comet.experiment.builder.ApiExperimentBuilder;
import ml.comet.experiment.impl.BaseExperiment;
import ml.comet.experiment.impl.config.CometConfig;
import ml.comet.experiment.impl.resources.LogMessages;
import ml.comet.experiment.impl.utils.CometUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ApiExperimentImpl
extends BaseExperiment
implements ApiExperiment {
    private Logger logger = LoggerFactory.getLogger(ApiExperimentImpl.class);

    private ApiExperimentImpl(String apiKey, String experimentKey, Logger logger, String baseUrl, int maxAuthRetries, Duration cleaningTimeout, String projectName, String workspaceName) {
        super(apiKey, baseUrl, maxAuthRetries, experimentKey, cleaningTimeout, projectName, workspaceName);
        if (logger != null) {
            this.logger = logger;
        }
    }

    @Override
    void init() {
        super.init();
        this.registerExperiment();
    }

    @Override
    public String getWorkspaceName() {
        return this.getMetadata().getWorkspaceName();
    }

    @Override
    public String getProjectName() {
        return this.getMetadata().getProjectName();
    }

    @Override
    public String getExperimentName() {
        return this.getMetadata().getExperimentName();
    }

    @Override
    public Optional<String> getExperimentLink() {
        if (StringUtils.isBlank((CharSequence)this.experimentKey)) {
            return Optional.empty();
        }
        try {
            return Optional.of(CometUtils.createExperimentLink(this.baseUrl, this.getWorkspaceName(), this.getProjectName(), this.experimentKey));
        }
        catch (Exception ex) {
            this.logger.error("failed to build experiment link", (Throwable)ex);
            return Optional.empty();
        }
    }

    @Override
    public void end() {
        this.getLogger().info(LogMessages.getString("EXPERIMENT_CLEANUP_PROMPT", this.cleaningTimeout.getSeconds()));
        super.end();
    }

    @Override
    public void close() {
        this.end();
    }

    public static ApiExperimentBuilderImpl builder(@NonNull String experimentKey) {
        if (experimentKey == null) {
            throw new NullPointerException("experimentKey is marked non-null but is null");
        }
        return ApiExperimentImpl.builder().withExistingExperimentKey(experimentKey);
    }

    public static ApiExperimentBuilderImpl builder() {
        return new ApiExperimentBuilderImpl();
    }

    @Override
    public Logger getLogger() {
        return this.logger;
    }

    public static final class ApiExperimentBuilderImpl
    implements ApiExperimentBuilder {
        private String experimentKey;
        private String apiKey;
        private Logger logger;
        private String projectName;
        private String workspace;

        private ApiExperimentBuilderImpl() {
        }

        @Override
        public ApiExperimentBuilderImpl withExistingExperimentKey(@NonNull String experimentKey) {
            if (experimentKey == null) {
                throw new NullPointerException("experimentKey is marked non-null but is null");
            }
            this.experimentKey = experimentKey;
            return this;
        }

        public ApiExperimentBuilderImpl withApiKey(@NonNull String anApiKey) {
            if (anApiKey == null) {
                throw new NullPointerException("anApiKey is marked non-null but is null");
            }
            this.apiKey = anApiKey;
            return this;
        }

        @Override
        public ApiExperimentBuilderImpl withProjectName(@NonNull String projectName) {
            if (projectName == null) {
                throw new NullPointerException("projectName is marked non-null but is null");
            }
            this.projectName = projectName;
            return this;
        }

        @Override
        public ApiExperimentBuilderImpl withWorkspace(@NonNull String workspace) {
            if (workspace == null) {
                throw new NullPointerException("workspace is marked non-null but is null");
            }
            this.workspace = workspace;
            return this;
        }

        public ApiExperimentBuilderImpl withLogger(@NonNull Logger logger) {
            if (logger == null) {
                throw new NullPointerException("logger is marked non-null but is null");
            }
            this.logger = logger;
            return this;
        }

        public ApiExperimentBuilderImpl withConfigOverride(@NonNull File overrideConfig) {
            if (overrideConfig == null) {
                throw new NullPointerException("overrideConfig is marked non-null but is null");
            }
            CometConfig.applyConfigOverride(overrideConfig);
            return this;
        }

        @Override
        public ApiExperiment build() {
            if (StringUtils.isBlank((CharSequence)this.apiKey)) {
                this.apiKey = CometConfig.COMET_API_KEY.getString();
            }
            if (StringUtils.isBlank((CharSequence)this.projectName)) {
                this.projectName = CometConfig.COMET_PROJECT_NAME.getOptionalString().orElse(null);
            }
            if (StringUtils.isBlank((CharSequence)this.workspace)) {
                this.workspace = CometConfig.COMET_WORKSPACE_NAME.getOptionalString().orElse(null);
            }
            ApiExperimentImpl experiment = new ApiExperimentImpl(this.apiKey, this.experimentKey, this.logger, CometConfig.COMET_BASE_URL.getString(), CometConfig.COMET_MAX_AUTH_RETRIES.getInt(), CometConfig.COMET_TIMEOUT_CLEANING_SECONDS.getDuration(), this.projectName, this.workspace);
            try {
                experiment.init();
            }
            catch (Throwable ex) {
                experiment.end();
                throw ex;
            }
            return experiment;
        }
    }
}

