/*
 * Decompiled with CFR 0.152.
 */
package ml.comet.experiment.impl;

import io.reactivex.rxjava3.functions.Action;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.Instant;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.NonNull;
import ml.comet.experiment.OnlineExperiment;
import ml.comet.experiment.artifact.Artifact;
import ml.comet.experiment.artifact.ArtifactException;
import ml.comet.experiment.artifact.LoggedArtifact;
import ml.comet.experiment.context.ExperimentContext;
import ml.comet.experiment.exception.CometApiException;
import ml.comet.experiment.impl.BaseExperimentAsync;
import ml.comet.experiment.impl.OnlineExperimentBuilderImpl;
import ml.comet.experiment.impl.asset.AssetImpl;
import ml.comet.experiment.impl.asset.AssetType;
import ml.comet.experiment.impl.log.StdOutLogger;
import ml.comet.experiment.impl.resources.LogMessages;
import ml.comet.experiment.impl.rest.ExperimentStatusResponse;
import ml.comet.experiment.impl.utils.AssetUtils;
import ml.comet.experiment.model.Curve;
import ml.comet.experiment.model.GitMetaData;
import org.awaitility.Awaitility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OnlineExperimentImpl
extends BaseExperimentAsync
implements OnlineExperiment {
    private static final int SCHEDULED_EXECUTOR_TERMINATION_WAIT_SEC = 60;
    private static final int STD_OUT_LOGGER_FLUSH_WAIT_DELAY_MS = 2000;
    private static final int DEFAULT_HEARTBEAT_INTERVAL_MS = 3000;
    private final ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
    private Logger logger = LoggerFactory.getLogger(OnlineExperimentImpl.class);
    private StdOutLogger stdOutLogger;
    private StdOutLogger stdErrLogger;
    private boolean interceptStdout;
    private ScheduledFuture<?> heartbeatSendFuture;
    private Instant nextHeartbeatInstant;
    private final AtomicBoolean atShutdown = new AtomicBoolean();
    private final AtomicBoolean atCleanup = new AtomicBoolean();
    private final AtomicInteger artifactsInProgress = new AtomicInteger();
    private final AtomicInteger assetsInProgress = new AtomicInteger();

    OnlineExperimentImpl(String apiKey, String projectName, String workspaceName, String experimentName, String experimentKey, Logger logger, boolean interceptStdout, String baseUrl, int maxAuthRetries, Duration cleaningTimeout) throws IllegalArgumentException {
        super(apiKey, baseUrl, maxAuthRetries, experimentKey, cleaningTimeout, projectName, workspaceName);
        this.experimentName = experimentName;
        this.interceptStdout = interceptStdout;
        if (logger != null) {
            this.logger = logger;
        }
    }

    @Override
    public void end() {
        if (this.hasShutdownStarted()) {
            return;
        }
        this.getLogger().info(LogMessages.getString("EXPERIMENT_CLEANUP_PROMPT", this.cleaningTimeout.getSeconds()));
        this.atShutdown.set(true);
        this.atCleanup.set(true);
        try {
            this.waitForInventoryCleanup();
        }
        catch (Throwable t) {
            this.logger.error(LogMessages.getString("FAILED_TO_CLEAN_EXPERIMENT_INVENTORY"), t);
        }
        this.atCleanup.set(false);
        if (this.heartbeatSendFuture != null) {
            if (!this.heartbeatSendFuture.cancel(true)) {
                this.logger.error("Failed to stop experiment's heartbeat sender");
            } else {
                this.logger.info(LogMessages.getString("EXPERIMENT_HEARTBEAT_STOPPED_PROMPT"));
            }
            this.heartbeatSendFuture = null;
        }
        this.scheduledExecutorService.shutdownNow();
        try {
            if (!this.scheduledExecutorService.awaitTermination(60L, TimeUnit.SECONDS)) {
                this.logger.warn("Scheduled executor failed to terminate");
            }
        }
        catch (InterruptedException e) {
            this.logger.error("scheduled executor's wait for termination was interrupted", (Throwable)e);
        }
        if (this.interceptStdout) {
            try {
                this.stopInterceptStdout();
            }
            catch (IOException e) {
                this.logger.error("Failed to stop StdOut/StdErr intercepting", (Throwable)e);
            }
        }
        super.end();
    }

    @Override
    public void close() throws Exception {
        this.end();
    }

    @Override
    public void setInterceptStdout() throws IOException {
        if (!this.interceptStdout) {
            this.interceptStdout = true;
            this.captureStdout();
        }
    }

    @Override
    public void stopInterceptStdout() throws IOException {
        if (this.stdOutLogger != null) {
            this.stopStdOutLogger(this.stdOutLogger, 2000L);
            this.stdOutLogger = null;
            this.interceptStdout = false;
        }
        if (this.stdErrLogger != null) {
            this.stopStdOutLogger(this.stdErrLogger, 0L);
            this.stdErrLogger = null;
        }
    }

    @Override
    public void nextStep() {
        this.setStep(this.getStep() + 1L);
    }

    @Override
    public long getStep() {
        if (this.baseContext.getStep() != null) {
            return this.baseContext.getStep();
        }
        return 0L;
    }

    @Override
    public void setStep(long step) {
        this.baseContext.setStep(step);
    }

    @Override
    public void nextEpoch() {
        this.setEpoch(this.getEpoch() + 1L);
    }

    @Override
    public long getEpoch() {
        if (this.baseContext.getEpoch() != null) {
            return this.baseContext.getEpoch();
        }
        return 0L;
    }

    @Override
    public void setEpoch(long epoch) {
        this.baseContext.setEpoch(epoch);
    }

    @Override
    public void setContext(String context) {
        this.baseContext.setContext(context);
    }

    @Override
    public String getContext() {
        return this.baseContext.getContext();
    }

    @Override
    public Optional<String> getExperimentLink() {
        return Optional.ofNullable(this.experimentLink);
    }

    @Override
    public void logMetric(@NonNull String metricName, @NonNull Object metricValue, @NonNull ExperimentContext context) {
        if (metricName == null) {
            throw new NullPointerException("metricName is marked non-null but is null");
        }
        if (metricValue == null) {
            throw new NullPointerException("metricValue is marked non-null but is null");
        }
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        this.checkExperimentActiveState();
        this.logMetric(metricName, metricValue, context, Optional.empty());
    }

    @Override
    public void logMetric(String metricName, Object metricValue, long step, long epoch) {
        this.logMetric(metricName, metricValue, new ExperimentContext(step, epoch, this.getContext()));
    }

    @Override
    public void logMetric(String metricName, Object metricValue, long step) {
        this.logMetric(metricName, metricValue, new ExperimentContext(step, this.getEpoch(), this.getContext()));
    }

    @Override
    public void logMetric(String metricName, Object metricValue) {
        this.logMetric(metricName, metricValue, ExperimentContext.empty());
    }

    @Override
    public void logParameter(@NonNull String parameterName, @NonNull Object paramValue) {
        if (parameterName == null) {
            throw new NullPointerException("parameterName is marked non-null but is null");
        }
        if (paramValue == null) {
            throw new NullPointerException("paramValue is marked non-null but is null");
        }
        this.logParameter(parameterName, paramValue, ExperimentContext.empty());
    }

    @Override
    public void logParameter(@NonNull String parameterName, @NonNull Object paramValue, long step) {
        if (parameterName == null) {
            throw new NullPointerException("parameterName is marked non-null but is null");
        }
        if (paramValue == null) {
            throw new NullPointerException("paramValue is marked non-null but is null");
        }
        this.logParameter(parameterName, paramValue, new ExperimentContext(step, this.getEpoch(), this.getContext()));
    }

    @Override
    public void logParameter(String parameterName, Object paramValue, @NonNull ExperimentContext context) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        this.checkExperimentActiveState();
        this.logParameter(parameterName, paramValue, context, Optional.empty());
    }

    @Override
    public void logHtml(@NonNull String html, boolean override) {
        if (html == null) {
            throw new NullPointerException("html is marked non-null but is null");
        }
        this.checkExperimentActiveState();
        this.logHtml(html, override, Optional.empty());
    }

    @Override
    public void logOther(@NonNull String key, @NonNull Object value) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        this.checkExperimentActiveState();
        this.logOther(key, value, Optional.empty());
    }

    @Override
    public void addTag(@NonNull String tag) {
        if (tag == null) {
            throw new NullPointerException("tag is marked non-null but is null");
        }
        this.checkExperimentActiveState();
        this.addTag(tag, Optional.empty());
    }

    @Override
    public void logGraph(@NonNull String graph) {
        if (graph == null) {
            throw new NullPointerException("graph is marked non-null but is null");
        }
        this.checkExperimentActiveState();
        this.logGraph(graph, Optional.empty());
    }

    @Override
    public void logStartTime(long startTimeMillis) {
        this.checkExperimentActiveState();
        this.logStartTime(startTimeMillis, Optional.empty());
    }

    @Override
    public void logEndTime(long endTimeMillis) {
        this.checkExperimentActiveState();
        this.logEndTime(endTimeMillis, Optional.empty());
    }

    @Override
    public void logGitMetadata(GitMetaData gitMetadata) {
        this.checkExperimentActiveState();
        this.logGitMetadataAsync(gitMetadata, Optional.empty());
    }

    @Override
    public void logLine(String line, long offset, boolean stderr) {
        this.logLine(line, offset, stderr, this.getContext());
    }

    @Override
    public void logLine(String line, long offset, boolean stderr, String context) {
        this.setContext(context);
        this.logLine(line, offset, stderr, context, Optional.empty());
    }

    @Override
    public void logAssetFolder(@NonNull File folder, boolean logFilePath, boolean recursive, @NonNull ExperimentContext context) {
        if (folder == null) {
            throw new NullPointerException("folder is marked non-null but is null");
        }
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        this.executeLogAction(() -> this.logAssetFolder(folder, logFilePath, recursive, true, context, this.getLogAssetOnCompleteAction()), this.assetsInProgress, LogMessages.getString("FAILED_TO_LOG_ASSET_FOLDER", folder));
    }

    @Override
    public void logAssetFolder(@NonNull File folder, boolean logFilePath, boolean recursive) {
        if (folder == null) {
            throw new NullPointerException("folder is marked non-null but is null");
        }
        this.logAssetFolder(folder, logFilePath, recursive, ExperimentContext.empty());
    }

    @Override
    public void logAssetFolder(@NonNull File folder, boolean logFilePath) {
        if (folder == null) {
            throw new NullPointerException("folder is marked non-null but is null");
        }
        this.logAssetFolder(folder, logFilePath, false);
    }

    @Override
    public void uploadAsset(@NonNull File asset, @NonNull String logicalPath, boolean overwrite, @NonNull ExperimentContext context) {
        if (asset == null) {
            throw new NullPointerException("asset is marked non-null but is null");
        }
        if (logicalPath == null) {
            throw new NullPointerException("logicalPath is marked non-null but is null");
        }
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        this.executeLogAction(() -> this.logAssetFileAsync(asset, logicalPath, overwrite, context, this.getLogAssetOnCompleteAction()), this.assetsInProgress, LogMessages.getString("FAILED_TO_LOG_ASSET", logicalPath));
    }

    @Override
    public void uploadAsset(@NonNull File asset, boolean overwrite, @NonNull ExperimentContext context) {
        if (asset == null) {
            throw new NullPointerException("asset is marked non-null but is null");
        }
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        this.uploadAsset(asset, asset.getName(), overwrite, context);
    }

    @Override
    public void uploadAsset(@NonNull File asset, boolean overwrite, long step, long epoch) {
        if (asset == null) {
            throw new NullPointerException("asset is marked non-null but is null");
        }
        this.uploadAsset(asset, asset.getName(), overwrite, new ExperimentContext(step, epoch, this.getContext()));
    }

    @Override
    public void uploadAsset(@NonNull File asset, @NonNull String logicalPath, boolean overwrite, long step) {
        if (asset == null) {
            throw new NullPointerException("asset is marked non-null but is null");
        }
        if (logicalPath == null) {
            throw new NullPointerException("logicalPath is marked non-null but is null");
        }
        this.uploadAsset(asset, logicalPath, overwrite, new ExperimentContext(step, this.getEpoch(), this.getContext()));
    }

    @Override
    public void uploadAsset(@NonNull File asset, @NonNull String logicalPath, boolean overwrite) {
        if (asset == null) {
            throw new NullPointerException("asset is marked non-null but is null");
        }
        if (logicalPath == null) {
            throw new NullPointerException("logicalPath is marked non-null but is null");
        }
        this.uploadAsset(asset, logicalPath, overwrite, ExperimentContext.empty());
    }

    @Override
    public void uploadAsset(@NonNull File asset, boolean overwrite) {
        if (asset == null) {
            throw new NullPointerException("asset is marked non-null but is null");
        }
        this.uploadAsset(asset, asset.getName(), overwrite, ExperimentContext.empty());
    }

    @Override
    public void logRemoteAsset(@NonNull URI uri, String logicalPath, boolean overwrite, Map<String, Object> metadata, @NonNull ExperimentContext context) {
        if (uri == null) {
            throw new NullPointerException("uri is marked non-null but is null");
        }
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        this.executeLogAction(() -> this.logRemoteAsset(uri, Optional.ofNullable(logicalPath), overwrite, Optional.ofNullable(metadata), context, this.getLogAssetOnCompleteAction()), this.assetsInProgress, LogMessages.getString("FAILED_TO_LOG_REMOTE_ASSET", uri));
    }

    @Override
    public void logRemoteAsset(@NonNull URI uri, String logicalPath, boolean overwrite, Map<String, Object> metadata) {
        if (uri == null) {
            throw new NullPointerException("uri is marked non-null but is null");
        }
        this.logRemoteAsset(uri, logicalPath, overwrite, metadata, ExperimentContext.empty());
    }

    @Override
    public void logRemoteAsset(@NonNull URI uri, @NonNull String logicalPath, boolean overwrite) {
        if (uri == null) {
            throw new NullPointerException("uri is marked non-null but is null");
        }
        if (logicalPath == null) {
            throw new NullPointerException("logicalPath is marked non-null but is null");
        }
        this.logRemoteAsset(uri, logicalPath, overwrite, null);
    }

    @Override
    public void logRemoteAsset(@NonNull URI uri, boolean overwrite) {
        if (uri == null) {
            throw new NullPointerException("uri is marked non-null but is null");
        }
        this.logRemoteAsset(uri, null, overwrite, null, ExperimentContext.empty());
    }

    @Override
    public void logCode(@NonNull String code, @NonNull String logicalPath, @NonNull ExperimentContext context) {
        if (code == null) {
            throw new NullPointerException("code is marked non-null but is null");
        }
        if (logicalPath == null) {
            throw new NullPointerException("logicalPath is marked non-null but is null");
        }
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        this.executeLogAction(() -> this.logAssetDataAsync(code.getBytes(StandardCharsets.UTF_8), logicalPath, false, Optional.of(AssetType.SOURCE_CODE.type()), Optional.empty(), Optional.empty(), context, this.getLogAssetOnCompleteAction()), this.assetsInProgress, LogMessages.getString("FAILED_TO_LOG_CODE_ASSET", logicalPath));
    }

    @Override
    public void logCode(@NonNull File file, @NonNull ExperimentContext context) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        this.executeLogAction(() -> this.logAssetFileAsync(file, file.getName(), false, Optional.of(AssetType.SOURCE_CODE.type()), Optional.empty(), Optional.empty(), context, this.getLogAssetOnCompleteAction()), this.assetsInProgress, LogMessages.getString("FAILED_TO_LOG_CODE_ASSET", file));
    }

    @Override
    public void logCode(@NonNull String code, @NonNull String logicalPath) {
        if (code == null) {
            throw new NullPointerException("code is marked non-null but is null");
        }
        if (logicalPath == null) {
            throw new NullPointerException("logicalPath is marked non-null but is null");
        }
        this.logCode(code, logicalPath, ExperimentContext.empty());
    }

    @Override
    public void logCode(@NonNull File file) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        this.logCode(file, ExperimentContext.empty());
    }

    @Override
    public void logText(@NonNull String text, @NonNull ExperimentContext context, Map<String, Object> metadata) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        this.executeLogAction(() -> this.logAssetDataAsync(text.getBytes(StandardCharsets.UTF_8), "auto-generated-in-the-backend", false, Optional.of(AssetType.TEXT_SAMPLE.type()), Optional.empty(), Optional.ofNullable(metadata), context, this.getLogAssetOnCompleteAction()), this.assetsInProgress, LogMessages.getString("FAILED_TO_LOG_TEXT_ASSET"));
    }

    @Override
    public void logText(String text, @NonNull ExperimentContext context) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        this.logText(text, context, null);
    }

    @Override
    public void logText(String text) {
        this.logText(text, ExperimentContext.empty());
    }

    @Override
    public void logCurve(@NonNull Curve curve, boolean overwrite, @NonNull ExperimentContext context) {
        if (curve == null) {
            throw new NullPointerException("curve is marked non-null but is null");
        }
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        AssetImpl asset = AssetUtils.createAssetFromCurve(curve, overwrite);
        this.executeLogAction(() -> this.logAssetAsync(asset, context, this.getLogAssetOnCompleteAction()), this.assetsInProgress, LogMessages.getString("FAILED_TO_LOG_CURVE_ASSET"));
    }

    @Override
    public void logCurve(@NonNull Curve curve, boolean overwrite) {
        if (curve == null) {
            throw new NullPointerException("curve is marked non-null but is null");
        }
        this.logCurve(curve, overwrite, ExperimentContext.empty());
    }

    @Override
    public void logCurve(@NonNull Curve curve) {
        if (curve == null) {
            throw new NullPointerException("curve is marked non-null but is null");
        }
        this.logCurve(curve, false);
    }

    @Override
    public CompletableFuture<LoggedArtifact> logArtifact(Artifact artifact) throws ArtifactException {
        this.checkExperimentActiveState();
        try {
            this.artifactsInProgress.incrementAndGet();
            return this.logArtifact(artifact, Optional.of(this.artifactsInProgress::decrementAndGet));
        }
        catch (Throwable t) {
            this.artifactsInProgress.decrementAndGet();
            throw t;
        }
    }

    @Override
    public void logModelFolder(@NonNull String modelName, @NonNull File folder, boolean logFilePath, Map<String, Object> metadata, @NonNull ExperimentContext context) {
        if (modelName == null) {
            throw new NullPointerException("modelName is marked non-null but is null");
        }
        if (folder == null) {
            throw new NullPointerException("folder is marked non-null but is null");
        }
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        this.executeLogAction(() -> this.logAssetFolder(folder, logFilePath, true, logFilePath, Optional.of(AssetType.MODEL_ELEMENT.type()), Optional.of(modelName), Optional.ofNullable(metadata), context, this.getLogAssetOnCompleteAction()), this.assetsInProgress, LogMessages.getString("FAILED_TO_LOG_MODEL_FOLDER", folder, modelName));
    }

    @Override
    public void logModelFolder(@NonNull String modelName, @NonNull File folder, boolean logFilePath, Map<String, Object> metadata) {
        if (modelName == null) {
            throw new NullPointerException("modelName is marked non-null but is null");
        }
        if (folder == null) {
            throw new NullPointerException("folder is marked non-null but is null");
        }
        this.logModelFolder(modelName, folder, logFilePath, metadata, ExperimentContext.empty());
    }

    @Override
    public void logModelFolder(@NonNull String modelName, @NonNull File folder, Map<String, Object> metadata) {
        if (modelName == null) {
            throw new NullPointerException("modelName is marked non-null but is null");
        }
        if (folder == null) {
            throw new NullPointerException("folder is marked non-null but is null");
        }
        this.logModelFolder(modelName, folder, true, metadata);
    }

    @Override
    public void logModelFolder(@NonNull String modelName, @NonNull File folder) {
        if (modelName == null) {
            throw new NullPointerException("modelName is marked non-null but is null");
        }
        if (folder == null) {
            throw new NullPointerException("folder is marked non-null but is null");
        }
        this.logModelFolder(modelName, folder, null);
    }

    @Override
    public void logModel(@NonNull String modelName, @NonNull File file, @NonNull String logicalPath, boolean overwrite, Map<String, Object> metadata, @NonNull ExperimentContext context) {
        if (modelName == null) {
            throw new NullPointerException("modelName is marked non-null but is null");
        }
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        if (logicalPath == null) {
            throw new NullPointerException("logicalPath is marked non-null but is null");
        }
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        this.executeLogAction(() -> this.logAssetFileAsync(file, logicalPath, overwrite, Optional.of(AssetType.MODEL_ELEMENT.type()), Optional.of(modelName), Optional.ofNullable(metadata), context, this.getLogAssetOnCompleteAction()), this.assetsInProgress, LogMessages.getString("FAILED_TO_LOG_MODEL_ASSET", modelName, logicalPath));
    }

    @Override
    public void logModel(@NonNull String modelName, @NonNull File file, @NonNull String logicalPath, boolean overwrite, Map<String, Object> metadata) {
        if (modelName == null) {
            throw new NullPointerException("modelName is marked non-null but is null");
        }
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        if (logicalPath == null) {
            throw new NullPointerException("logicalPath is marked non-null but is null");
        }
        this.logModel(modelName, file, logicalPath, overwrite, metadata, ExperimentContext.empty());
    }

    @Override
    public void logModel(@NonNull String modelName, @NonNull File file, @NonNull String logicalPath, boolean overwrite) {
        if (modelName == null) {
            throw new NullPointerException("modelName is marked non-null but is null");
        }
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        if (logicalPath == null) {
            throw new NullPointerException("logicalPath is marked non-null but is null");
        }
        this.logModel(modelName, file, logicalPath, overwrite, null);
    }

    @Override
    public void logModel(@NonNull String modelName, @NonNull File file, @NonNull String logicalPath) {
        if (modelName == null) {
            throw new NullPointerException("modelName is marked non-null but is null");
        }
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        if (logicalPath == null) {
            throw new NullPointerException("logicalPath is marked non-null but is null");
        }
        this.logModel(modelName, file, logicalPath, false);
    }

    @Override
    public void logModel(@NonNull String modelName, @NonNull File file) {
        if (modelName == null) {
            throw new NullPointerException("modelName is marked non-null but is null");
        }
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        this.logModel(modelName, file, file.getName());
    }

    @Override
    public void logModel(@NonNull String modelName, byte[] data, @NonNull String logicalPath, boolean overwrite, Map<String, Object> metadata, @NonNull ExperimentContext context) {
        if (modelName == null) {
            throw new NullPointerException("modelName is marked non-null but is null");
        }
        if (logicalPath == null) {
            throw new NullPointerException("logicalPath is marked non-null but is null");
        }
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        this.executeLogAction(() -> this.logAssetDataAsync(data, logicalPath, overwrite, Optional.of(AssetType.MODEL_ELEMENT.type()), Optional.of(modelName), Optional.ofNullable(metadata), context, this.getLogAssetOnCompleteAction()), this.assetsInProgress, LogMessages.getString("FAILED_TO_LOG_MODEL_ASSET", modelName, logicalPath));
    }

    @Override
    public void logModel(@NonNull String modelName, byte[] data, @NonNull String logicalPath, boolean overwrite, Map<String, Object> metadata) {
        if (modelName == null) {
            throw new NullPointerException("modelName is marked non-null but is null");
        }
        if (logicalPath == null) {
            throw new NullPointerException("logicalPath is marked non-null but is null");
        }
        this.logModel(modelName, data, logicalPath, overwrite, metadata, ExperimentContext.empty());
    }

    @Override
    public void logModel(@NonNull String modelName, byte[] data, @NonNull String logicalPath, boolean overwrite) {
        if (modelName == null) {
            throw new NullPointerException("modelName is marked non-null but is null");
        }
        if (logicalPath == null) {
            throw new NullPointerException("logicalPath is marked non-null but is null");
        }
        this.logModel(modelName, data, logicalPath, overwrite, null);
    }

    @Override
    public void logModel(@NonNull String modelName, byte[] data, @NonNull String logicalPath) {
        if (modelName == null) {
            throw new NullPointerException("modelName is marked non-null but is null");
        }
        if (logicalPath == null) {
            throw new NullPointerException("logicalPath is marked non-null but is null");
        }
        this.logModel(modelName, data, logicalPath, false);
    }

    @Override
    void init() {
        super.init();
        this.setupStdOutIntercept();
        this.registerExperiment();
        try {
            this.logSystemDetails();
        }
        catch (CometApiException ex) {
            this.logger.error(LogMessages.getString("FAILED_LOG_SYSTEM_DETAILS"), (Throwable)ex);
        }
        this.nextHeartbeatInstant = Instant.now();
        this.heartbeatSendFuture = this.scheduledExecutorService.scheduleAtFixedRate(new HeartbeatPing(this), 500L, 1000L, TimeUnit.MILLISECONDS);
    }

    private void setupStdOutIntercept() {
        if (this.interceptStdout) {
            try {
                this.captureStdout();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void stopStdOutLogger(@NonNull StdOutLogger stdOutLogger, long delay) throws IOException {
        if (stdOutLogger == null) {
            throw new NullPointerException("stdOutLogger is marked non-null but is null");
        }
        stdOutLogger.flush();
        try {
            Thread.sleep(delay);
        }
        catch (InterruptedException e) {
            this.logger.warn("interrupted while waiting for StdLogger to flush", (Throwable)e);
        }
        stdOutLogger.close();
    }

    private void captureStdout() throws IOException {
        this.stdOutLogger = StdOutLogger.createStdoutLogger(this);
        this.stdErrLogger = StdOutLogger.createStderrLogger(this);
    }

    private void sendHeartbeat() {
        if (!this.alive || this.hasShutdownStarted() && !this.atCleanup.get()) {
            return;
        }
        this.logger.debug("sendHeartbeat");
        Instant nowInstant = Instant.now();
        if (nowInstant.isBefore(this.nextHeartbeatInstant)) {
            return;
        }
        Optional<ExperimentStatusResponse> status = this.sendExperimentStatus();
        if (status.isPresent()) {
            long interval = status.get().getIsAliveBeatDurationMillis();
            Instant now = Instant.now();
            this.nextHeartbeatInstant = now.plusMillis(interval);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("received heartbeat interval {} ms at {}, next heartbeat at {}", new Object[]{interval, now, this.nextHeartbeatInstant});
            }
        } else {
            this.nextHeartbeatInstant = Instant.now().plusMillis(3000L);
        }
    }

    private void waitForInventoryCleanup() {
        if (!this.alive || this.hasEmptyInventory()) {
            return;
        }
        this.logger.info(LogMessages.getString("EXPERIMENT_INVENTORY_STATUS_PROMPT", this.assetsInProgress.get(), this.artifactsInProgress.get()));
        Awaitility.await((String)LogMessages.getString("TIMEOUT_FOR_EXPERIMENT_INVENTORY_CLEANUP", this.assetsInProgress.get(), this.artifactsInProgress.get())).atMost(this.cleaningTimeout).pollInterval(500L, TimeUnit.MILLISECONDS).until(this::hasEmptyInventory);
    }

    private boolean hasEmptyInventory() {
        return this.artifactsInProgress.get() == 0 && this.assetsInProgress.get() == 0;
    }

    private boolean hasShutdownStarted() {
        return this.atShutdown.get();
    }

    private void checkExperimentActiveState() throws IllegalStateException {
        if (this.hasShutdownStarted()) {
            throw new IllegalStateException(LogMessages.getString("EXPERIMENT_ALREADY_CLOSED_STATUS_ERROR"));
        }
    }

    void executeLogAction(Action action, AtomicInteger inventory, String errMessage) {
        this.checkExperimentActiveState();
        try {
            inventory.incrementAndGet();
            action.run();
        }
        catch (Throwable t) {
            inventory.decrementAndGet();
            this.logger.error(errMessage, t);
        }
    }

    Optional<Action> getLogAssetOnCompleteAction() {
        return Optional.of(this.assetsInProgress::decrementAndGet);
    }

    public static OnlineExperimentBuilderImpl builder() {
        return new OnlineExperimentBuilderImpl();
    }

    @Override
    public Logger getLogger() {
        return this.logger;
    }

    public AtomicInteger getArtifactsInProgress() {
        return this.artifactsInProgress;
    }

    public AtomicInteger getAssetsInProgress() {
        return this.assetsInProgress;
    }

    static class HeartbeatPing
    implements Runnable {
        OnlineExperimentImpl onlineExperiment;

        HeartbeatPing(OnlineExperimentImpl onlineExperiment) {
            this.onlineExperiment = onlineExperiment;
        }

        @Override
        public void run() {
            this.onlineExperiment.sendHeartbeat();
        }
    }
}

