/*
 * Decompiled with CFR 0.152.
 */
package ml.comet.experiment.impl;

import com.vdurmont.semver4j.Semver;
import java.util.List;
import ml.comet.experiment.impl.resources.LogMessages;
import ml.comet.experiment.impl.utils.ModelUtils;
import ml.comet.experiment.registrymodel.Model;
import ml.comet.experiment.registrymodel.ModelBuilder;
import org.apache.commons.lang3.StringUtils;

public final class RegistryModelImpl
implements Model {
    private final String name;
    private Semver version;
    private String registryModelName;
    private Boolean isPublic;
    private String workspace;
    private String description;
    private String comment;
    private List<String> stages;
    private String experimentModelId;

    RegistryModelImpl(String name) {
        this.name = name;
        this.version = new Semver("1.0.0");
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getVersion() {
        return this.version.getValue();
    }

    @Override
    public String getWorkspace() {
        return this.workspace;
    }

    @Override
    public String getRegistryName() {
        return this.registryModelName;
    }

    @Override
    public boolean isPublic() {
        if (this.isPublic != null) {
            return this.isPublic;
        }
        return false;
    }

    public Boolean getIsPublic() {
        return this.isPublic;
    }

    public void setWorkspace(String workspace) {
        this.workspace = workspace;
    }

    public String getDescription() {
        return this.description;
    }

    public String getComment() {
        return this.comment;
    }

    public List<String> getStages() {
        return this.stages;
    }

    public String getExperimentModelId() {
        return this.experimentModelId;
    }

    public void setExperimentModelId(String experimentModelId) {
        this.experimentModelId = experimentModelId;
    }

    public static class RegistryModelBuilderImpl
    implements ModelBuilder {
        final RegistryModelImpl model;

        public RegistryModelBuilderImpl(String name) {
            this.model = new RegistryModelImpl(name);
        }

        @Override
        public RegistryModelBuilderImpl withVersion(String version) {
            this.model.version = new Semver(version);
            return this;
        }

        @Override
        public RegistryModelBuilderImpl withWorkspace(String workspace) {
            this.model.workspace = workspace;
            return this;
        }

        @Override
        public RegistryModelBuilderImpl withRegistryName(String registryModelName) {
            this.model.registryModelName = registryModelName;
            return this;
        }

        @Override
        public RegistryModelBuilderImpl asPublic(boolean isPublic) {
            this.model.isPublic = isPublic;
            return this;
        }

        @Override
        public RegistryModelBuilderImpl withDescription(String description) {
            this.model.description = description;
            return this;
        }

        @Override
        public RegistryModelBuilderImpl withComment(String comment) {
            this.model.comment = comment;
            return this;
        }

        @Override
        public RegistryModelBuilderImpl withStages(List<String> tags) {
            this.model.stages = tags;
            return this;
        }

        @Override
        public Model build() {
            if (StringUtils.isBlank((CharSequence)this.model.registryModelName)) {
                this.model.registryModelName = ModelUtils.createRegistryModelName(this.model.name);
            } else if (!ModelUtils.createRegistryModelName(this.model.registryModelName).equals(this.model.registryModelName)) {
                throw new IllegalArgumentException(LogMessages.getString("INVALID_MODEL_REGISTRY_NAME_PROVIDED", this.model.registryModelName, ModelUtils.createRegistryModelName(this.model.registryModelName)));
            }
            return this.model;
        }
    }
}

