/*
 * Decompiled with CFR 0.152.
 */
package ml.comet.experiment.impl.log;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.util.concurrent.atomic.AtomicLong;
import lombok.NonNull;
import ml.comet.experiment.OnlineExperiment;
import ml.comet.experiment.impl.log.CopyOutputStream;

public class StdOutLogger
implements Runnable,
Closeable {
    final AtomicLong offset = new AtomicLong();
    OutputStream outputStream;
    InputStream inputStream;
    PrintStream original;
    OnlineExperiment experiment;
    boolean stdOut;

    public static StdOutLogger createStdoutLogger(@NonNull OnlineExperiment experiment) throws IOException {
        if (experiment == null) {
            throw new NullPointerException("experiment is marked non-null but is null");
        }
        return StdOutLogger.createLogger(experiment, System.out, true);
    }

    public static StdOutLogger createStderrLogger(@NonNull OnlineExperiment experiment) throws IOException {
        if (experiment == null) {
            throw new NullPointerException("experiment is marked non-null but is null");
        }
        return StdOutLogger.createLogger(experiment, System.err, false);
    }

    @Override
    public void close() throws IOException {
        this.restoreOriginalAndStop();
        this.outputStream.close();
    }

    public void flush() {
        if (this.stdOut) {
            System.out.flush();
        } else {
            System.err.flush();
        }
    }

    private StdOutLogger(PrintStream original, OnlineExperiment experiment, InputStream in, OutputStream out, boolean stdOut) {
        this.original = original;
        this.experiment = experiment;
        this.inputStream = in;
        this.outputStream = out;
        this.stdOut = stdOut;
    }

    private void restoreOriginalAndStop() {
        if (this.inputStream != null) {
            try {
                this.inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.stdOut) {
            System.setOut(this.original);
        } else {
            System.setErr(this.original);
        }
    }

    @Override
    public void run() {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(this.inputStream));){
            String line;
            while ((line = reader.readLine()) != null) {
                this.experiment.logLine(line.concat("\n"), this.offset.incrementAndGet(), !this.stdOut);
            }
        }
        catch (Throwable t) {
            this.restoreOriginalAndStop();
            if (this.stdOut) {
                System.out.println("\nStdOut capturing error occurred");
            } else {
                System.out.println("\nStdErr capturing error occurred");
            }
            t.printStackTrace();
        }
        if (this.stdOut) {
            System.out.println("\nStdOut interception stopped");
        } else {
            System.out.println("\nStdErr interception stopped");
        }
    }

    private static StdOutLogger createLogger(@NonNull OnlineExperiment experiment, @NonNull PrintStream original, boolean stdOut) throws IOException {
        if (experiment == null) {
            throw new NullPointerException("experiment is marked non-null but is null");
        }
        if (original == null) {
            throw new NullPointerException("original is marked non-null but is null");
        }
        PipedInputStream in = new PipedInputStream();
        PipedOutputStream out = new PipedOutputStream(in);
        CopyOutputStream copyStream = new CopyOutputStream(original, out);
        PrintStream replacement = new PrintStream(copyStream);
        if (stdOut) {
            System.setOut(replacement);
        } else {
            System.setErr(replacement);
        }
        StdOutLogger logger = new StdOutLogger(original, experiment, in, out, stdOut);
        Thread loggerThread = new Thread(logger);
        loggerThread.setDaemon(true);
        loggerThread.start();
        return logger;
    }
}

