/*
 * Decompiled with CFR 0.152.
 */
package ml.comet.experiment.context;

import java.util.Objects;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

public final class ExperimentContext {
    private Long step;
    private Long epoch;
    private String context;

    ExperimentContext() {
    }

    public ExperimentContext(String context) {
        this.context = context;
    }

    public ExperimentContext(long step, long epoch, String context) {
        this.step = step;
        this.epoch = epoch;
        this.context = context;
    }

    public ExperimentContext(long step, long epoch) {
        this(step, epoch, "");
    }

    public ExperimentContext(long step) {
        this(step, 0L);
    }

    public ExperimentContext(ExperimentContext other) {
        this.step = other.step;
        this.epoch = other.epoch;
        this.context = other.context;
    }

    public void mergeFrom(@NonNull ExperimentContext other) {
        if (other == null) {
            throw new NullPointerException("other is marked non-null but is null");
        }
        if (Objects.equals(this, other)) {
            return;
        }
        if (Objects.nonNull(other.step)) {
            this.step = other.step;
        }
        if (Objects.nonNull(other.epoch)) {
            this.epoch = other.epoch;
        }
        if (StringUtils.isNotBlank((CharSequence)other.context)) {
            this.context = other.context;
        }
    }

    public boolean isEmpty() {
        return Objects.isNull(this.step) && Objects.isNull(this.epoch) && StringUtils.isBlank((CharSequence)this.context);
    }

    public boolean equals(Object obj) {
        if (Objects.isNull(obj) || !(obj instanceof ExperimentContext)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        ExperimentContext ctx = (ExperimentContext)obj;
        return Objects.equals(this.context, ctx.context) && Objects.equals(this.epoch, ctx.epoch) && Objects.equals(this.step, ctx.step);
    }

    public static ExperimentContext empty() {
        return new ExperimentContext();
    }

    public static ExperimentContextBuilder builder() {
        return new ExperimentContextBuilder();
    }

    public Long getStep() {
        return this.step;
    }

    public Long getEpoch() {
        return this.epoch;
    }

    public String getContext() {
        return this.context;
    }

    public void setStep(Long step) {
        this.step = step;
    }

    public void setEpoch(Long epoch) {
        this.epoch = epoch;
    }

    public void setContext(String context) {
        this.context = context;
    }

    public String toString() {
        return "ExperimentContext(step=" + this.getStep() + ", epoch=" + this.getEpoch() + ", context=" + this.getContext() + ")";
    }

    public static final class ExperimentContextBuilder {
        private final ExperimentContext context = new ExperimentContext();

        ExperimentContextBuilder() {
        }

        public ExperimentContextBuilder withStep(long step) {
            this.context.step = step;
            return this;
        }

        public ExperimentContextBuilder withEpoch(long epoch) {
            this.context.epoch = epoch;
            return this;
        }

        public ExperimentContextBuilder withContext(String context) {
            this.context.context = context;
            return this;
        }

        public ExperimentContext build() {
            return this.context;
        }
    }
}

