/*
 * Decompiled with CFR 0.152.
 */
package ml.comet.experiment.impl;

import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.functions.BiFunction;
import io.reactivex.rxjava3.functions.Function;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import lombok.NonNull;
import ml.comet.experiment.Experiment;
import ml.comet.experiment.artifact.Artifact;
import ml.comet.experiment.artifact.ArtifactDownloadException;
import ml.comet.experiment.artifact.ArtifactException;
import ml.comet.experiment.artifact.ArtifactNotFoundException;
import ml.comet.experiment.artifact.AssetOverwriteStrategy;
import ml.comet.experiment.artifact.GetArtifactOptions;
import ml.comet.experiment.artifact.InvalidArtifactStateException;
import ml.comet.experiment.artifact.LoggedArtifact;
import ml.comet.experiment.artifact.LoggedArtifactAsset;
import ml.comet.experiment.asset.LoggedExperimentAsset;
import ml.comet.experiment.context.ExperimentContext;
import ml.comet.experiment.exception.CometApiException;
import ml.comet.experiment.exception.CometGeneralException;
import ml.comet.experiment.impl.ArtifactImpl;
import ml.comet.experiment.impl.LoggedArtifactAssetImpl;
import ml.comet.experiment.impl.LoggedArtifactImpl;
import ml.comet.experiment.impl.RestApiClient;
import ml.comet.experiment.impl.asset.ArtifactAssetImpl;
import ml.comet.experiment.impl.asset.AssetImpl;
import ml.comet.experiment.impl.asset.AssetType;
import ml.comet.experiment.impl.asset.DownloadArtifactAssetOptions;
import ml.comet.experiment.impl.http.Connection;
import ml.comet.experiment.impl.http.ConnectionInitializer;
import ml.comet.experiment.impl.resources.LogMessages;
import ml.comet.experiment.impl.rest.ArtifactDto;
import ml.comet.experiment.impl.rest.ArtifactEntry;
import ml.comet.experiment.impl.rest.ArtifactRequest;
import ml.comet.experiment.impl.rest.ArtifactVersionAssetResponse;
import ml.comet.experiment.impl.rest.ArtifactVersionDetail;
import ml.comet.experiment.impl.rest.ArtifactVersionState;
import ml.comet.experiment.impl.rest.CreateExperimentRequest;
import ml.comet.experiment.impl.rest.CreateExperimentResponse;
import ml.comet.experiment.impl.rest.ExperimentAssetListResponse;
import ml.comet.experiment.impl.rest.ExperimentMetadataRest;
import ml.comet.experiment.impl.rest.ExperimentStatusResponse;
import ml.comet.experiment.impl.rest.GetGraphResponse;
import ml.comet.experiment.impl.rest.GetHtmlResponse;
import ml.comet.experiment.impl.rest.GetOutputResponse;
import ml.comet.experiment.impl.rest.GitMetadataRest;
import ml.comet.experiment.impl.rest.MinMaxResponse;
import ml.comet.experiment.impl.rest.RestApiResponse;
import ml.comet.experiment.impl.rest.TagsResponse;
import ml.comet.experiment.impl.utils.AssetUtils;
import ml.comet.experiment.impl.utils.CometUtils;
import ml.comet.experiment.impl.utils.ExceptionUtils;
import ml.comet.experiment.impl.utils.FileUtils;
import ml.comet.experiment.impl.utils.RestApiUtils;
import ml.comet.experiment.impl.utils.SystemUtils;
import ml.comet.experiment.model.Curve;
import ml.comet.experiment.model.ExperimentMetadata;
import ml.comet.experiment.model.GitMetaData;
import ml.comet.experiment.model.Value;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

abstract class BaseExperiment
implements Experiment {
    final String apiKey;
    final String baseUrl;
    final int maxAuthRetries;
    final Duration cleaningTimeout;
    String projectName;
    String workspaceName;
    String experimentKey;
    String experimentLink;
    String experimentName;
    boolean alive;
    private RestApiClient restApiClient;
    private Connection connection;

    protected abstract Logger getLogger();

    BaseExperiment(@NonNull String apiKey, @NonNull String baseUrl, int maxAuthRetries, String experimentKey, @NonNull Duration cleaningTimeout, String projectName, String workspaceName) {
        if (apiKey == null) {
            throw new NullPointerException("apiKey is marked non-null but is null");
        }
        if (baseUrl == null) {
            throw new NullPointerException("baseUrl is marked non-null but is null");
        }
        if (cleaningTimeout == null) {
            throw new NullPointerException("cleaningTimeout is marked non-null but is null");
        }
        this.apiKey = apiKey;
        this.baseUrl = baseUrl;
        this.maxAuthRetries = maxAuthRetries;
        this.experimentKey = experimentKey;
        this.cleaningTimeout = cleaningTimeout;
        this.projectName = projectName;
        this.workspaceName = workspaceName;
    }

    void init() {
        CometUtils.printCometSdkVersion();
        this.validateInitialParams();
        this.connection = ConnectionInitializer.initConnection(this.apiKey, this.baseUrl, this.maxAuthRetries, this.getLogger());
        this.restApiClient = new RestApiClient(this.connection);
        this.alive = true;
    }

    private void validateInitialParams() throws IllegalArgumentException {
        if (StringUtils.isBlank((CharSequence)this.apiKey)) {
            throw new IllegalArgumentException("API key is not specified!");
        }
        if (StringUtils.isBlank((CharSequence)this.baseUrl)) {
            throw new IllegalArgumentException("The Comet base URL is not specified!");
        }
    }

    void registerExperiment() throws CometGeneralException {
        if (StringUtils.isNotBlank((CharSequence)this.experimentKey)) {
            this.getLogger().debug("Not registering a new experiment. Using previous experiment key {}", (Object)this.experimentKey);
            return;
        }
        try {
            CreateExperimentResponse result = (CreateExperimentResponse)this.restApiClient.registerExperiment(new CreateExperimentRequest(this.workspaceName, this.projectName, this.experimentName)).blockingGet();
            if (StringUtils.isBlank((CharSequence)result.getExperimentKey())) {
                throw new CometGeneralException(LogMessages.getString("FAILED_REGISTER_EXPERIMENT"));
            }
            this.experimentKey = result.getExperimentKey();
            this.experimentLink = result.getLink();
            this.workspaceName = result.getWorkspaceName();
            this.projectName = result.getProjectName();
            if (StringUtils.isBlank((CharSequence)this.experimentName)) {
                this.experimentName = result.getName();
            }
        }
        catch (CometApiException ex) {
            this.getLogger().error(LogMessages.getString("FAILED_REGISTER_EXPERIMENT"), (Throwable)ex);
            throw new CometGeneralException(LogMessages.getString("FAILED_REGISTER_EXPERIMENT"), ex);
        }
        this.getLogger().info(LogMessages.getString("EXPERIMENT_CREATED", this.workspaceName, this.projectName, this.experimentName));
        this.getLogger().info(LogMessages.getString("EXPERIMENT_LIVE", this.experimentLink));
    }

    void logSystemDetails() throws CometApiException {
        this.sendSynchronously(this.restApiClient::logSystemDetails, SystemUtils.readSystemDetails());
    }

    @Override
    public String getExperimentKey() {
        return this.experimentKey;
    }

    @Override
    public String getProjectName() {
        return this.projectName;
    }

    @Override
    public String getWorkspaceName() {
        return this.workspaceName;
    }

    @Override
    public String getExperimentName() {
        return this.experimentName;
    }

    @Override
    public void setExperimentName(@NonNull String experimentName) {
        if (experimentName == null) {
            throw new NullPointerException("experimentName is marked non-null but is null");
        }
        this.logOther("Name", experimentName);
        this.experimentName = experimentName;
    }

    @Override
    public void logMetric(@NonNull String metricName, @NonNull Object metricValue, @NonNull ExperimentContext context) {
        if (metricName == null) {
            throw new NullPointerException("metricName is marked non-null but is null");
        }
        if (metricValue == null) {
            throw new NullPointerException("metricValue is marked non-null but is null");
        }
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("logMetric {} = {}, context: {}", new Object[]{metricName, metricValue, context});
        }
        this.sendSynchronously(this.restApiClient::logMetric, RestApiUtils.createLogMetricRequest(metricName, metricValue, context));
    }

    @Override
    public void logMetric(String metricName, Object metricValue, long step, long epoch) {
        this.logMetric(metricName, metricValue, new ExperimentContext(step, epoch));
    }

    @Override
    public void logParameter(String parameterName, Object paramValue, ExperimentContext context) {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("logParameter {} = {}, context: {}", new Object[]{parameterName, paramValue, context});
        }
        this.sendSynchronously(this.restApiClient::logParameter, RestApiUtils.createLogParamRequest(parameterName, paramValue, context));
    }

    @Override
    public void logParameter(String parameterName, Object paramValue, long step) {
        this.logParameter(parameterName, paramValue, new ExperimentContext(step));
    }

    @Override
    public void logLine(String line, long offset, boolean stderr, String context) {
        this.validate();
        this.sendSynchronously(this.restApiClient::logOutputLine, RestApiUtils.createLogLineRequest(line, offset, stderr, context));
    }

    @Override
    public void logHtml(@NonNull String html, boolean override) {
        if (html == null) {
            throw new NullPointerException("html is marked non-null but is null");
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("logHtml {}, override: {}", (Object)html, (Object)override);
        }
        this.sendSynchronously(this.restApiClient::logHtml, RestApiUtils.createLogHtmlRequest(html, override));
    }

    @Override
    public void logOther(@NonNull String key, @NonNull Object value) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("logOther {} {}", (Object)key, value);
        }
        this.sendSynchronously(this.restApiClient::logOther, RestApiUtils.createLogOtherRequest(key, value));
    }

    @Override
    public void addTag(@NonNull String tag) {
        if (tag == null) {
            throw new NullPointerException("tag is marked non-null but is null");
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("addTag {}", (Object)tag);
        }
        this.sendSynchronously(this.restApiClient::addTag, RestApiUtils.createTagRequest(tag));
    }

    @Override
    public void logGraph(@NonNull String graph) {
        if (graph == null) {
            throw new NullPointerException("graph is marked non-null but is null");
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("logGraph {}", (Object)graph);
        }
        this.sendSynchronously(this.restApiClient::logGraph, RestApiUtils.createGraphRequest(graph));
    }

    @Override
    public void logStartTime(long startTimeMillis) {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("logStartTime {}", (Object)startTimeMillis);
        }
        this.sendSynchronously(this.restApiClient::logStartEndTime, RestApiUtils.createLogStartTimeRequest(startTimeMillis));
    }

    @Override
    public void logEndTime(long endTimeMillis) {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("logEndTime {}", (Object)endTimeMillis);
        }
        this.sendSynchronously(this.restApiClient::logStartEndTime, RestApiUtils.createLogEndTimeRequest(endTimeMillis));
    }

    @Override
    public void logGitMetadata(GitMetaData gitMetaData) {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("logGitMetadata {}", (Object)gitMetaData);
        }
        this.sendSynchronously(this.restApiClient::logGitMetadata, RestApiUtils.createGitMetadataRequest(gitMetaData));
    }

    @Override
    public void logCode(@NonNull String code, @NonNull String logicalPath, @NonNull ExperimentContext context) {
        if (code == null) {
            throw new NullPointerException("code is marked non-null but is null");
        }
        if (logicalPath == null) {
            throw new NullPointerException("logicalPath is marked non-null but is null");
        }
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("log raw source code, file name: {}", (Object)logicalPath);
        }
        AssetImpl asset = AssetUtils.createAssetFromData(code.getBytes(StandardCharsets.UTF_8), logicalPath, false, Optional.empty(), Optional.of(AssetType.SOURCE_CODE.type()));
        this.logAsset(asset, context);
    }

    @Override
    public void logCode(String code, String logicalPath) {
        this.logCode(code, logicalPath, ExperimentContext.empty());
    }

    @Override
    public void logCode(@NonNull File file, @NonNull ExperimentContext context) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("log source code from file {}", (Object)file.getName());
        }
        AssetImpl asset = AssetUtils.createAssetFromFile(file, Optional.empty(), false, Optional.empty(), Optional.of(AssetType.SOURCE_CODE.type()));
        this.logAsset(asset, context);
    }

    @Override
    public void logCode(File file) {
        this.logCode(file, ExperimentContext.empty());
    }

    @Override
    public void logText(@NonNull String text, @NonNull ExperimentContext context, Map<String, Object> metadata) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("logging text {} with context {}", (Object)text, (Object)context);
        }
        AssetImpl asset = AssetUtils.createAssetFromData(text.getBytes(StandardCharsets.UTF_8), "auto-generated-in-the-backend", false, Optional.ofNullable(metadata), Optional.of(AssetType.TEXT_SAMPLE.type()));
        this.logAsset(asset, context);
    }

    @Override
    public void logText(String text, @NonNull ExperimentContext context) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        this.logText(text, context, null);
    }

    @Override
    public void logText(String text) {
        this.logText(text, ExperimentContext.empty());
    }

    @Override
    public void logCurve(@NonNull Curve curve, boolean overwrite, @NonNull ExperimentContext context) {
        if (curve == null) {
            throw new NullPointerException("curve is marked non-null but is null");
        }
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("logging curve {} with context {}", (Object)curve, (Object)context);
        }
        AssetImpl asset = AssetUtils.createAssetFromCurve(curve, overwrite);
        this.logAsset(asset, context);
    }

    @Override
    public void logCurve(@NonNull Curve curve, boolean overwrite) {
        if (curve == null) {
            throw new NullPointerException("curve is marked non-null but is null");
        }
        this.logCurve(curve, overwrite, ExperimentContext.empty());
    }

    @Override
    public void logCurve(@NonNull Curve curve) {
        if (curve == null) {
            throw new NullPointerException("curve is marked non-null but is null");
        }
        this.logCurve(curve, false);
    }

    @Override
    public void uploadAsset(@NonNull File file, @NonNull String logicalPath, boolean overwrite, @NonNull ExperimentContext context) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        if (logicalPath == null) {
            throw new NullPointerException("logicalPath is marked non-null but is null");
        }
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("uploadAsset from file {}, name {}, override {}, context {}", new Object[]{file.getName(), logicalPath, overwrite, context});
        }
        AssetImpl asset = AssetUtils.createAssetFromFile(file, Optional.of(logicalPath), overwrite, Optional.empty(), Optional.empty());
        this.logAsset(asset, context);
    }

    @Override
    public void uploadAsset(@NonNull File asset, String logicalPath, boolean overwrite, long step, long epoch) {
        if (asset == null) {
            throw new NullPointerException("asset is marked non-null but is null");
        }
        this.uploadAsset(asset, logicalPath, overwrite, new ExperimentContext(step, epoch));
    }

    @Override
    public void uploadAsset(@NonNull File asset, boolean overwrite, @NonNull ExperimentContext context) {
        if (asset == null) {
            throw new NullPointerException("asset is marked non-null but is null");
        }
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        this.uploadAsset(asset, asset.getName(), overwrite, context);
    }

    @Override
    public void uploadAsset(@NonNull File asset, boolean overwrite, long step, long epoch) {
        if (asset == null) {
            throw new NullPointerException("asset is marked non-null but is null");
        }
        this.uploadAsset(asset, overwrite, new ExperimentContext(step, epoch));
    }

    void logAsset(@NonNull AssetImpl asset, @NonNull ExperimentContext context) {
        if (asset == null) {
            throw new NullPointerException("asset is marked non-null but is null");
        }
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        asset.setContext(context);
        this.sendSynchronously(this.restApiClient::logAsset, asset);
    }

    ArtifactEntry upsertArtifact(@NonNull Artifact artifact) throws ArtifactException {
        if (artifact == null) {
            throw new NullPointerException("artifact is marked non-null but is null");
        }
        try {
            ArtifactImpl artifactImpl = (ArtifactImpl)artifact;
            ArtifactRequest request = RestApiUtils.createArtifactUpsertRequest(artifactImpl);
            ArtifactEntry response = (ArtifactEntry)this.validateAndGetExperimentKey().concatMap(experimentKey -> this.getRestApiClient().upsertArtifact(request, (String)experimentKey)).blockingGet();
            if (StringUtils.isBlank((CharSequence)response.getPreviousVersion())) {
                this.getLogger().info(LogMessages.getString("ARTIFACT_VERSION_CREATED_WITHOUT_PREVIOUS", artifactImpl.getName(), response.getCurrentVersion()));
            } else {
                this.getLogger().info(LogMessages.getString("ARTIFACT_VERSION_CREATED_WITH_PREVIOUS", artifactImpl.getName(), response.getCurrentVersion(), response.getPreviousVersion()));
            }
            return response;
        }
        catch (Throwable e) {
            throw new ArtifactException(LogMessages.getString("FAILED_TO_UPSERT_ARTIFACT", artifact), e);
        }
    }

    void updateArtifactVersionState(@NonNull String artifactVersionId, @NonNull ArtifactVersionState state) throws ArtifactException {
        if (artifactVersionId == null) {
            throw new NullPointerException("artifactVersionId is marked non-null but is null");
        }
        if (state == null) {
            throw new NullPointerException("state is marked non-null but is null");
        }
        try {
            ArtifactRequest request = RestApiUtils.createArtifactVersionStateRequest(artifactVersionId, state);
            this.sendSynchronously(this.getRestApiClient()::updateArtifactState, request);
        }
        catch (Throwable e) {
            throw new ArtifactException(LogMessages.getString("FAILED_TO_UPDATE_ARTIFACT_VERSION_STATE", artifactVersionId), e);
        }
    }

    LoggedArtifact getArtifactVersionDetail(@NonNull GetArtifactOptions options) throws ArtifactNotFoundException, InvalidArtifactStateException, ArtifactException {
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        try {
            ArtifactVersionDetail detail = (ArtifactVersionDetail)this.validateAndGetExperimentKey().concatMap(experimentKey -> this.getRestApiClient().getArtifactVersionDetail(options, (String)experimentKey)).blockingGet();
            ArtifactDto artifactDto = detail.getArtifact();
            if (artifactDto == null) {
                throw new InvalidArtifactStateException(LogMessages.getString("ARTIFACT_HAS_NO_DETAILS", options));
            }
            return detail.copyToLoggedArtifact(new LoggedArtifactImpl(artifactDto.getArtifactName(), artifactDto.getArtifactType(), this));
        }
        catch (CometApiException apiException) {
            switch (apiException.getSdkErrorCode()) {
                case 624522: {
                    throw new ArtifactNotFoundException(LogMessages.getString("ARTIFACT_NOT_FOUND", options), apiException);
                }
                case 90402: 
                case 90403: {
                    throw new InvalidArtifactStateException(LogMessages.getString("ARTIFACT_NOT_READY", options), apiException);
                }
            }
            throw new ArtifactException(LogMessages.getString("GET_ARTIFACT_FAILED_UNEXPECTEDLY", options), apiException);
        }
        catch (Throwable e) {
            throw new ArtifactException(LogMessages.getString("GET_ARTIFACT_FAILED_UNEXPECTEDLY", options), e);
        }
    }

    @Override
    public LoggedArtifact getArtifact(@NonNull String name, @NonNull String workspace, @NonNull String versionOrAlias) throws ArtifactException {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (workspace == null) {
            throw new NullPointerException("workspace is marked non-null but is null");
        }
        if (versionOrAlias == null) {
            throw new NullPointerException("versionOrAlias is marked non-null but is null");
        }
        if (name.contains("/") || name.contains(":")) {
            throw new IllegalArgumentException("Only simple artifact name allowed for this method without slash (/) or colon (:) characters.");
        }
        return this.getArtifact(GetArtifactOptions.Op().name(name).workspaceName(workspace).versionOrAlias(versionOrAlias).consumerExperimentKey(this.experimentKey).build());
    }

    @Override
    public LoggedArtifact getArtifact(@NonNull String name, @NonNull String workspace) throws ArtifactException {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (workspace == null) {
            throw new NullPointerException("workspace is marked non-null but is null");
        }
        if (name.contains("/")) {
            throw new IllegalArgumentException("The name of artifact for this method should not include workspace or workspace separator (/).");
        }
        return this.getArtifact(GetArtifactOptions.Op().fullName(name).workspaceName(workspace).consumerExperimentKey(this.experimentKey).build());
    }

    @Override
    public LoggedArtifact getArtifact(@NonNull String name) throws ArtifactException {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return this.getArtifact(GetArtifactOptions.Op().fullName(name).consumerExperimentKey(this.experimentKey).build());
    }

    LoggedArtifact getArtifact(@NonNull GetArtifactOptions options) throws ArtifactException {
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        return this.getArtifactVersionDetail(options);
    }

    Collection<LoggedArtifactAsset> readArtifactAssets(@NonNull LoggedArtifactImpl artifact) throws ArtifactException {
        if (artifact == null) {
            throw new NullPointerException("artifact is marked non-null but is null");
        }
        GetArtifactOptions options = GetArtifactOptions.Op().artifactId(artifact.getArtifactId()).versionId(artifact.getVersionId()).build();
        try {
            ArtifactVersionAssetResponse response = (ArtifactVersionAssetResponse)this.getRestApiClient().getArtifactVersionFiles(options).blockingGet();
            return response.getFiles().stream().collect(ArrayList::new, (assets, artifactVersionAsset) -> assets.add(artifactVersionAsset.copyTo(new LoggedArtifactAssetImpl(artifact))), ArrayList::addAll);
        }
        catch (Throwable t) {
            String message = LogMessages.getString("FAILED_TO_READ_LOGGED_ARTIFACT_ASSETS", artifact.getFullName());
            this.getLogger().error(message, t);
            throw new ArtifactException(message, t);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    ArtifactAssetImpl downloadArtifactAsset(@NonNull LoggedArtifactAssetImpl asset, @NonNull Path dir, @NonNull Path file, @NonNull AssetOverwriteStrategy overwriteStrategy) throws ArtifactDownloadException {
        Path resolved;
        if (asset == null) {
            throw new NullPointerException("asset is marked non-null but is null");
        }
        if (dir == null) {
            throw new NullPointerException("dir is marked non-null but is null");
        }
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        if (overwriteStrategy == null) {
            throw new NullPointerException("overwriteStrategy is marked non-null but is null");
        }
        if (asset.isRemote()) {
            throw new ArtifactDownloadException(LogMessages.getString("REMOTE_ASSET_CANNOT_BE_DOWNLOADED", asset));
        }
        boolean fileAlreadyExists = false;
        try {
            Optional<Path> optionalPath = FileUtils.resolveAssetPath(dir, file, overwriteStrategy);
            if (!optionalPath.isPresent()) {
                Path resolved2 = dir.resolve(file);
                this.getLogger().warn(LogMessages.getString("ARTIFACT_ASSETS_FILE_EXISTS_PRESERVING", resolved2, asset.artifact.getFullName()));
                return new ArtifactAssetImpl(asset.getLogicalPath(), resolved2, Files.size(resolved2), asset.getMetadata(), asset.getAssetType());
            }
            resolved = optionalPath.get();
            if (overwriteStrategy == AssetOverwriteStrategy.OVERWRITE) {
                this.getLogger().warn(LogMessages.getString("ARTIFACT_DOWNLOAD_FILE_OVERWRITTEN", resolved, asset.getLogicalPath(), asset.artifact.getFullName()));
            }
        }
        catch (FileAlreadyExistsException e) {
            if (overwriteStrategy != AssetOverwriteStrategy.FAIL_IF_DIFFERENT) {
                this.getLogger().error(LogMessages.getString("FAILED_TO_DOWNLOAD_ASSET_FILE_ALREADY_EXISTS", asset, file), (Throwable)e);
                throw new ArtifactDownloadException(LogMessages.getString("FAILED_TO_DOWNLOAD_ASSET_FILE_ALREADY_EXISTS", asset, file), e);
            }
            try {
                resolved = Files.createTempFile(asset.getLogicalPath(), null, new FileAttribute[0]);
                this.getLogger().debug("File '{}' already exists for asset {} and FAIL override strategy selected. Start downloading to the temporary file '{}'", new Object[]{file, asset, resolved});
            }
            catch (IOException ex) {
                String msg = LogMessages.getString("FAILED_TO_CREATE_TEMPORARY_ASSET_DOWNLOAD_FILE", file, asset);
                this.getLogger().error(msg, (Throwable)ex);
                throw new ArtifactDownloadException(msg, ex);
            }
            fileAlreadyExists = true;
        }
        catch (IOException e) {
            this.getLogger().error(LogMessages.getString("FAILED_TO_RESOLVE_ASSET_FILE", file, asset), (Throwable)e);
            throw new ArtifactDownloadException(LogMessages.getString("FAILED_TO_RESOLVE_ASSET_FILE", file, asset), e);
        }
        DownloadArtifactAssetOptions opts = new DownloadArtifactAssetOptions(asset.getAssetId(), asset.getArtifactVersionId(), resolved.toFile());
        RestApiResponse response = (RestApiResponse)this.validateAndGetExperimentKey().concatMap(experimentKey -> this.getRestApiClient().downloadArtifactAsset(opts, (String)experimentKey)).blockingGet();
        if (response.hasFailed()) {
            this.getLogger().error(LogMessages.getString("FAILED_TO_DOWNLOAD_ASSET", asset, response));
            throw new ArtifactDownloadException(LogMessages.getString("FAILED_TO_DOWNLOAD_ASSET", asset, response));
        }
        if (fileAlreadyExists) {
            Path assetFilePath = FileUtils.assetFilePath(dir, file);
            try {
                if (!FileUtils.fileContentsEquals(assetFilePath, resolved)) {
                    this.getLogger().error(LogMessages.getString("FAILED_TO_DOWNLOAD_ASSET_FILE_ALREADY_EXISTS", asset, file));
                    throw new ArtifactDownloadException(LogMessages.getString("FAILED_TO_DOWNLOAD_ASSET_FILE_ALREADY_EXISTS", asset, file));
                }
            }
            catch (IOException e) {
                try {
                    this.getLogger().error(LogMessages.getString("FAILED_TO_COMPARE_CONTENT_OF_FILES", file, resolved), (Throwable)e);
                    throw new ArtifactDownloadException(LogMessages.getString("FAILED_TO_COMPARE_CONTENT_OF_FILES", file, resolved), e);
                }
                catch (Throwable throwable) {
                    try {
                        Files.deleteIfExists(resolved);
                        throw throwable;
                    }
                    catch (IOException e2) {
                        this.getLogger().error(LogMessages.getString("FAILED_TO_DELETE_TEMPORARY_ASSET_FILE", resolved, asset), (Throwable)e2);
                    }
                    throw throwable;
                }
            }
            try {
                Files.deleteIfExists(resolved);
            }
            catch (IOException e) {
                this.getLogger().error(LogMessages.getString("FAILED_TO_DELETE_TEMPORARY_ASSET_FILE", resolved, asset), (Throwable)e);
            }
            resolved = assetFilePath;
        }
        this.getLogger().info(LogMessages.getString("COMPLETED_DOWNLOAD_ARTIFACT_ASSET", asset.getLogicalPath(), resolved));
        try {
            return new ArtifactAssetImpl(asset.getLogicalPath(), resolved, Files.size(resolved), asset.getMetadata(), asset.getAssetType());
        }
        catch (IOException e) {
            this.getLogger().error(LogMessages.getString("FAILED_TO_READ_DOWNLOADED_FILE_SIZE", resolved), (Throwable)e);
            throw new ArtifactDownloadException(LogMessages.getString("FAILED_TO_READ_DOWNLOADED_FILE_SIZE", resolved), e);
        }
    }

    @Override
    public ExperimentMetadata getMetadata() {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("get metadata for experiment {}", (Object)this.experimentKey);
        }
        return ((ExperimentMetadataRest)this.loadRemote(this.restApiClient::getExperimentMetadata, "METADATA")).toExperimentMetadata();
    }

    @Override
    public GitMetaData getGitMetadata() {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("get git metadata for experiment {}", (Object)this.experimentKey);
        }
        return ((GitMetadataRest)this.loadRemote(this.restApiClient::getGitMetadata, "GIT METADATA")).toGitMetaData();
    }

    @Override
    public Optional<String> getHtml() {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("get html for experiment {}", (Object)this.experimentKey);
        }
        return Optional.ofNullable(((GetHtmlResponse)this.loadRemote(this.restApiClient::getHtml, "HTML")).getHtml());
    }

    @Override
    public Optional<String> getOutput() {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("get output for experiment {}", (Object)this.experimentKey);
        }
        return Optional.ofNullable(((GetOutputResponse)this.loadRemote(this.restApiClient::getOutput, "StdOut")).getOutput());
    }

    @Override
    public Optional<String> getGraph() {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("get graph for experiment {}", (Object)this.experimentKey);
        }
        return Optional.ofNullable(((GetGraphResponse)this.loadRemote(this.restApiClient::getGraph, "GRAPH")).getGraph());
    }

    @Override
    public List<Value> getParameters() {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("get params for experiment {}", (Object)this.experimentKey);
        }
        return this.loadRemoteValues((Function<String, Single<MinMaxResponse>>)((Function)this.restApiClient::getParameters), "PARAMETERS");
    }

    @Override
    public List<Value> getMetrics() {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("get metrics summary for experiment {}", (Object)this.experimentKey);
        }
        return this.loadRemoteValues((Function<String, Single<MinMaxResponse>>)((Function)this.restApiClient::getMetrics), "METRICS");
    }

    @Override
    public List<Value> getLogOther() {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("get log other for experiment {}", (Object)this.experimentKey);
        }
        return this.loadRemoteValues((Function<String, Single<MinMaxResponse>>)((Function)this.restApiClient::getLogOther), "OTHER PARAMETERS");
    }

    @Override
    public List<String> getTags() {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("get tags for experiment {}", (Object)this.experimentKey);
        }
        return ((TagsResponse)this.loadRemote(this.restApiClient::getTags, "TAGs")).getTags();
    }

    @Override
    public List<LoggedExperimentAsset> getAssetList(@NonNull String type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("get assets with type {} for experiment {}", (Object)type, (Object)this.experimentKey);
        }
        return ((ExperimentAssetListResponse)this.validateAndGetExperimentKey().concatMap(experimentKey -> this.restApiClient.getAssetList((String)experimentKey, type)).doOnError(ex -> this.getLogger().error("Failed to read ASSETS list for the experiment, experiment key: {}", (Object)this.experimentKey, ex)).blockingGet()).getAssets().stream().collect(ArrayList::new, (assets, experimentAssetLink) -> assets.add(experimentAssetLink.toExperimentAsset(this.getLogger())), ArrayList::addAll);
    }

    @Override
    public List<LoggedExperimentAsset> getAllAssetList() {
        return this.getAssetList(AssetType.ALL.type());
    }

    @Override
    public void end() {
        if (!this.alive) {
            return;
        }
        this.alive = false;
        if (this.restApiClient != null) {
            this.restApiClient.dispose();
        }
        if (this.connection != null) {
            try {
                this.connection.waitAndClose(this.cleaningTimeout);
                this.connection = null;
            }
            catch (Exception e) {
                this.getLogger().error("failed to close connection", (Throwable)e);
            }
        }
    }

    Optional<ExperimentStatusResponse> sendExperimentStatus() {
        if (!this.alive) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.validateAndGetExperimentKey().concatMap(experimentKey -> this.restApiClient.sendExperimentStatus((String)experimentKey)).onErrorComplete().blockingGet());
    }

    private List<Value> loadRemoteValues(Function<String, Single<MinMaxResponse>> loadFunc, String alias) {
        return this.loadRemote(loadFunc, alias).getValues().stream().collect(ArrayList::new, (values, valueMinMaxRest) -> values.add(valueMinMaxRest.toValue()), ArrayList::addAll);
    }

    private <T> T loadRemote(Function<String, Single<T>> loadFunc, String alias) {
        return (T)this.validateAndGetExperimentKey().concatMap(loadFunc).doOnError(ex -> this.getLogger().error(LogMessages.getString("FAILED_READ_DATA_FOR_EXPERIMENT", alias, this.experimentKey), ex)).blockingGet();
    }

    private <T> void sendSynchronously(BiFunction<T, String, Single<RestApiResponse>> func, T request) throws CometApiException {
        CompletableFuture future = new CompletableFuture();
        Disposable disposable = this.validateAndGetExperimentKey().concatMap(experimentKey -> (Single)func.apply(request, experimentKey)).subscribe(future::complete, future::completeExceptionally);
        try {
            RestApiResponse response = (RestApiResponse)future.get();
            if (response.hasFailed()) {
                throw new CometApiException("Failed to log {}, reason: %s, sdk error code: %d", request, response.getMsg(), response.getSdkErrorCode());
            }
        }
        catch (InterruptedException | ExecutionException e) {
            Throwable rootCause = ExceptionUtils.unwrap(e);
            if (rootCause instanceof CometApiException) {
                throw (CometApiException)rootCause;
            }
            throw new RuntimeException(e);
        }
        finally {
            disposable.dispose();
        }
    }

    private void validate() throws IllegalStateException {
        if (StringUtils.isBlank((CharSequence)this.experimentKey)) {
            throw new IllegalStateException("Experiment key must be present!");
        }
        if (!this.alive) {
            throw new IllegalStateException("Experiment was not initialized. You need to call init().");
        }
    }

    Single<String> validateAndGetExperimentKey() {
        if (StringUtils.isBlank((CharSequence)this.experimentKey)) {
            return Single.error((Throwable)new IllegalStateException("Experiment key must be present!"));
        }
        if (!this.alive) {
            return Single.error((Throwable)new IllegalStateException("Experiment is not alive or already closed."));
        }
        return Single.just((Object)this.getExperimentKey());
    }

    public RestApiClient getRestApiClient() {
        return this.restApiClient;
    }

    public Connection getConnection() {
        return this.connection;
    }
}

