/*
 * Decompiled with CFR 0.152.
 */
package ml.comet.experiment.impl;

import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.Single;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.zip.ZipInputStream;
import lombok.NonNull;
import ml.comet.experiment.CometApi;
import ml.comet.experiment.ExperimentNotFoundException;
import ml.comet.experiment.builder.BaseCometBuilder;
import ml.comet.experiment.builder.CometApiBuilder;
import ml.comet.experiment.exception.CometApiException;
import ml.comet.experiment.impl.RegistryModelImpl;
import ml.comet.experiment.impl.RestApiClient;
import ml.comet.experiment.impl.config.CometConfig;
import ml.comet.experiment.impl.http.Connection;
import ml.comet.experiment.impl.http.ConnectionInitializer;
import ml.comet.experiment.impl.resources.LogMessages;
import ml.comet.experiment.impl.rest.ExperimentMetadataRest;
import ml.comet.experiment.impl.rest.ExperimentModelListResponse;
import ml.comet.experiment.impl.rest.ExperimentModelResponse;
import ml.comet.experiment.impl.rest.GetExperimentsResponse;
import ml.comet.experiment.impl.rest.GetProjectsResponse;
import ml.comet.experiment.impl.rest.GetWorkspacesResponse;
import ml.comet.experiment.impl.rest.RegistryModelCreateRequest;
import ml.comet.experiment.impl.rest.RegistryModelCreateResponse;
import ml.comet.experiment.impl.rest.RegistryModelDetailsResponse;
import ml.comet.experiment.impl.rest.RegistryModelItemCreateRequest;
import ml.comet.experiment.impl.rest.RegistryModelItemCreateResponse;
import ml.comet.experiment.impl.rest.RegistryModelNotesResponse;
import ml.comet.experiment.impl.rest.RegistryModelNotesUpdateRequest;
import ml.comet.experiment.impl.rest.RegistryModelOverviewListResponse;
import ml.comet.experiment.impl.rest.RegistryModelUpdateItemRequest;
import ml.comet.experiment.impl.rest.RegistryModelUpdateRequest;
import ml.comet.experiment.impl.rest.RestApiResponse;
import ml.comet.experiment.impl.utils.CometUtils;
import ml.comet.experiment.impl.utils.ExceptionUtils;
import ml.comet.experiment.impl.utils.ModelUtils;
import ml.comet.experiment.impl.utils.RestApiUtils;
import ml.comet.experiment.impl.utils.ZipUtils;
import ml.comet.experiment.model.ExperimentMetadata;
import ml.comet.experiment.model.Project;
import ml.comet.experiment.registrymodel.DownloadModelOptions;
import ml.comet.experiment.registrymodel.Model;
import ml.comet.experiment.registrymodel.ModelDownloadInfo;
import ml.comet.experiment.registrymodel.ModelNotFoundException;
import ml.comet.experiment.registrymodel.ModelOverview;
import ml.comet.experiment.registrymodel.ModelRegistryRecord;
import ml.comet.experiment.registrymodel.ModelVersionNotFoundException;
import ml.comet.experiment.registrymodel.ModelVersionOverview;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CometApiImpl
implements CometApi {
    private Logger logger = LoggerFactory.getLogger(CometApiImpl.class);
    private final String apiKey;
    private final String baseUrl;
    private final int maxAuthRetries;
    private RestApiClient restApiClient;
    private Connection connection;

    CometApiImpl(@NonNull String apiKey, @NonNull String baseUrl, int maxAuthRetries, Logger logger) {
        if (apiKey == null) {
            throw new NullPointerException("apiKey is marked non-null but is null");
        }
        if (baseUrl == null) {
            throw new NullPointerException("baseUrl is marked non-null but is null");
        }
        this.apiKey = apiKey;
        this.baseUrl = baseUrl;
        this.maxAuthRetries = maxAuthRetries;
        if (logger != null) {
            this.logger = logger;
        }
    }

    @Override
    public List<String> getAllWorkspaces() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("getAllWorkspaces invoked");
        }
        return ((GetWorkspacesResponse)this.restApiClient.getAllWorkspaces().doOnError(ex -> this.logger.error("Failed to read workspaces for the current user", ex)).blockingGet()).getWorkspaceNames();
    }

    @Override
    public List<Project> getAllProjects(@NonNull String workspaceName) {
        if (workspaceName == null) {
            throw new NullPointerException("workspaceName is marked non-null but is null");
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("getAllProjects invoked");
        }
        return ((GetProjectsResponse)this.restApiClient.getAllProjects(workspaceName).doOnError(ex -> this.logger.error("Failed to read projects in the workspace {}", (Object)workspaceName, ex)).blockingGet()).getProjects().stream().collect(ArrayList::new, (projects, restProject) -> projects.add(restProject.toProject()), ArrayList::addAll);
    }

    @Override
    public List<ExperimentMetadata> getAllExperiments(@NonNull String projectId) {
        if (projectId == null) {
            throw new NullPointerException("projectId is marked non-null but is null");
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("getAllExperiments invoked");
        }
        return ((GetExperimentsResponse)this.restApiClient.getAllExperiments(projectId).doOnError(ex -> this.logger.error("Failed to read experiments found in the project {}", (Object)projectId, ex)).blockingGet()).getExperiments().stream().collect(ArrayList::new, (metadataList, metadataRest) -> metadataList.add(metadataRest.toExperimentMetadata()), ArrayList::addAll);
    }

    @Override
    public List<ExperimentMetadata> getExperiments(@NonNull String workspaceName, @NonNull String projectName) {
        if (workspaceName == null) {
            throw new NullPointerException("workspaceName is marked non-null but is null");
        }
        if (projectName == null) {
            throw new NullPointerException("projectName is marked non-null but is null");
        }
        return ((GetExperimentsResponse)this.restApiClient.getAllExperiments(projectName, workspaceName).doOnError(ex -> this.logger.error("Failed to read experiments found in the project {} of workspace {}", new Object[]{projectName, workspaceName, ex})).blockingGet()).getExperiments().stream().collect(ArrayList::new, (metadataList, metadataRest) -> metadataList.add(metadataRest.toExperimentMetadata()), ArrayList::addAll);
    }

    @Override
    public List<ExperimentMetadata> getExperiments(@NonNull String workspaceName) {
        if (workspaceName == null) {
            throw new NullPointerException("workspaceName is marked non-null but is null");
        }
        return this.getAllProjects(workspaceName).stream().map(project -> this.getAllExperiments(project.getProjectId())).collect(ArrayList::new, ArrayList::addAll, ArrayList::addAll);
    }

    @Override
    public List<ExperimentMetadata> getExperiments(@NonNull String workspaceName, String projectName, String experimentNamePattern) {
        if (workspaceName == null) {
            throw new NullPointerException("workspaceName is marked non-null but is null");
        }
        if (StringUtils.isBlank((CharSequence)projectName)) {
            if (!StringUtils.isBlank((CharSequence)experimentNamePattern)) {
                throw new IllegalArgumentException("you must specify projectName when experimentNamePattern is provided");
            }
            return this.getExperiments(workspaceName);
        }
        if (StringUtils.isBlank((CharSequence)experimentNamePattern)) {
            return this.getExperiments(workspaceName, projectName);
        }
        Pattern p = Pattern.compile(experimentNamePattern);
        return this.getExperiments(workspaceName, projectName).stream().filter(experimentMetadata -> {
            if (StringUtils.isEmpty((CharSequence)experimentMetadata.getExperimentName())) {
                return false;
            }
            return p.matcher(experimentMetadata.getExperimentName()).matches();
        }).collect(Collectors.toList());
    }

    @Override
    public ExperimentMetadata getExperimentMetadata(@NonNull String experimentKey) throws ExperimentNotFoundException {
        if (experimentKey == null) {
            throw new NullPointerException("experimentKey is marked non-null but is null");
        }
        try {
            return ((ExperimentMetadataRest)this.restApiClient.getExperimentMetadata(experimentKey).blockingGet()).toExperimentMetadata();
        }
        catch (CometApiException ex) {
            if (ex.getStatusCode() == 400) {
                throw new ExperimentNotFoundException(LogMessages.getString("EXPERIMENT_WITH_KEY_NOT_FOUND", experimentKey));
            }
            throw ex;
        }
    }

    @Override
    public ModelRegistryRecord registerModel(@NonNull Model model, @NonNull String experimentKey) {
        ModelRegistryRecord registry;
        if (model == null) {
            throw new NullPointerException("model is marked non-null but is null");
        }
        if (experimentKey == null) {
            throw new NullPointerException("experimentKey is marked non-null but is null");
        }
        List experimentModels = (List)this.restApiClient.getExperimentModels(experimentKey).map(ExperimentModelListResponse::getModels).blockingGet();
        if (experimentModels == null || experimentModels.size() == 0) {
            throw new ModelNotFoundException(LogMessages.getString("EXPERIMENT_HAS_NO_MODELS", experimentKey));
        }
        Optional<ExperimentModelResponse> details = experimentModels.stream().filter(modelResponse -> Objects.equals(modelResponse.getModelName(), model.getName())).findFirst();
        if (!details.isPresent()) {
            String names = experimentModels.stream().map(ExperimentModelResponse::getModelName).collect(Collectors.joining(", "));
            throw new ModelNotFoundException(LogMessages.getString("FAILED_TO_FIND_EXPERIMENT_MODEL_BY_NAME", model.getName(), names));
        }
        RegistryModelImpl modelImpl = (RegistryModelImpl)model;
        modelImpl.setExperimentModelId(details.get().getExperimentModelId());
        Boolean modelInRegistry = (Boolean)this.restApiClient.getExperimentMetadata(experimentKey).concatMap(experimentMetadataRest -> {
            modelImpl.setWorkspace(experimentMetadataRest.getWorkspaceName());
            return this.restApiClient.getRegistryModelsForWorkspace(experimentMetadataRest.getWorkspaceName());
        }).map(RegistryModelOverviewListResponse::getRegistryModels).flatMapObservable(Observable::fromIterable).any(registryModel -> Objects.equals(registryModel.getModelName(), model.getRegistryName())).blockingGet();
        if (modelInRegistry.booleanValue()) {
            if (StringUtils.isNotBlank((CharSequence)modelImpl.getDescription())) {
                this.logger.warn(LogMessages.getString("UPDATE_REGISTRY_MODEL_DESCRIPTION_IGNORED"));
            }
            if (modelImpl.getIsPublic() != null) {
                this.logger.warn(LogMessages.getString("UPDATE_REGISTRY_MODEL_IS_PUBLIC_IGNORED"));
            }
            RegistryModelItemCreateRequest request = RestApiUtils.createRegistryModelItemCreateRequest(modelImpl);
            registry = ((RegistryModelItemCreateResponse)this.restApiClient.createRegistryModelItem(request).blockingGet()).toModelRegistry();
            this.logger.info(LogMessages.getString("MODEL_VERSION_CREATED_IN_WORKSPACE", model.getVersion(), model.getRegistryName(), model.getWorkspace()));
        } else {
            RegistryModelCreateRequest request = RestApiUtils.createRegistryModelCreateRequest(modelImpl);
            registry = ((RegistryModelCreateResponse)this.restApiClient.createRegistryModel(request).blockingGet()).toModelRegistry();
            this.logger.info(LogMessages.getString("MODEL_REGISTERED_IN_WORKSPACE", model.getRegistryName(), model.getVersion(), model.getWorkspace()));
        }
        registry.setRegistryName(model.getRegistryName());
        return registry;
    }

    @Override
    public ModelDownloadInfo downloadRegistryModel(@NonNull Path outputPath, @NonNull String registryName, @NonNull String workspace, @NonNull DownloadModelOptions options) throws IOException {
        ModelDownloadInfo info;
        RestApiResponse response;
        if (outputPath == null) {
            throw new NullPointerException("outputPath is marked non-null but is null");
        }
        if (registryName == null) {
            throw new NullPointerException("registryName is marked non-null but is null");
        }
        if (workspace == null) {
            throw new NullPointerException("workspace is marked non-null but is null");
        }
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        this.logger.info(LogMessages.getString("DOWNLOADING_REGISTRY_MODEL_PROMPT", registryName, options.getVersion(), options.getStage(), workspace));
        if (!options.isExpand()) {
            String fileName = ModelUtils.registryModelZipFileName(registryName, options);
            Path filePath = outputPath.resolve(fileName);
            this.logger.info(LogMessages.getString("DOWNLOADING_REGISTRY_MODEL_TO_FILE", filePath));
            response = this.downloadRegistryModelToFile(filePath, workspace, registryName, options);
            info = new ModelDownloadInfo(filePath, options);
        } else {
            this.logger.info(LogMessages.getString("DOWNLOADING_REGISTRY_MODEL_TO_DIR", outputPath));
            response = this.downloadRegistryModelToDir(outputPath, workspace, registryName, options);
            info = new ModelDownloadInfo(outputPath, options);
        }
        if (response.hasFailed()) {
            this.logger.info(LogMessages.getString("FAILED_TO_DOWNLOAD_REGISTRY_MODEL", response.getMsg(), response.getSdkErrorCode()));
            throw new CometApiException(LogMessages.getString("FAILED_TO_DOWNLOAD_REGISTRY_MODEL", response.getMsg(), response.getSdkErrorCode()));
        }
        return info;
    }

    @Override
    public ModelDownloadInfo downloadRegistryModel(@NonNull Path outputPath, @NonNull String registryName, @NonNull String workspace) throws IOException {
        if (outputPath == null) {
            throw new NullPointerException("outputPath is marked non-null but is null");
        }
        if (registryName == null) {
            throw new NullPointerException("registryName is marked non-null but is null");
        }
        if (workspace == null) {
            throw new NullPointerException("workspace is marked non-null but is null");
        }
        return this.downloadRegistryModel(outputPath, registryName, workspace, DownloadModelOptions.Op().build());
    }

    @Override
    public Optional<ModelOverview> getRegistryModelDetails(@NonNull String registryName, @NonNull String workspace) {
        if (registryName == null) {
            throw new NullPointerException("registryName is marked non-null but is null");
        }
        if (workspace == null) {
            throw new NullPointerException("workspace is marked non-null but is null");
        }
        try {
            RegistryModelDetailsResponse details = (RegistryModelDetailsResponse)this.restApiClient.getRegistryModelDetails(registryName, workspace).blockingGet();
            return Optional.of(details.toModelOverview(this.logger));
        }
        catch (CometApiException ex) {
            this.logger.error(LogMessages.getString("FAILED_TO_GET_REGISTRY_MODEL_DETAILS", workspace, registryName, ex.getStatusMessage(), ex.getSdkErrorCode()), (Throwable)ex);
            if (ex.getSdkErrorCode() == 42008) {
                return Optional.empty();
            }
            throw ex;
        }
    }

    @Override
    public Optional<ModelVersionOverview> getRegistryModelVersion(@NonNull String registryName, @NonNull String workspace, @NonNull String version) {
        if (registryName == null) {
            throw new NullPointerException("registryName is marked non-null but is null");
        }
        if (workspace == null) {
            throw new NullPointerException("workspace is marked non-null but is null");
        }
        if (version == null) {
            throw new NullPointerException("version is marked non-null but is null");
        }
        Optional<ModelOverview> overviewOptional = this.getRegistryModelDetails(registryName, workspace);
        if (!overviewOptional.isPresent()) {
            return Optional.empty();
        }
        ModelOverview overview = overviewOptional.get();
        if (overview.getVersions() == null || overview.getVersions().size() == 0) {
            String msg = LogMessages.getString("FAILED_TO_GET_REGISTRY_MODEL_VERSIONS", workspace, registryName);
            this.logger.error(msg);
            throw new ModelNotFoundException(msg);
        }
        return overview.getVersions().stream().filter(versionOverview -> Objects.equals(versionOverview.getVersion(), version)).findFirst();
    }

    @Override
    public List<String> getRegistryModelNames(@NonNull String workspace) {
        if (workspace == null) {
            throw new NullPointerException("workspace is marked non-null but is null");
        }
        RegistryModelOverviewListResponse listResponse = (RegistryModelOverviewListResponse)this.restApiClient.getRegistryModelsForWorkspace(workspace).blockingGet();
        if (listResponse.getRegistryModels() == null) {
            this.logger.info(LogMessages.getString("WORKSPACE_HAS_NO_REGISTRY_MODELS", workspace));
            return Collections.emptyList();
        }
        return listResponse.getRegistryModels().stream().collect(ArrayList::new, (strings, registryModelOverview) -> strings.add(registryModelOverview.getModelName()), ArrayList::addAll);
    }

    @Override
    public List<String> getRegistryModelVersions(@NonNull String registryName, @NonNull String workspace) {
        if (registryName == null) {
            throw new NullPointerException("registryName is marked non-null but is null");
        }
        if (workspace == null) {
            throw new NullPointerException("workspace is marked non-null but is null");
        }
        Optional<ModelOverview> overviewOptional = this.getRegistryModelDetails(registryName, workspace);
        if (!overviewOptional.isPresent()) {
            this.logger.warn(LogMessages.getString("REGISTRY_MODEL_NOT_FOUND", workspace, registryName));
            return Collections.emptyList();
        }
        List<ModelVersionOverview> versions = overviewOptional.get().getVersions();
        if (versions == null) {
            this.logger.warn(LogMessages.getString("FAILED_TO_GET_REGISTRY_MODEL_VERSIONS", workspace, registryName));
            return Collections.emptyList();
        }
        return versions.stream().collect(ArrayList::new, (strings, modelVersionOverview) -> strings.add(modelVersionOverview.getVersion()), ArrayList::addAll);
    }

    @Override
    public void updateRegistryModelNotes(@NonNull String notes, @NonNull String registryName, @NonNull String workspace) {
        if (notes == null) {
            throw new NullPointerException("notes is marked non-null but is null");
        }
        if (registryName == null) {
            throw new NullPointerException("registryName is marked non-null but is null");
        }
        if (workspace == null) {
            throw new NullPointerException("workspace is marked non-null but is null");
        }
        RegistryModelNotesUpdateRequest request = RestApiUtils.createRegistryModelNotesUpdateRequest(notes, registryName, workspace);
        String errorMsg = LogMessages.getString("FAILED_TO_UPDATE_REGISTRY_MODEL_NOTES", workspace, registryName);
        RestApiResponse response = this.executeSyncRequest(this.restApiClient::updateRegistryModelNotes, request, errorMsg);
        this.checkRestApiResponse(response, errorMsg);
    }

    @Override
    public Optional<String> getRegistryModelNotes(@NonNull String registryName, @NonNull String workspace) {
        if (registryName == null) {
            throw new NullPointerException("registryName is marked non-null but is null");
        }
        if (workspace == null) {
            throw new NullPointerException("workspace is marked non-null but is null");
        }
        try {
            RegistryModelNotesResponse response = (RegistryModelNotesResponse)this.restApiClient.getRegistryModelNotes(registryName, workspace).blockingGet();
            return Optional.ofNullable(response.getNotes());
        }
        catch (CometApiException ex) {
            this.logger.error(LogMessages.getString("FAILED_TO_GET_REGISTRY_MODEL_NOTES", workspace, registryName, ex.getStatusMessage(), ex.getSdkErrorCode()), (Throwable)ex);
            if (ex.getSdkErrorCode() == 42008) {
                return Optional.empty();
            }
            throw ex;
        }
    }

    @Override
    public void updateRegistryModel(@NonNull String registryName, @NonNull String workspace, String newRegistryName, String newDescription, boolean isPublic) throws ModelNotFoundException {
        if (registryName == null) {
            throw new NullPointerException("registryName is marked non-null but is null");
        }
        if (workspace == null) {
            throw new NullPointerException("workspace is marked non-null but is null");
        }
        this.updateRegistryModel(registryName, workspace, RestApiUtils.createRegistryModelUpdateRequest(newRegistryName, newDescription, isPublic));
    }

    @Override
    public void updateRegistryModel(@NonNull String registryName, @NonNull String workspace, String newRegistryName, String newDescription) throws ModelNotFoundException {
        if (registryName == null) {
            throw new NullPointerException("registryName is marked non-null but is null");
        }
        if (workspace == null) {
            throw new NullPointerException("workspace is marked non-null but is null");
        }
        this.updateRegistryModel(registryName, workspace, RestApiUtils.createRegistryModelUpdateRequest(newRegistryName, newDescription, null));
    }

    @Override
    public void updateRegistryModel(@NonNull String registryName, @NonNull String workspace, String newRegistryName) throws ModelNotFoundException {
        if (registryName == null) {
            throw new NullPointerException("registryName is marked non-null but is null");
        }
        if (workspace == null) {
            throw new NullPointerException("workspace is marked non-null but is null");
        }
        this.updateRegistryModel(registryName, workspace, RestApiUtils.createRegistryModelUpdateRequest(newRegistryName, null, null));
    }

    private void updateRegistryModel(@NonNull String registryName, @NonNull String workspace, @NonNull RegistryModelUpdateRequest request) {
        if (registryName == null) {
            throw new NullPointerException("registryName is marked non-null but is null");
        }
        if (workspace == null) {
            throw new NullPointerException("workspace is marked non-null but is null");
        }
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        Optional<ModelOverview> overviewOptional = this.getRegistryModelDetails(registryName, workspace);
        if (!overviewOptional.isPresent()) {
            throw new ModelNotFoundException(LogMessages.getString("REGISTRY_MODEL_NOT_FOUND", workspace, registryName));
        }
        request.setRegistryModelId(overviewOptional.get().getRegistryModelId());
        String errorMsg = LogMessages.getString("FAILED_TO_UPDATE_REGISTRY_MODEL", workspace, registryName, request);
        RestApiResponse response = this.executeSyncRequest(this.restApiClient::updateRegistryModel, request, errorMsg);
        this.checkRestApiResponse(response, errorMsg);
    }

    @Override
    public void updateRegistryModelVersion(@NonNull String registryName, @NonNull String workspace, @NonNull String version, String comments, List<String> stages) {
        if (registryName == null) {
            throw new NullPointerException("registryName is marked non-null but is null");
        }
        if (workspace == null) {
            throw new NullPointerException("workspace is marked non-null but is null");
        }
        if (version == null) {
            throw new NullPointerException("version is marked non-null but is null");
        }
        Optional<ModelVersionOverview> versionOverviewOptional = this.getRegistryModelVersion(registryName, workspace, version);
        if (!versionOverviewOptional.isPresent()) {
            throw new ModelVersionNotFoundException(LogMessages.getString("REGISTRY_MODEL_VERSION_NOT_FOUND", version, workspace, registryName));
        }
        RegistryModelUpdateItemRequest request = new RegistryModelUpdateItemRequest();
        request.setRegistryModelItemId(versionOverviewOptional.get().getRegistryModelItemId());
        request.setComment(comments);
        request.setStages(stages);
        String errorMsg = LogMessages.getString("FAILED_TO_UPDATE_REGISTRY_MODEL_VERSION", workspace, registryName, version, request);
        RestApiResponse response = this.executeSyncRequest(this.restApiClient::updateRegistryModelVersion, request, errorMsg);
        this.checkRestApiResponse(response, errorMsg);
    }

    @Override
    public void updateRegistryModelVersion(String registryName, String workspace, String version, String comments) {
        this.updateRegistryModelVersion(registryName, workspace, version, null, null);
    }

    @Override
    public void deleteRegistryModel(@NonNull String registryName, @NonNull String workspace) {
        if (registryName == null) {
            throw new NullPointerException("registryName is marked non-null but is null");
        }
        if (workspace == null) {
            throw new NullPointerException("workspace is marked non-null but is null");
        }
        RestApiResponse response = (RestApiResponse)this.restApiClient.deleteRegistryModel(registryName, workspace).blockingGet();
        this.checkRestApiResponse(response, LogMessages.getString("FAILED_TO_DELETE_REGISTRY_MODEL", registryName, workspace));
    }

    @Override
    public void deleteRegistryModelVersion(@NonNull String registryName, @NonNull String workspace, @NonNull String version) {
        if (registryName == null) {
            throw new NullPointerException("registryName is marked non-null but is null");
        }
        if (workspace == null) {
            throw new NullPointerException("workspace is marked non-null but is null");
        }
        if (version == null) {
            throw new NullPointerException("version is marked non-null but is null");
        }
        Optional<ModelVersionOverview> versionOverviewOptional = this.getRegistryModelVersion(registryName, workspace, version);
        if (!versionOverviewOptional.isPresent()) {
            throw new ModelVersionNotFoundException(LogMessages.getString("REGISTRY_MODEL_VERSION_NOT_FOUND", version, workspace, registryName));
        }
        String errorMsg = LogMessages.getString("FAILED_TO_DELETE_REGISTRY_MODEL_VERSION", workspace, registryName, version);
        RestApiResponse response = this.executeSyncRequest(this.restApiClient::deleteRegistryModelVersion, versionOverviewOptional.get().getRegistryModelItemId(), errorMsg);
        this.checkRestApiResponse(response, errorMsg);
    }

    @Override
    public void close() throws IOException {
        if (Objects.nonNull(this.restApiClient)) {
            this.restApiClient.dispose();
        }
        if (Objects.nonNull(this.connection)) {
            this.connection.close();
        }
    }

    void init() {
        CometUtils.printCometSdkVersion();
        this.connection = ConnectionInitializer.initConnection(this.apiKey, this.baseUrl, this.maxAuthRetries, this.logger);
        this.restApiClient = new RestApiClient(this.connection);
    }

    RestApiClient getRestApiClient() {
        return this.restApiClient;
    }

    RestApiResponse downloadRegistryModelToFile(@NonNull Path filePath, @NonNull String workspace, @NonNull String registryName, @NonNull DownloadModelOptions options) throws IOException {
        if (filePath == null) {
            throw new NullPointerException("filePath is marked non-null but is null");
        }
        if (workspace == null) {
            throw new NullPointerException("workspace is marked non-null but is null");
        }
        if (registryName == null) {
            throw new NullPointerException("registryName is marked non-null but is null");
        }
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        try (OutputStream out = Files.newOutputStream(filePath, StandardOpenOption.CREATE_NEW);){
            RestApiResponse restApiResponse = (RestApiResponse)this.restApiClient.downloadRegistryModel(out, workspace, registryName, options).blockingGet();
            return restApiResponse;
        }
    }

    /*
     * Exception decompiling
     */
    RestApiResponse downloadRegistryModelToDir(@NonNull Path dirPath, @NonNull String workspace, @NonNull String registryName, @NonNull DownloadModelOptions options) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    <T> RestApiResponse executeSyncRequest(Function<T, Single<RestApiResponse>> func, T request, String errorMessage) {
        try {
            return (RestApiResponse)func.apply(request).blockingGet();
        }
        catch (Throwable e) {
            this.logger.error(errorMessage, e);
            Throwable rootCause = ExceptionUtils.unwrap(e);
            if (rootCause instanceof CometApiException) {
                throw (CometApiException)rootCause;
            }
            throw new RuntimeException(e);
        }
    }

    private void checkRestApiResponse(RestApiResponse response, String errorMessage) {
        if (response.hasFailed()) {
            this.logger.error(errorMessage);
            throw new CometApiException(errorMessage);
        }
    }

    public static CometApiBuilder builder() {
        return new CometApiBuilderImpl();
    }

    private /* synthetic */ RestApiResponse lambda$downloadRegistryModelToDir$16(Path dirPath, Integer numFiles, RestApiResponse apiResponse) throws Throwable {
        this.logger.info(LogMessages.getString("EXTRACTED_N_REGISTRY_MODEL_FILES", numFiles, dirPath));
        return apiResponse;
    }

    private static /* synthetic */ Integer lambda$downloadRegistryModelToDir$15(PipedInputStream pin, Path dirPath) throws Exception {
        try (ZipInputStream zis = new ZipInputStream(pin);){
            Integer n = ZipUtils.unzipToFolder(zis, dirPath);
            return n;
        }
    }

    static final class CometApiBuilderImpl
    implements CometApiBuilder {
        private String apiKey;
        private Logger logger;

        CometApiBuilderImpl() {
        }

        public CometApiBuilder withConfigOverride(@NonNull File overrideConfig) {
            if (overrideConfig == null) {
                throw new NullPointerException("overrideConfig is marked non-null but is null");
            }
            CometConfig.applyConfigOverride(overrideConfig);
            return this;
        }

        @Override
        public BaseCometBuilder<CometApi> withLogger(@NonNull Logger logger) {
            if (logger == null) {
                throw new NullPointerException("logger is marked non-null but is null");
            }
            this.logger = logger;
            return this;
        }

        public CometApiBuilder withApiKey(@NonNull String apiKey) {
            if (apiKey == null) {
                throw new NullPointerException("apiKey is marked non-null but is null");
            }
            this.apiKey = apiKey;
            return this;
        }

        @Override
        public CometApi build() {
            if (StringUtils.isBlank((CharSequence)this.apiKey)) {
                this.apiKey = CometConfig.COMET_API_KEY.getString();
            }
            CometApiImpl api = new CometApiImpl(this.apiKey, CometConfig.COMET_BASE_URL.getString(), CometConfig.COMET_MAX_AUTH_RETRIES.getInt(), this.logger);
            try {
                api.init();
            }
            catch (Throwable throwable) {
                api.close();
                throw throwable;
            }
            return api;
        }
    }
}

