/*
 * Decompiled with CFR 0.152.
 */
package ml.comet.experiment.impl;

import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.disposables.Disposable;
import java.io.File;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import lombok.NonNull;
import ml.comet.experiment.artifact.ArtifactAsset;
import ml.comet.experiment.artifact.GetArtifactOptions;
import ml.comet.experiment.asset.Asset;
import ml.comet.experiment.asset.RemoteAsset;
import ml.comet.experiment.exception.CometApiException;
import ml.comet.experiment.impl.asset.ArtifactAssetImpl;
import ml.comet.experiment.impl.asset.AssetImpl;
import ml.comet.experiment.impl.asset.DownloadArtifactAssetOptions;
import ml.comet.experiment.impl.constants.FormParamName;
import ml.comet.experiment.impl.constants.QueryParamName;
import ml.comet.experiment.impl.http.Connection;
import ml.comet.experiment.impl.http.ConnectionUtils;
import ml.comet.experiment.impl.resources.LogMessages;
import ml.comet.experiment.impl.rest.AddExperimentTagsRest;
import ml.comet.experiment.impl.rest.AddGraphRest;
import ml.comet.experiment.impl.rest.ArtifactEntry;
import ml.comet.experiment.impl.rest.ArtifactRequest;
import ml.comet.experiment.impl.rest.ArtifactVersionAssetResponse;
import ml.comet.experiment.impl.rest.ArtifactVersionDetail;
import ml.comet.experiment.impl.rest.CometWebJavaSdkException;
import ml.comet.experiment.impl.rest.CreateExperimentRequest;
import ml.comet.experiment.impl.rest.CreateExperimentResponse;
import ml.comet.experiment.impl.rest.ExperimentAssetListResponse;
import ml.comet.experiment.impl.rest.ExperimentMetadataRest;
import ml.comet.experiment.impl.rest.ExperimentModelListResponse;
import ml.comet.experiment.impl.rest.ExperimentStatusResponse;
import ml.comet.experiment.impl.rest.ExperimentTimeRequest;
import ml.comet.experiment.impl.rest.GetExperimentsResponse;
import ml.comet.experiment.impl.rest.GetGraphResponse;
import ml.comet.experiment.impl.rest.GetHtmlResponse;
import ml.comet.experiment.impl.rest.GetOutputResponse;
import ml.comet.experiment.impl.rest.GetProjectsResponse;
import ml.comet.experiment.impl.rest.GetWorkspacesResponse;
import ml.comet.experiment.impl.rest.GitMetadataRest;
import ml.comet.experiment.impl.rest.HtmlRest;
import ml.comet.experiment.impl.rest.LogOtherRest;
import ml.comet.experiment.impl.rest.MetricRest;
import ml.comet.experiment.impl.rest.MinMaxResponse;
import ml.comet.experiment.impl.rest.OutputUpdate;
import ml.comet.experiment.impl.rest.ParameterRest;
import ml.comet.experiment.impl.rest.RegistryModelCreateRequest;
import ml.comet.experiment.impl.rest.RegistryModelCreateResponse;
import ml.comet.experiment.impl.rest.RegistryModelDetailsResponse;
import ml.comet.experiment.impl.rest.RegistryModelItemCreateRequest;
import ml.comet.experiment.impl.rest.RegistryModelItemCreateResponse;
import ml.comet.experiment.impl.rest.RegistryModelNotesResponse;
import ml.comet.experiment.impl.rest.RegistryModelNotesUpdateRequest;
import ml.comet.experiment.impl.rest.RegistryModelOverviewListResponse;
import ml.comet.experiment.impl.rest.RegistryModelUpdateItemRequest;
import ml.comet.experiment.impl.rest.RegistryModelUpdateRequest;
import ml.comet.experiment.impl.rest.RestApiResponse;
import ml.comet.experiment.impl.rest.SetSystemDetailsRequest;
import ml.comet.experiment.impl.rest.TagsResponse;
import ml.comet.experiment.impl.utils.JsonUtils;
import ml.comet.experiment.impl.utils.RestApiUtils;
import ml.comet.experiment.registrymodel.DownloadModelOptions;
import org.asynchttpclient.Response;

final class RestApiClient
implements Disposable {
    private Connection connection;
    private boolean disposed;
    static final IllegalStateException ALREADY_DISPOSED = new IllegalStateException("REST API client already disposed");

    RestApiClient(Connection connection) {
        this.connection = connection;
    }

    public void dispose() {
        this.disposed = true;
        this.connection = null;
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    Single<GetWorkspacesResponse> getAllWorkspaces() {
        return this.singleFromSyncGetWithRetries("/api/rest/v2/workspaces", Collections.emptyMap(), GetWorkspacesResponse.class);
    }

    Single<GetProjectsResponse> getAllProjects(String workspaceName) {
        return this.singleFromSyncGetWithRetries("/api/rest/v2/projects", Collections.singletonMap(QueryParamName.WORKSPACE_NAME, workspaceName), GetProjectsResponse.class);
    }

    Single<GetExperimentsResponse> getAllExperiments(String projectId) {
        return this.singleFromSyncGetWithRetries("/api/rest/v2/experiments", Collections.singletonMap(QueryParamName.PROJECT_ID, projectId), GetExperimentsResponse.class);
    }

    Single<GetExperimentsResponse> getAllExperiments(String projectName, String workspaceName) {
        HashMap<QueryParamName, String> params = new HashMap<QueryParamName, String>();
        params.put(QueryParamName.WORKSPACE_NAME, workspaceName);
        params.put(QueryParamName.PROJECT_NAME, projectName);
        return this.singleFromSyncGetWithRetries("/api/rest/v2/experiments", params, GetExperimentsResponse.class);
    }

    Single<ExperimentMetadataRest> getExperimentMetadata(String experimentKey) {
        return this.singleFromSyncGetWithRetries("/api/rest/v2/experiment/metadata", Collections.singletonMap(QueryParamName.EXPERIMENT_KEY, experimentKey), true, ExperimentMetadataRest.class);
    }

    Single<GitMetadataRest> getGitMetadata(String experimentKey) {
        return this.singleFromSyncGetWithRetries("/api/rest/v2/experiment/git/metadata", experimentKey, GitMetadataRest.class);
    }

    Single<GetHtmlResponse> getHtml(String experimentKey) {
        return this.singleFromSyncGetWithRetries("/api/rest/v2/experiment/html", experimentKey, GetHtmlResponse.class);
    }

    Single<GetOutputResponse> getOutput(String experimentKey) {
        return this.singleFromSyncGetWithRetries("/api/rest/v2/experiment/output", experimentKey, GetOutputResponse.class);
    }

    Single<GetGraphResponse> getGraph(String experimentKey) {
        return this.singleFromSyncGetWithRetries("/api/rest/v2/experiment/graph", experimentKey, GetGraphResponse.class);
    }

    Single<MinMaxResponse> getParameters(String experimentKey) {
        return this.singleFromSyncGetWithRetries("/api/rest/v2/experiment/parameters", experimentKey, MinMaxResponse.class);
    }

    Single<MinMaxResponse> getMetrics(String experimentKey) {
        return this.singleFromSyncGetWithRetries("/api/rest/v2/experiment/metrics/summary", experimentKey, MinMaxResponse.class);
    }

    Single<MinMaxResponse> getLogOther(String experimentKey) {
        return this.singleFromSyncGetWithRetries("/api/rest/v2/experiment/log-other", experimentKey, MinMaxResponse.class);
    }

    Single<TagsResponse> getTags(String experimentKey) {
        return this.singleFromSyncGetWithRetries("/api/rest/v2/experiment/tags", experimentKey, TagsResponse.class);
    }

    Single<ExperimentAssetListResponse> getAssetList(String experimentKey, String type) {
        HashMap<QueryParamName, String> params = new HashMap<QueryParamName, String>();
        params.put(QueryParamName.EXPERIMENT_KEY, experimentKey);
        params.put(QueryParamName.TYPE, type);
        return this.singleFromSyncGetWithRetries("/api/rest/v2/experiment/asset/list", params, ExperimentAssetListResponse.class);
    }

    Single<ExperimentStatusResponse> sendExperimentStatus(String experimentKey) {
        return this.singleFromSyncGetWithRetries("/api/rest/v2/write/experiment/set-status", experimentKey, ExperimentStatusResponse.class);
    }

    Single<RestApiResponse> logMetric(MetricRest request, String experimentKey) {
        request.setExperimentKey(experimentKey);
        return this.singleFromAsyncPost(request, "/api/rest/v2/write/experiment/metric", RestApiResponse.class);
    }

    Single<RestApiResponse> logParameter(ParameterRest request, String experimentKey) {
        request.setExperimentKey(experimentKey);
        return this.singleFromAsyncPost(request, "/api/rest/v2/write/experiment/parameter", RestApiResponse.class);
    }

    Single<RestApiResponse> logOutputLine(OutputUpdate request, String experimentKey) {
        request.setExperimentKey(experimentKey);
        return this.singleFromAsyncPost(request, "/api/rest/v2/write/experiment/output", RestApiResponse.class);
    }

    Single<RestApiResponse> logHtml(HtmlRest request, String experimentKey) {
        request.setExperimentKey(experimentKey);
        return this.singleFromAsyncPost(request, "/api/rest/v2/write/experiment/html", RestApiResponse.class);
    }

    Single<RestApiResponse> logOther(LogOtherRest request, String experimentKey) {
        request.setExperimentKey(experimentKey);
        return this.singleFromAsyncPost(request, "/api/rest/v2/write/experiment/log-other", RestApiResponse.class);
    }

    Single<RestApiResponse> addTag(AddExperimentTagsRest request, String experimentKey) {
        request.setExperimentKey(experimentKey);
        return this.singleFromAsyncPost(request, "/api/rest/v2/write/experiment/tags", RestApiResponse.class);
    }

    Single<RestApiResponse> logGraph(AddGraphRest request, String experimentKey) {
        request.setExperimentKey(experimentKey);
        return this.singleFromAsyncPost(request, "/api/rest/v2/write/experiment/graph", RestApiResponse.class);
    }

    Single<RestApiResponse> logStartEndTime(ExperimentTimeRequest request, String experimentKey) {
        request.setExperimentKey(experimentKey);
        return this.singleFromAsyncPost(request, "/api/rest/v2/write/experiment/set-start-end-time", RestApiResponse.class);
    }

    Single<RestApiResponse> logGitMetadata(GitMetadataRest request, String experimentKey) {
        request.setExperimentKey(experimentKey);
        return this.singleFromAsyncPost(request, "/api/rest/v2/write/experiment/git/metadata", RestApiResponse.class);
    }

    Single<CreateExperimentResponse> registerExperiment(CreateExperimentRequest request) {
        return this.singleFromSyncPostWithRetries(request, "/api/rest/v2/write/experiment/create", true, CreateExperimentResponse.class);
    }

    Single<RestApiResponse> logSystemDetails(SetSystemDetailsRequest request, String experimentKey) {
        request.setExperimentKey(experimentKey);
        return this.singleFromAsyncPost(request, "/api/rest/v2/write/experiment/system-details", RestApiResponse.class);
    }

    <T extends Asset> Single<RestApiResponse> logAsset(T asset, String experimentKey) {
        Map<QueryParamName, String> queryParams = RestApiUtils.assetQueryParameters((AssetImpl)asset, experimentKey);
        Map<FormParamName, Object> formParams = RestApiUtils.assetFormParameters(asset);
        if (asset instanceof ArtifactAsset) {
            queryParams.put(QueryParamName.ARTIFACT_VERSION_ID, ((ArtifactAssetImpl)asset).getArtifactVersionId());
        }
        if (asset.getFile().isPresent()) {
            return this.singleFromAsyncPost(asset.getFile().get(), "/api/rest/v2/write/experiment/upload-asset", queryParams, formParams, RestApiResponse.class);
        }
        if (asset.getFileLikeData().isPresent()) {
            return this.singleFromAsyncPost(asset.getFileLikeData().get(), "/api/rest/v2/write/experiment/upload-asset", queryParams, formParams, RestApiResponse.class);
        }
        RestApiResponse response = new RestApiResponse();
        response.setMsg("asset has no data");
        response.setCode(-1);
        return Single.just((Object)response);
    }

    <T extends RemoteAsset> Single<RestApiResponse> logRemoteAsset(T asset, String experimentKey) {
        Map<QueryParamName, String> queryParams = RestApiUtils.assetQueryParameters((AssetImpl)((Object)asset), experimentKey);
        queryParams.put(QueryParamName.IS_REMOTE, Boolean.TRUE.toString());
        if (asset instanceof ArtifactAsset) {
            queryParams.put(QueryParamName.ARTIFACT_VERSION_ID, ((ArtifactAssetImpl)asset).getArtifactVersionId());
        }
        Map<FormParamName, Object> formParams = RestApiUtils.assetFormParameters(asset);
        if (asset.getLink().isPresent()) {
            formParams.put(FormParamName.LINK, asset.getLink().get().toASCIIString());
        }
        return this.singleFromAsyncPost("/api/rest/v2/write/experiment/upload-asset", queryParams, formParams, RestApiResponse.class);
    }

    Single<ArtifactEntry> upsertArtifact(ArtifactRequest request, String experimentKey) {
        request.setExperimentKey(experimentKey);
        return this.singleFromSyncPostWithRetries(request, "/api/rest/v2/write/artifacts/upsert", true, ArtifactEntry.class);
    }

    Single<RestApiResponse> updateArtifactState(ArtifactRequest request, String experimentKey) {
        request.setExperimentKey(experimentKey);
        return this.singleFromSyncPostWithRetriesEmptyBody(request, "/api/rest/v2/write/artifacts/state");
    }

    Single<ArtifactVersionDetail> getArtifactVersionDetail(GetArtifactOptions request, String experimentKey) {
        return this.singleFromSyncGetWithRetries("/api/rest/v2/artifacts/version", RestApiUtils.artifactVersionDetailsParams(request, experimentKey), true, ArtifactVersionDetail.class);
    }

    Single<ArtifactVersionAssetResponse> getArtifactVersionFiles(GetArtifactOptions request) {
        return this.singleFromSyncGetWithRetries("/api/rest/v2/artifacts/version/files", RestApiUtils.artifactVersionFilesParams(request), true, ArtifactVersionAssetResponse.class);
    }

    Single<RestApiResponse> downloadArtifactAsset(DownloadArtifactAssetOptions options, String experimentKey) {
        Map<QueryParamName, String> queryParams = RestApiUtils.artifactDownloadAssetParams(options, experimentKey);
        return this.singleFromAsyncDownload(options.getFile(), "/api/rest/v2/experiment/asset/get-asset", queryParams);
    }

    Single<ExperimentModelListResponse> getExperimentModels(String experimentKey) {
        HashMap<QueryParamName, String> queryParams = new HashMap<QueryParamName, String>();
        queryParams.put(QueryParamName.EXPERIMENT_KEY, experimentKey);
        return this.singleFromSyncGetWithRetries("/api/rest/v2/experiment/model", queryParams, ExperimentModelListResponse.class);
    }

    Single<RegistryModelOverviewListResponse> getRegistryModelsForWorkspace(String workspaceName) {
        HashMap<QueryParamName, String> queryParams = new HashMap<QueryParamName, String>();
        queryParams.put(QueryParamName.WORKSPACE_NAME, workspaceName);
        return this.singleFromSyncGetWithRetries("/api/rest/v2/registry-model", queryParams, RegistryModelOverviewListResponse.class);
    }

    Single<RegistryModelCreateResponse> createRegistryModel(RegistryModelCreateRequest request) {
        return this.singleFromSyncPostWithRetries(request, "/api/rest/v2/write/registry-model", true, RegistryModelCreateResponse.class);
    }

    Single<RegistryModelItemCreateResponse> createRegistryModelItem(RegistryModelItemCreateRequest request) {
        return this.singleFromSyncPostWithRetries(request, "/api/rest/v2/write/registry-model/item", true, RegistryModelItemCreateResponse.class);
    }

    Single<RegistryModelDetailsResponse> getRegistryModelDetails(String modelName, String workspaceName) {
        HashMap<QueryParamName, String> queryParams = new HashMap<QueryParamName, String>();
        queryParams.put(QueryParamName.WORKSPACE_NAME, workspaceName);
        queryParams.put(QueryParamName.MODEL_NAME, modelName);
        return this.singleFromSyncGetWithRetries("/api/rest/v2/registry-model/details", queryParams, true, RegistryModelDetailsResponse.class);
    }

    Single<RestApiResponse> downloadRegistryModel(OutputStream output, String workspace, String registryName, DownloadModelOptions options) {
        Map<QueryParamName, String> queryParams = RestApiUtils.downloadModelParams(workspace, registryName, options);
        return this.singleFromAsyncDownload(output, "/api/rest/v2/registry-model/item/download", queryParams);
    }

    Single<RegistryModelNotesResponse> getRegistryModelNotes(String modelName, String workspaceName) {
        HashMap<QueryParamName, String> queryParams = new HashMap<QueryParamName, String>();
        queryParams.put(QueryParamName.WORKSPACE_NAME, workspaceName);
        queryParams.put(QueryParamName.MODEL_NAME, modelName);
        return this.singleFromSyncGetWithRetries("/api/rest/v2/registry-model/notes", queryParams, true, RegistryModelNotesResponse.class);
    }

    Single<RestApiResponse> updateRegistryModelNotes(RegistryModelNotesUpdateRequest request) {
        return this.singleFromAsyncPost(request, "/api/rest/v2/write/registry-model/notes");
    }

    Single<RestApiResponse> updateRegistryModel(RegistryModelUpdateRequest request) {
        return this.singleFromAsyncPost(request, "/api/rest/v2/write/registry-model/update");
    }

    Single<RestApiResponse> updateRegistryModelVersion(RegistryModelUpdateItemRequest request) {
        return this.singleFromAsyncPost(request, "/api/rest/v2/write/registry-model/item/update");
    }

    Single<RestApiResponse> deleteRegistryModel(String modelName, String workspaceName) {
        HashMap<QueryParamName, String> queryParams = new HashMap<QueryParamName, String>();
        queryParams.put(QueryParamName.WORKSPACE_NAME, workspaceName);
        queryParams.put(QueryParamName.MODEL_NAME, modelName);
        return this.singleFromSyncGetWithRetries("/api/rest/v2/write/registry-model/delete", queryParams);
    }

    Single<RestApiResponse> deleteRegistryModelVersion(String modelItemId) {
        HashMap<QueryParamName, String> queryParams = new HashMap<QueryParamName, String>();
        queryParams.put(QueryParamName.MODEL_ITEM_ID, modelItemId);
        return this.singleFromSyncGetWithRetries("/api/rest/v2/write/registry-model/item/delete", queryParams);
    }

    private Single<RestApiResponse> singleFromAsyncDownload(@NonNull OutputStream output, @NonNull String endpoint, @NonNull Map<QueryParamName, String> queryParams) {
        if (output == null) {
            throw new NullPointerException("output is marked non-null but is null");
        }
        if (endpoint == null) {
            throw new NullPointerException("endpoint is marked non-null but is null");
        }
        if (queryParams == null) {
            throw new NullPointerException("queryParams is marked non-null but is null");
        }
        if (this.isDisposed()) {
            return Single.error((Throwable)ALREADY_DISPOSED);
        }
        return Single.fromFuture(this.connection.downloadAsync(output, endpoint, queryParams)).map(RestApiClient::mapResponse);
    }

    private Single<RestApiResponse> singleFromAsyncDownload(@NonNull File file, @NonNull String endpoint, @NonNull Map<QueryParamName, String> queryParams) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        if (endpoint == null) {
            throw new NullPointerException("endpoint is marked non-null but is null");
        }
        if (queryParams == null) {
            throw new NullPointerException("queryParams is marked non-null but is null");
        }
        if (this.isDisposed()) {
            return Single.error((Throwable)ALREADY_DISPOSED);
        }
        return Single.fromFuture(this.connection.downloadAsync(file, endpoint, queryParams)).map(RestApiClient::mapResponse);
    }

    private Single<RestApiResponse> singleFromAsyncPost(@NonNull Object payload, @NonNull String endpoint) {
        if (payload == null) {
            throw new NullPointerException("payload is marked non-null but is null");
        }
        if (endpoint == null) {
            throw new NullPointerException("endpoint is marked non-null but is null");
        }
        if (this.isDisposed()) {
            return Single.error((Throwable)ALREADY_DISPOSED);
        }
        return Single.fromFuture(this.connection.sendPostAsync(JsonUtils.toJson(payload), endpoint)).onTerminateDetach().map(RestApiClient::mapResponse);
    }

    private <T> Single<T> singleFromAsyncPost(@NonNull String endpoint, @NonNull Map<QueryParamName, String> queryParams, @NonNull Map<FormParamName, Object> formParams, @NonNull Class<T> clazz) {
        if (endpoint == null) {
            throw new NullPointerException("endpoint is marked non-null but is null");
        }
        if (queryParams == null) {
            throw new NullPointerException("queryParams is marked non-null but is null");
        }
        if (formParams == null) {
            throw new NullPointerException("formParams is marked non-null but is null");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        if (this.isDisposed()) {
            return Single.error((Throwable)ALREADY_DISPOSED);
        }
        return Single.fromFuture(this.connection.sendPostAsync(endpoint, queryParams, formParams)).onTerminateDetach().map(response -> JsonUtils.fromJson(response.getResponseBody(), clazz));
    }

    private <T> Single<T> singleFromAsyncPost(byte[] fileLikeData, @NonNull String endpoint, @NonNull Map<QueryParamName, String> queryParams, Map<FormParamName, Object> formParams, @NonNull Class<T> clazz) {
        if (endpoint == null) {
            throw new NullPointerException("endpoint is marked non-null but is null");
        }
        if (queryParams == null) {
            throw new NullPointerException("queryParams is marked non-null but is null");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        if (this.isDisposed()) {
            return Single.error((Throwable)ALREADY_DISPOSED);
        }
        return Single.fromFuture(this.connection.sendPostAsync(fileLikeData, endpoint, queryParams, formParams)).onTerminateDetach().map(response -> JsonUtils.fromJson(response.getResponseBody(), clazz));
    }

    private <T> Single<T> singleFromAsyncPost(@NonNull File file, @NonNull String endpoint, @NonNull Map<QueryParamName, String> queryParams, Map<FormParamName, Object> formParams, @NonNull Class<T> clazz) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        if (endpoint == null) {
            throw new NullPointerException("endpoint is marked non-null but is null");
        }
        if (queryParams == null) {
            throw new NullPointerException("queryParams is marked non-null but is null");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        if (this.isDisposed()) {
            return Single.error((Throwable)ALREADY_DISPOSED);
        }
        return Single.fromFuture(this.connection.sendPostAsync(file, endpoint, queryParams, formParams)).onTerminateDetach().map(response -> JsonUtils.fromJson(response.getResponseBody(), clazz));
    }

    private <T> Single<T> singleFromAsyncPost(@NonNull Object payload, @NonNull String endpoint, @NonNull Class<T> clazz) {
        if (payload == null) {
            throw new NullPointerException("payload is marked non-null but is null");
        }
        if (endpoint == null) {
            throw new NullPointerException("endpoint is marked non-null but is null");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        if (this.isDisposed()) {
            return Single.error((Throwable)ALREADY_DISPOSED);
        }
        return Single.fromFuture(this.connection.sendPostAsync(JsonUtils.toJson(payload), endpoint)).onTerminateDetach().map(response -> JsonUtils.fromJson(response.getResponseBody(), clazz));
    }

    private <T> Single<T> singleFromSyncPostWithRetries(@NonNull Object payload, @NonNull String endpoint, boolean throwOnFailure, @NonNull Class<T> clazz) {
        if (payload == null) {
            throw new NullPointerException("payload is marked non-null but is null");
        }
        if (endpoint == null) {
            throw new NullPointerException("endpoint is marked non-null but is null");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        if (this.isDisposed()) {
            return Single.error((Throwable)ALREADY_DISPOSED);
        }
        String request = JsonUtils.toJson(payload);
        return this.connection.sendPostWithRetries(request, endpoint, throwOnFailure).map(body -> Single.just(JsonUtils.fromJson(body, clazz))).orElse(Single.error((Throwable)new CometApiException(LogMessages.getString("NO_RESPONSE_RETURNED_BY_REMOTE_ENDPOINT", endpoint))));
    }

    private Single<RestApiResponse> singleFromSyncPostWithRetriesEmptyBody(@NonNull Object payload, @NonNull String endpoint) {
        if (payload == null) {
            throw new NullPointerException("payload is marked non-null but is null");
        }
        if (endpoint == null) {
            throw new NullPointerException("endpoint is marked non-null but is null");
        }
        if (this.isDisposed()) {
            return Single.error((Throwable)ALREADY_DISPOSED);
        }
        return this.connection.sendPostWithRetries(JsonUtils.toJson(payload), endpoint, true).map(body -> Single.just((Object)new RestApiResponse(200, (String)body))).orElse(Single.error((Throwable)new CometApiException(LogMessages.getString("NO_RESPONSE_RETURNED_BY_REMOTE_ENDPOINT", endpoint))));
    }

    private Single<RestApiResponse> singleFromSyncGetWithRetries(@NonNull String endpoint, @NonNull Map<QueryParamName, String> params) {
        if (endpoint == null) {
            throw new NullPointerException("endpoint is marked non-null but is null");
        }
        if (params == null) {
            throw new NullPointerException("params is marked non-null but is null");
        }
        return this.connection.sendGetWithRetries(endpoint, params, true).map(body -> Single.just((Object)new RestApiResponse(200, (String)body))).orElse(Single.error((Throwable)new CometApiException(LogMessages.getString("NO_RESPONSE_RETURNED_BY_REMOTE_ENDPOINT", endpoint))));
    }

    private <T> Single<T> singleFromSyncGetWithRetries(@NonNull String endpoint, @NonNull String experimentKey, @NonNull Class<T> clazz) {
        if (endpoint == null) {
            throw new NullPointerException("endpoint is marked non-null but is null");
        }
        if (experimentKey == null) {
            throw new NullPointerException("experimentKey is marked non-null but is null");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        return this.singleFromSyncGetWithRetries(endpoint, Collections.singletonMap(QueryParamName.EXPERIMENT_KEY, experimentKey), false, clazz);
    }

    private <T> Single<T> singleFromSyncGetWithRetries(@NonNull String endpoint, @NonNull Map<QueryParamName, String> params, @NonNull Class<T> clazz) {
        if (endpoint == null) {
            throw new NullPointerException("endpoint is marked non-null but is null");
        }
        if (params == null) {
            throw new NullPointerException("params is marked non-null but is null");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        return this.singleFromSyncGetWithRetries(endpoint, params, false, clazz);
    }

    private <T> Single<T> singleFromSyncGetWithRetries(@NonNull String endpoint, @NonNull Map<QueryParamName, String> queryParams, boolean throwOnFailure, @NonNull Class<T> clazz) {
        if (endpoint == null) {
            throw new NullPointerException("endpoint is marked non-null but is null");
        }
        if (queryParams == null) {
            throw new NullPointerException("queryParams is marked non-null but is null");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        if (this.isDisposed()) {
            return Single.error((Throwable)ALREADY_DISPOSED);
        }
        return this.connection.sendGetWithRetries(endpoint, queryParams, throwOnFailure).map(body -> Single.just(JsonUtils.fromJson(body, clazz))).orElse(Single.error((Throwable)new CometApiException(LogMessages.getString("NO_RESPONSE_RETURNED_BY_REMOTE_ENDPOINT", endpoint))));
    }

    private static RestApiResponse mapResponse(Response response) {
        try {
            ConnectionUtils.checkResponseStatus(response);
        }
        catch (CometApiException ex) {
            return new RestApiResponse(ex.getStatusCode(), ex.getStatusMessage());
        }
        catch (CometWebJavaSdkException ex) {
            return new RestApiResponse(ex.getCode(), ex.getMsg(), ex.getSdkErrorCode());
        }
        return new RestApiResponse(200);
    }
}

