/*
 * Decompiled with CFR 0.152.
 */
package ml.comet.experiment.impl.http;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import lombok.NonNull;
import ml.comet.experiment.exception.CometApiException;
import ml.comet.experiment.impl.constants.FormParamName;
import ml.comet.experiment.impl.constants.QueryParamName;
import ml.comet.experiment.impl.rest.CometWebJavaSdkException;
import ml.comet.experiment.impl.utils.JsonUtils;
import org.asynchttpclient.Request;
import org.asynchttpclient.RequestBuilder;
import org.asynchttpclient.Response;
import org.asynchttpclient.request.body.generator.BodyGenerator;
import org.asynchttpclient.request.body.generator.ByteArrayBodyGenerator;
import org.asynchttpclient.request.body.multipart.ByteArrayPart;
import org.asynchttpclient.request.body.multipart.FileLikePart;
import org.asynchttpclient.request.body.multipart.FilePart;
import org.asynchttpclient.request.body.multipart.Part;
import org.asynchttpclient.request.body.multipart.StringPart;
import org.asynchttpclient.util.HttpConstants;
import org.slf4j.Logger;

public class ConnectionUtils {
    static Request createGetRequest(@NonNull String url, Map<QueryParamName, String> queryParams) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        return ((RequestBuilder)ConnectionUtils.createRequestBuilder(HttpConstants.Methods.GET, queryParams).setUrl(url)).build();
    }

    static Request createPostFileRequest(@NonNull File file, @NonNull String url, Map<QueryParamName, String> queryParams, Map<FormParamName, Object> formParams) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        return ((RequestBuilder)ConnectionUtils.createMultipartRequestBuilder((FileLikePart)new FilePart(FormParamName.FILE.paramName(), file), queryParams, formParams).setUrl(url)).build();
    }

    static Request createPostByteArrayRequest(byte[] bytes, @NonNull String url, Map<QueryParamName, String> queryParams, Map<FormParamName, Object> formParams) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        return ((RequestBuilder)ConnectionUtils.createMultipartRequestBuilder((FileLikePart)new ByteArrayPart(FormParamName.FILE.paramName(), bytes, HttpHeaderValues.APPLICATION_OCTET_STREAM.toString()), queryParams, formParams).setUrl(url)).build();
    }

    static Request createPostFormRequest(@NonNull String url, Map<QueryParamName, String> queryParams, @NonNull Map<FormParamName, Object> formParams) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        if (formParams == null) {
            throw new NullPointerException("formParams is marked non-null but is null");
        }
        return ((RequestBuilder)ConnectionUtils.createMultipartRequestBuilder(queryParams, formParams).setUrl(url)).build();
    }

    static Request createPostJsonRequest(@NonNull String body, @NonNull String url) {
        if (body == null) {
            throw new NullPointerException("body is marked non-null but is null");
        }
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        return ((RequestBuilder)((RequestBuilder)((RequestBuilder)((RequestBuilder)new RequestBuilder().setUrl(url)).setHeader((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)HttpHeaderValues.APPLICATION_JSON)).setBody((BodyGenerator)new ByteArrayBodyGenerator(body.getBytes(StandardCharsets.UTF_8)))).setMethod(HttpConstants.Methods.POST)).build();
    }

    static boolean isResponseSuccessful(int statusCode) {
        return statusCode >= 200 && statusCode < 300;
    }

    static RequestBuilder createRequestBuilder(@NonNull String httpMethod, Map<QueryParamName, String> queryParams) {
        if (httpMethod == null) {
            throw new NullPointerException("httpMethod is marked non-null but is null");
        }
        RequestBuilder builder = new RequestBuilder(httpMethod);
        if (Objects.nonNull(queryParams)) {
            queryParams.forEach((k, v) -> {
                if (v != null) {
                    builder.addQueryParam(k.paramName(), v);
                }
            });
        }
        return builder;
    }

    static RequestBuilder createMultipartRequestBuilder(@NonNull FileLikePart fileLikePart, Map<QueryParamName, String> queryParams, Map<FormParamName, Object> formParams) {
        if (fileLikePart == null) {
            throw new NullPointerException("fileLikePart is marked non-null but is null");
        }
        RequestBuilder builder = ConnectionUtils.createMultipartRequestBuilder(queryParams, formParams);
        builder.addBodyPart((Part)fileLikePart);
        return builder;
    }

    static RequestBuilder createMultipartRequestBuilder(Map<QueryParamName, String> queryParams, Map<FormParamName, Object> formParams) {
        RequestBuilder builder = ConnectionUtils.createRequestBuilder(HttpConstants.Methods.POST, queryParams);
        ArrayList parts = new ArrayList();
        if (Objects.nonNull(formParams)) {
            formParams.forEach((k, v) -> {
                if (v != null) {
                    parts.add(ConnectionUtils.createStringPart(k.paramName(), v));
                }
            });
        }
        ((RequestBuilder)builder.setHeader((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)HttpHeaderValues.MULTIPART_FORM_DATA)).setBodyParts(parts);
        return builder;
    }

    public static void checkResponseStatus(@NonNull Response response) throws CometWebJavaSdkException, CometApiException {
        if (response == null) {
            throw new NullPointerException("response is marked non-null but is null");
        }
        int statusCode = response.getStatusCode();
        if (ConnectionUtils.isResponseSuccessful(statusCode)) {
            return;
        }
        if ((statusCode == 400 || statusCode == 403 || statusCode == 405) && response.hasResponseBody()) {
            throw JsonUtils.fromJson(response.getResponseBody(), CometWebJavaSdkException.class);
        }
        throw new CometApiException(response.getStatusCode(), response.getStatusText(), 0);
    }

    private static Part createStringPart(String name, @NonNull Object value) {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        return new StringPart(name, value.toString());
    }

    public static final class DebugLogResponse
    implements Function<Response, Response> {
        private final Logger logger;
        private final String endpoint;

        @Override
        public Response apply(Response response) {
            if (ConnectionUtils.isResponseSuccessful(response.getStatusCode())) {
                this.logger.debug("for endpoint {} got response {}\n", (Object)this.endpoint, (Object)response.getResponseBody());
            } else {
                this.logger.error("for endpoint {} got response {}\n", (Object)this.endpoint, (Object)response.getStatusText());
            }
            return response;
        }

        public DebugLogResponse(Logger logger, String endpoint) {
            this.logger = logger;
            this.endpoint = endpoint;
        }

        public Logger getLogger() {
            return this.logger;
        }

        public String getEndpoint() {
            return this.endpoint;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DebugLogResponse)) {
                return false;
            }
            DebugLogResponse other = (DebugLogResponse)o;
            Logger this$logger = this.getLogger();
            Logger other$logger = other.getLogger();
            if (this$logger == null ? other$logger != null : !this$logger.equals(other$logger)) {
                return false;
            }
            String this$endpoint = this.getEndpoint();
            String other$endpoint = other.getEndpoint();
            return !(this$endpoint == null ? other$endpoint != null : !this$endpoint.equals(other$endpoint));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Logger $logger = this.getLogger();
            result = result * 59 + ($logger == null ? 43 : $logger.hashCode());
            String $endpoint = this.getEndpoint();
            result = result * 59 + ($endpoint == null ? 43 : $endpoint.hashCode());
            return result;
        }

        public String toString() {
            return "ConnectionUtils.DebugLogResponse(logger=" + this.getLogger() + ", endpoint=" + this.getEndpoint() + ")";
        }
    }
}

