/*
 * Decompiled with CFR 0.152.
 */
package ml.comet.experiment.impl.rest;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Arrays;
import ml.comet.experiment.model.Curve;
import ml.comet.experiment.model.DataPoint;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class CurveData {
    private String name;
    private float[] x;
    private float[] y;

    private CurveData() {
    }

    public static CurveData from(Curve curve) {
        CurveData data = new CurveData();
        data.name = curve.getName();
        DataPoint[] dataPoints = curve.getDataPoints();
        data.x = new float[dataPoints.length];
        data.y = new float[dataPoints.length];
        for (int i = 0; i < dataPoints.length; ++i) {
            data.x[i] = dataPoints[i].getX();
            data.y[i] = dataPoints[i].getY();
        }
        return data;
    }

    public String getName() {
        return this.name;
    }

    public float[] getX() {
        return this.x;
    }

    public float[] getY() {
        return this.y;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setX(float[] x) {
        this.x = x;
    }

    public void setY(float[] y) {
        this.y = y;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CurveData)) {
            return false;
        }
        CurveData other = (CurveData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        if (!Arrays.equals(this.getX(), other.getX())) {
            return false;
        }
        return Arrays.equals(this.getY(), other.getY());
    }

    protected boolean canEqual(Object other) {
        return other instanceof CurveData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        result = result * 59 + Arrays.hashCode(this.getX());
        result = result * 59 + Arrays.hashCode(this.getY());
        return result;
    }

    public String toString() {
        return "CurveData(name=" + this.getName() + ", x=" + Arrays.toString(this.getX()) + ", y=" + Arrays.toString(this.getY()) + ")";
    }
}

